/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.configurations.DataTypeConfiguration;
import org.eclipse.vtp.framework.common.configurations.FieldConfiguration;
import org.eclipse.vtp.framework.common.support.ScriptableArray;

public class DataTypeRegistry
implements IDataTypeRegistry,
IScriptable {
    private final Map dataTypes;

    public DataTypeRegistry(IExtensionRegistry extensionRegistry, DataTypeConfiguration[] configurations) {
        DataType type;
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>();
        String zero = String.valueOf(0);
        dataTypes.put("Array", new DataType("Array", "length", "Number", zero));
        dataTypes.put("Boolean", new DataType("Boolean"));
        dataTypes.put("Date", new DataType("Date"));
        dataTypes.put("Decimal", new DataType("Decimal"));
        dataTypes.put("Number", new DataType("Number"));
        dataTypes.put("String", new DataType("String", "length", "Number", zero));
        IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.vtp.framework.common.dataTypes");
        int i = 0;
        while (i < elements.length) {
            type = new DataType(elements[i]);
            dataTypes.put(type.getName(), type);
            ++i;
        }
        i = 0;
        while (i < configurations.length) {
            type = new DataType(configurations[i]);
            dataTypes.put(type.getName(), type);
            ++i;
        }
        this.dataTypes = Collections.unmodifiableMap(new HashMap(dataTypes));
    }

    public final IDataType getDataType(String typeName) throws NullPointerException {
        if (typeName == null) {
            throw new NullPointerException("typeName");
        }
        return (DataType)this.dataTypes.get(typeName);
    }

    public final String getName() {
        return "DataTypes";
    }

    public boolean hasValue() {
        return false;
    }

    public Object toValue() {
        return null;
    }

    public final String[] getFunctionNames() {
        return new String[0];
    }

    public final Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    public final boolean hasItem(int index) {
        return false;
    }

    public final boolean hasEntry(String name) {
        return this.getDataType(name) != null;
    }

    public final Object getItem(int index) {
        return null;
    }

    public final Object getEntry(String name) {
        return this.getDataType(name);
    }

    public final boolean setItem(int index, Object value) {
        return false;
    }

    public final boolean setEntry(String name, Object value) {
        return false;
    }

    public final boolean clearItem(int index) {
        return false;
    }

    public final boolean clearEntry(String name) {
        return false;
    }

    private final class DataType
    implements IDataType,
    IScriptable {
        private final String name;
        private final Field[] fields;
        private final Field primaryField;
        private final ScriptableArray fieldArray;

        DataType(String name) {
            this.name = name;
            this.fields = new Field[0];
            this.primaryField = null;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(String name, String fieldName, String fieldTypeName, String fieldInitialValue) {
            this.name = name;
            this.fields = new Field[]{new Field(fieldName, fieldTypeName, fieldInitialValue)};
            this.primaryField = null;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(DataTypeConfiguration configuration) {
            this.name = configuration.getName();
            FieldConfiguration[] fieldConfigs = configuration.getFields();
            this.fields = new Field[fieldConfigs.length];
            String primaryFieldName = configuration.getPrimaryField();
            Field primaryField = null;
            int i = 0;
            while (i < fieldConfigs.length) {
                this.fields[i] = new Field(fieldConfigs[i].getName(), fieldConfigs[i].getType(), fieldConfigs[i].getInitialValue());
                if (this.fields[i].getName().equals(primaryFieldName)) {
                    primaryField = this.fields[i];
                }
                ++i;
            }
            this.primaryField = primaryField;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        DataType(IConfigurationElement configuration) {
            this.name = configuration.getAttribute("name");
            IConfigurationElement[] fieldConfigs = configuration.getChildren("field");
            this.fields = new Field[fieldConfigs.length];
            String primaryFieldName = configuration.getAttribute("primary-field");
            Field primaryField = null;
            int i = 0;
            while (i < fieldConfigs.length) {
                this.fields[i] = new Field(fieldConfigs[i].getAttribute("name"), fieldConfigs[i].getAttribute("type"), fieldConfigs[i].getAttribute("initial-value"));
                if (this.fields[i].getName().equals(primaryFieldName)) {
                    primaryField = this.fields[i];
                }
                ++i;
            }
            this.primaryField = primaryField;
            this.fieldArray = new ScriptableArray("fields", this.fields);
        }

        public String getName() {
            return this.name;
        }

        public String[] getFieldNames() {
            String[] fieldNames = new String[this.fields.length];
            int i = 0;
            while (i < this.fields.length) {
                fieldNames[i] = this.fields[i].name;
                ++i;
            }
            return fieldNames;
        }

        public String getPrimaryFieldName() {
            return this.primaryField == null ? null : this.primaryField.name;
        }

        public IDataType getFieldType(String fieldName) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].name.equals(fieldName)) {
                    return this.fields[i].getType();
                }
                ++i;
            }
            return null;
        }

        public String getFieldInitialValue(String fieldName) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].name.equals(fieldName)) {
                    return this.fields[i].initalValue;
                }
                ++i;
            }
            return null;
        }

        public boolean isArrayType() {
            return "Array".equals(this.name);
        }

        public boolean isComplexType() {
            return !this.isArrayType() && !this.isSimpleType();
        }

        public boolean isSimpleType() {
            return "Boolean".equals(this.name) || "Date".equals(this.name) || "Decimal".equals(this.name) || "Number".equals(this.name) || "String".equals(this.name);
        }

        public boolean hasValue() {
            return true;
        }

        public Object toValue() {
            return this.name;
        }

        public String[] getFunctionNames() {
            return new String[]{"isArray", "isComplex", "isSimple"};
        }

        public Object invokeFunction(String name, Object[] arguments) {
            if ("isArray".equals(name)) {
                return this.isArrayType() ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isComplex".equals(name)) {
                return this.isComplexType() ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("isSimple".equals(name)) {
                return this.isSimpleType() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        public boolean hasItem(int index) {
            return false;
        }

        public boolean hasEntry(String name) {
            return "name".equals(name) || "fields".equals(name);
        }

        public Object getItem(int index) {
            return null;
        }

        public Object getEntry(String name) {
            if ("name".equals(name)) {
                return this.name;
            }
            if ("fields".equals(name)) {
                return this.fieldArray;
            }
            return null;
        }

        public boolean setItem(int index, Object value) {
            return false;
        }

        public boolean setEntry(String name, Object value) {
            return false;
        }

        public boolean clearItem(int index) {
            return false;
        }

        public boolean clearEntry(String name) {
            return false;
        }

        public String toString() {
            return this.name;
        }

        private final class Field
        implements IScriptable {
            final String name;
            final String typeName;
            final String initalValue;

            Field(String name, String typeName, String initalValue) {
                this.name = name;
                this.typeName = typeName;
                this.initalValue = initalValue;
            }

            IDataType getType() {
                return DataTypeRegistry.this.getDataType(this.typeName);
            }

            public String getName() {
                return this.name;
            }

            public boolean hasValue() {
                return true;
            }

            public Object toValue() {
                return this.name;
            }

            public String[] getFunctionNames() {
                return new String[0];
            }

            public Object invokeFunction(String name, Object[] arguments) {
                return null;
            }

            public boolean hasItem(int index) {
                return false;
            }

            public boolean hasEntry(String name) {
                return "name".equals(name) || "type".equals(name) || "initalValue".equals(name);
            }

            public Object getItem(int index) {
                return null;
            }

            public Object getEntry(String name) {
                if ("name".equals(name)) {
                    return this.name;
                }
                if ("type".equals(name)) {
                    return this.getType();
                }
                if ("initalValue".equals(name)) {
                    return this.initalValue;
                }
                return null;
            }

            public boolean setItem(int index, Object value) {
                return false;
            }

            public boolean setEntry(String name, Object value) {
                return false;
            }

            public boolean clearItem(int index) {
                return false;
            }

            public boolean clearEntry(String name) {
                return false;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

