/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.IScriptingContext;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingProvider;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.core.IContext;

public final class ScriptingService
implements IScriptingService {
    private static final String LOOKUP_PREFIX = String.valueOf(IScriptingProvider.class.getName()) + ":SCRIPTING_LANGUAGE=";
    private final IContext serviceRegistry;
    private final Set scriptables;
    private final ScriptingService parent;
    private final Map contexts = new HashMap();

    public ScriptingService(IContext serviceRegistry, IScriptable[] scriptables) {
        this(serviceRegistry, scriptables, null);
    }

    public ScriptingService(IContext serviceRegistry, IScriptable[] scriptables, ScriptingService parent) {
        this.serviceRegistry = serviceRegistry;
        LinkedHashMap<String, IScriptable> map = new LinkedHashMap<String, IScriptable>();
        int i = 0;
        while (i < scriptables.length) {
            if (!(map.containsKey(scriptables[i].getName()) || parent != null && parent.contains(scriptables[i]))) {
                map.put(scriptables[i].getName(), scriptables[i]);
            }
            ++i;
        }
        this.scriptables = Collections.unmodifiableSet(new LinkedHashSet(map.values()));
        this.parent = parent;
    }

    private boolean contains(IScriptable scriptable) {
        return this.scriptables.contains(scriptable) || this.parent != null && this.parent.contains(scriptable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IScriptingContext getScriptingContext(String scriptingLanuage) {
        Map map = this.contexts;
        synchronized (map) {
            if (this.contexts.containsKey(scriptingLanuage)) {
                return (IScriptingContext)this.contexts.get(scriptingLanuage);
            }
        }
        IScriptingContext context = null;
        if (this.parent != null) {
            IScriptingContext parentContext = this.parent.getScriptingContext(scriptingLanuage);
            if (parentContext != null) {
                context = parentContext.createScriptingContext(this.scriptables.toArray(new IScriptable[this.scriptables.size()]));
            }
        } else {
            Object obj = this.serviceRegistry.lookup(String.valueOf(LOOKUP_PREFIX) + scriptingLanuage);
            if (obj instanceof IScriptingProvider) {
                context = ((IScriptingProvider)obj).createScriptingContext(scriptingLanuage, this.scriptables.toArray(new IScriptable[this.scriptables.size()]));
            }
        }
        Map map2 = this.contexts;
        synchronized (map2) {
            if (this.contexts.containsKey(scriptingLanuage)) {
                context = (IScriptingContext)this.contexts.get(scriptingLanuage);
            } else {
                this.contexts.put(scriptingLanuage, context);
            }
        }
        return context;
    }

    public IScriptingEngine createScriptingEngine(String scriptingLanuage) {
        if (scriptingLanuage == null) {
            return null;
        }
        IScriptingContext context = this.getScriptingContext(scriptingLanuage);
        if (context == null) {
            return null;
        }
        return context.createScriptingEngine();
    }
}

