/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.support.CustomDataField;
import org.eclipse.vtp.framework.common.support.CustomDataType;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.util.Guid;

public class VariableRegistry
implements IVariableRegistry,
IScriptable {
    private static final String ENTRY_PREFIX = "variable.entries.";
    private static final String RECORD_PREFIX = "variable.records.";
    private final ISessionContext context;
    private final IDataTypeRegistry dataTypeRegistry;
    private final Map variables = new HashMap();

    public VariableRegistry(ISessionContext context, IDataTypeRegistry dataTypeRegistry) {
        this.context = context;
        this.dataTypeRegistry = dataTypeRegistry;
    }

    private DataObject createObject(IDataType type) {
        return this.createObject(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataObject createObject(IDataType type, Object initialValue) {
        DataObject variable = null;
        variable = type.equals(this.dataTypeRegistry.getDataType(type.getName())) ? ("Array".equals(type.getName()) ? new ArrayObject() : ("Boolean".equals(type.getName()) ? new BooleanObject(initialValue) : ("Date".equals(type.getName()) ? new DateObject(initialValue) : ("Decimal".equals(type.getName()) ? new DecimalObject(initialValue) : ("Number".equals(type.getName()) ? new NumberObject(initialValue) : ("String".equals(type.getName()) ? new StringObject(initialValue) : new ComplexObject(type))))))) : new ComplexObject(type);
        Map map = this.variables;
        synchronized (map) {
            this.variables.put(variable.id, variable);
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataObject loadObject(String id) {
        DataObject variable = null;
        Map map = this.variables;
        synchronized (map) {
            Object[] record;
            variable = (DataObject)this.variables.get(id);
            if (variable == null && (record = this.getRecord(id)) != null) {
                IDataType type = (IDataType)record[0];
                variable = "Array".equals(type.getName()) ? new ArrayObject(id) : ("Boolean".equals(type.getName()) ? new BooleanObject(id) : ("Date".equals(type.getName()) ? new DateObject(id) : ("Decimal".equals(type.getName()) ? new DecimalObject(id) : ("Number".equals(type.getName()) ? new NumberObject(id) : ("String".equals(type.getName()) ? new StringObject(id) : new ComplexObject(id, type))))));
                this.variables.put(id, variable);
            }
        }
        return variable;
    }

    private Object[] getRecord(String id) {
        Object attribute = this.context.getAttribute(id);
        if (!(attribute instanceof Object[])) {
            return null;
        }
        Object[] record = (Object[])attribute;
        if (record.length != 2) {
            return null;
        }
        if (!(record[0] instanceof String)) {
            return null;
        }
        String typeName = (String)record[0];
        if (typeName.startsWith("!")) {
            CustomDataType type = null;
            String[] array = typeName.substring(0).split(",");
            CustomDataField[] fields = new CustomDataField[array.length - 2];
            int i = 2;
            while (i < array.length) {
                String[] field = array[i].split(":");
                fields[i - 2] = new CustomDataField(field[0], this.dataTypeRegistry.getDataType(field[1]), field[2]);
                ++i;
            }
            type = new CustomDataType(array[0], array[1].length() == 0 ? null : array[1], fields);
            return new Object[]{type, record[1]};
        }
        IDataType type = this.dataTypeRegistry.getDataType(typeName);
        if (type == null) {
            return null;
        }
        return new Object[]{type, record[1]};
    }

    private void setRecord(String id, IDataType type, Object value) {
        if (type.equals(this.dataTypeRegistry.getDataType(type.getName()))) {
            this.context.setAttribute(id, (Object)new Object[]{type.getName(), value});
        } else {
            StringBuffer b = new StringBuffer("!");
            b.append(type.getName()).append(',');
            if (type.getPrimaryFieldName() != null) {
                b.append(type.getPrimaryFieldName());
            }
            String[] fields = type.getFieldNames();
            int i = 0;
            while (i < fields.length) {
                b.append(',').append(fields[i]).append(':').append(type.getFieldType(fields[i]).getName()).append(':').append(type.getFieldInitialValue(fields[i]));
                ++i;
            }
            this.context.setAttribute(id, (Object)new Object[]{b.toString(), value});
        }
    }

    public final IDataObject createVariable(String typeName) throws IllegalArgumentException, NullPointerException {
        IDataType type = this.dataTypeRegistry.getDataType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("typeName");
        }
        return this.createVariable(type);
    }

    public final IDataObject createVariable(IDataType type) throws IllegalArgumentException, NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.createObject(type);
    }

    public final String[] getVariableNames() {
        String[] storageKeys = this.context.getAttributeNames();
        LinkedList<String> variableNames = new LinkedList<String>();
        int i = 0;
        while (i < storageKeys.length) {
            if (storageKeys[i].startsWith(ENTRY_PREFIX)) {
                variableNames.add(storageKeys[i].substring(ENTRY_PREFIX.length()));
            }
            ++i;
        }
        return variableNames.toArray(new String[variableNames.size()]);
    }

    public final IDataObject getVariable(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String rootName = st.nextToken();
        String id = (String)this.context.getAttribute(ENTRY_PREFIX + rootName);
        if (id == null) {
            return null;
        }
        IDataObject variable = this.loadObject(id);
        while (variable != null && st.hasMoreTokens()) {
            variable = variable.getField(st.nextToken());
        }
        return variable;
    }

    public final void setVariable(String name, IDataObject variable) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (variable == null) {
            throw new NullPointerException("variable");
        }
        if (!(variable instanceof DataObject)) {
            throw new IllegalArgumentException("variable");
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        if (!st.hasMoreTokens()) {
            return;
        }
        String rootName = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.context.setAttribute(ENTRY_PREFIX + rootName, (Object)((DataObject)variable).id);
        } else {
            String id = (String)this.context.getAttribute(ENTRY_PREFIX + st.nextToken());
            if (id == null) {
                return;
            }
            IDataObject parent = this.loadObject(id);
            String childName = st.nextToken();
            while (parent != null && st.hasMoreTokens()) {
                parent = parent.getField(childName);
                childName = st.nextToken();
            }
            if (parent != null) {
                parent.setField(childName, variable);
            }
        }
    }

    public final void clearVariable(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.context.clearAttribute(ENTRY_PREFIX + name);
    }

    public final String getName() {
        return "Variables";
    }

    public boolean hasValue() {
        return false;
    }

    public Object toValue() {
        return null;
    }

    public final String[] getFunctionNames() {
        return new String[]{"create"};
    }

    public final Object invokeFunction(String name, Object[] arguments) {
        if ("create".equals(name)) {
            if (arguments.length < 1) {
                return null;
            }
            IDataType type = null;
            type = arguments[0] instanceof IDataType ? (IDataType)arguments[0] : this.dataTypeRegistry.getDataType(String.valueOf(arguments[0]));
            if (type == null) {
                return null;
            }
            return this.createVariable(type);
        }
        return null;
    }

    public final boolean hasItem(int index) {
        return false;
    }

    public final boolean hasEntry(String name) {
        return this.getVariable(name) != null;
    }

    public final Object getItem(int index) {
        return null;
    }

    public final Object getEntry(String name) {
        return this.getVariable(name);
    }

    public final boolean setItem(int index, Object value) {
        return false;
    }

    public final boolean setEntry(String name, Object value) {
        if (value == null) {
            return this.clearEntry(name);
        }
        if (value instanceof IDataObject) {
            this.setVariable(name, (IDataObject)value);
            return true;
        }
        IDataObject variable = this.getVariable(name);
        if (variable == null) {
            variable = this.createVariable("String");
            this.setVariable(name, variable);
        }
        if (variable instanceof SimpleObject) {
            ((SimpleObject)variable).setEntry("value", value);
        }
        return true;
    }

    public final boolean clearItem(int index) {
        return false;
    }

    public final boolean clearEntry(String name) {
        this.clearVariable(name);
        return true;
    }

    private final class ArrayObject
    extends DataObject
    implements IArrayObject {
        final NumberObject lengthField;

        ArrayObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Array"));
            this.lengthField = new NumberObject(VariableRegistry.this){

                public boolean isReadOnly() {
                    return true;
                }

                public Integer getValue() {
                    return new Integer(((String[])ArrayObject.this.load()).length);
                }
            };
            this.save(new String[0]);
        }

        ArrayObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Array"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (this.load() == null) {
                this.save(new String[0]);
            }
        }

        public INumberObject getLength() {
            return this.lengthField;
        }

        public IDataObject getElement(int index) throws IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] itemIDs = (String[])this.load();
            if (index >= itemIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return itemIDs[index] == null ? null : VariableRegistry.this.loadObject(itemIDs[index]);
        }

        public void addElement(IDataObject item) throws IllegalArgumentException, IllegalStateException {
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            String[] newIDs = new String[oldIDs.length + 1];
            System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
            newIDs[oldIDs.length] = item == null ? null : ((DataObject)item).id;
            this.save(newIDs);
        }

        public void insertElement(int index, IDataObject item) throws IllegalArgumentException, IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            if (index > oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length + 1];
            if (index > 0) {
                System.arraycopy(oldIDs, 0, newIDs, 0, index);
            }
            String string = newIDs[index] = item == null ? null : ((DataObject)item).id;
            if (index < oldIDs.length) {
                System.arraycopy(oldIDs, index, newIDs, index + 1, oldIDs.length - index);
            }
            this.save(newIDs);
        }

        public void setElement(int index, IDataObject item) throws IllegalArgumentException, IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            if (item != null && !(item instanceof DataObject)) {
                throw new IllegalArgumentException("item");
            }
            String[] oldIDs = (String[])this.load();
            if (index >= oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length];
            System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
            newIDs[index] = item == null ? null : ((DataObject)item).id;
            this.save(newIDs);
        }

        public void removeElement(int index) throws IllegalStateException, IndexOutOfBoundsException {
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] oldIDs = (String[])this.load();
            if (index >= oldIDs.length) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            String[] newIDs = new String[oldIDs.length - 1];
            if (index > 0) {
                System.arraycopy(oldIDs, 0, newIDs, 0, index);
            }
            if (index < newIDs.length) {
                System.arraycopy(oldIDs, index + 1, newIDs, index, newIDs.length - index);
            }
            this.save(newIDs);
        }

        public IDataObject getField(String fieldName) {
            return "length".equals(fieldName) || "numberOfItems".equals(fieldName) ? this.lengthField : super.getField(fieldName);
        }

        public boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (!(object instanceof IArrayObject)) {
                return false;
            }
            IArrayObject other = (IArrayObject)object;
            String[] itemIDs = (String[])this.load();
            if (itemIDs.length != other.getLength().getValue()) {
                return false;
            }
            int i = 0;
            while (i < itemIDs.length) {
                IDataObject theirs;
                DataObject ours = itemIDs[i] == null ? null : VariableRegistry.this.loadObject(itemIDs[i]);
                if (ours != (theirs = other.getElement(i))) {
                    if (ours == null || theirs == null) {
                        return false;
                    }
                    if (!ours.isEqualTo(theirs)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public boolean hasItem(int index) {
            return index >= 0 && index < ((String[])this.load()).length;
        }

        public Object getItem(int index) {
            try {
                return this.getElement(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        public boolean setItem(int index, Object value) {
            if (!(value instanceof IDataObject)) {
                return false;
            }
            if (index == ((String[])this.load()).length) {
                this.addElement((IDataObject)value);
                return true;
            }
            try {
                this.setElement(index, (IDataObject)value);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            return true;
        }

        public boolean clearItem(int index) {
            try {
                this.removeElement(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer().append('[');
            String[] itemIDs = (String[])this.load();
            int i = 0;
            while (i < itemIDs.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(itemIDs[i] == null ? null : VariableRegistry.this.loadObject(itemIDs[i]));
                ++i;
            }
            return buffer.append(']').toString();
        }
    }

    private final class BooleanObject
    extends SimpleObject
    implements IBooleanObject {
        BooleanObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
        }

        BooleanObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        BooleanObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Boolean"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        Comparable coerce(Object obj) {
            if (obj == null) {
                return Boolean.FALSE;
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof IBooleanObject) {
                return ((IBooleanObject)obj).getValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (obj instanceof INumberObject) {
                return ((INumberObject)obj).getValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            String string = obj.toString();
            if ("true".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("yes".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("on".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("1".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("no".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("off".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if ("0".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            return null;
        }

        public Boolean getValue() {
            return (Boolean)this.load();
        }

        public boolean setValue(Object value) throws IllegalStateException {
            Comparable coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private final class ComplexObject
    extends DataObject {
        private final String[] fieldNames;

        ComplexObject(IDataType type) {
            super(null, type);
            this.fieldNames = type.getFieldNames();
            String[] fieldIDs = new String[this.fieldNames.length];
            int i = 0;
            while (i < this.fieldNames.length) {
                fieldIDs[i] = ((VariableRegistry)VariableRegistry.this).createObject((IDataType)type.getFieldType((String)this.fieldNames[i]), (Object)type.getFieldInitialValue((String)this.fieldNames[i])).id;
                ++i;
            }
            this.save(fieldIDs);
        }

        ComplexObject(String id, IDataType type) {
            super(id, type);
            this.fieldNames = type.getFieldNames();
            String[] fieldIDs = (String[])this.load();
            if (fieldIDs == null) {
                fieldIDs = new String[this.fieldNames.length];
                int i = 0;
                while (i < this.fieldNames.length) {
                    fieldIDs[i] = ((VariableRegistry)VariableRegistry.this).createObject((IDataType)type.getFieldType((String)this.fieldNames[i]), (Object)type.getFieldInitialValue((String)this.fieldNames[i])).id;
                    ++i;
                }
                this.save(fieldIDs);
            }
        }

        public IDataObject getField(String fieldName) {
            int i = 0;
            while (i < this.fieldNames.length) {
                if (this.fieldNames[i].equals(fieldName)) {
                    String id = ((String[])this.load())[i];
                    if (id == null) {
                        return null;
                    }
                    return VariableRegistry.this.loadObject(id);
                }
                ++i;
            }
            return null;
        }

        public boolean setField(String fieldName, IDataObject variable) {
            if (variable != null) {
                if (!(variable instanceof DataObject)) {
                    return false;
                }
                if (!variable.getType().equals(this.type.getFieldType(fieldName))) {
                    return false;
                }
            }
            int i = 0;
            while (i < this.fieldNames.length) {
                if (this.fieldNames[i].equals(fieldName)) {
                    String[] oldIDs = (String[])this.load();
                    String[] newIDs = new String[oldIDs.length];
                    System.arraycopy(oldIDs, 0, newIDs, 0, oldIDs.length);
                    newIDs[i] = variable == null ? null : ((DataObject)variable).id;
                    this.save(newIDs);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (!(object instanceof IDataObject)) {
                return false;
            }
            IDataObject other = (IDataObject)object;
            if (!this.type.equals(other.getType())) {
                return false;
            }
            String[] fieldIDs = (String[])this.load();
            int i = 0;
            while (i < this.fieldNames.length) {
                IDataObject theirs;
                DataObject ours = fieldIDs[i] == null ? null : VariableRegistry.this.loadObject(fieldIDs[i]);
                if (ours != (theirs = other.getField(this.fieldNames[i]))) {
                    if (ours == null || theirs == null) {
                        return false;
                    }
                    if (!ours.isEqualTo(theirs)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public boolean hasValue() {
            return this.type.getPrimaryFieldName() != null;
        }

        public Object toValue() {
            return this.getField(this.type.getPrimaryFieldName());
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.type.getName()).append('{');
            String[] fieldIDs = (String[])this.load();
            int i = 0;
            while (i < this.fieldNames.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.fieldNames[i]).append('=').append(fieldIDs[i] == null ? null : VariableRegistry.this.loadObject(fieldIDs[i]));
                ++i;
            }
            return buffer.append('}').toString();
        }
    }

    private abstract class DataObject
    implements IDataObject,
    IScriptable {
        final String id;
        final IDataType type;

        DataObject(String id, IDataType type) {
            this.id = id == null ? VariableRegistry.RECORD_PREFIX + Guid.createGUID() : id;
            this.type = type;
        }

        Object load() {
            Object[] record = VariableRegistry.this.getRecord(this.id);
            if (record == null) {
                return null;
            }
            return record[1];
        }

        void save(Object value) throws IllegalStateException {
            if (this.isReadOnly()) {
                throw new IllegalStateException();
            }
            VariableRegistry.this.setRecord(this.id, this.type, value);
        }

        public final IDataType getType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return false;
        }

        public IDataObject getField(String fieldName) {
            return null;
        }

        public boolean setField(String fieldName, IDataObject variable) {
            return false;
        }

        public boolean isEqualTo(Object object) {
            return this.equals(object);
        }

        public boolean isGreaterThan(Object object) {
            return false;
        }

        public boolean isGreaterThanOrEqualTo(Object object) {
            return this.isGreaterThan(object) || this.isEqualTo(object);
        }

        public boolean isLessThan(Object object) {
            return false;
        }

        public boolean isLessThanOrEqualTo(Object object) {
            return this.isLessThan(object) || this.isEqualTo(object);
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            return this.id.equals(((DataObject)obj).id);
        }

        public final String getName() {
            return this.id;
        }

        public boolean hasValue() {
            return false;
        }

        public Object toValue() {
            return null;
        }

        public final String[] getFunctionNames() {
            return new String[]{"getType", "isReadOnly", "isEqualTo", "isGreaterThan", "isGreaterThanOrEqualTo", "isLessThan", "isLessThanOrEqualTo"};
        }

        public final Object invokeFunction(String name, Object[] arguments) {
            if ("getType".equals(name)) {
                return this.getType();
            }
            if ("isReadOnly".equals(name)) {
                return this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (arguments.length > 0) {
                if ("isEqualTo".equals(name)) {
                    return this.isEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("isGreaterThan".equals(name)) {
                    return this.isGreaterThan(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("isGreaterThanOrEqualTo".equals(name)) {
                    return this.isGreaterThanOrEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("isLessThan".equals(name)) {
                    return this.isLessThan(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("isLessThanOrEqualTo".equals(name)) {
                    return this.isLessThanOrEqualTo(arguments[0]) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            return null;
        }

        public boolean hasItem(int index) {
            return false;
        }

        public boolean hasEntry(String name) {
            return this.getField(name) != null;
        }

        public Object getItem(int index) {
            return null;
        }

        public Object getEntry(String name) {
            return this.getField(name);
        }

        public boolean setItem(int index, Object value) {
            return false;
        }

        public boolean setEntry(String name, Object value) {
            if (value instanceof IDataObject) {
                return this.setField(name, (IDataObject)value);
            }
            IDataObject variable = this.getField(name);
            if (variable == null) {
                variable = VariableRegistry.this.createVariable(this.type.getFieldType(name));
                this.setField(name, variable);
            }
            if (variable instanceof SimpleObject) {
                ((SimpleObject)variable).setEntry("value", value);
            }
            return true;
        }

        public boolean clearItem(int index) {
            return false;
        }

        public boolean clearEntry(String name) {
            return this.setField(name, null);
        }
    }

    private final class DateObject
    extends SimpleObject
    implements IDateObject {
        DateObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
        }

        DateObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        DateObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Date"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        Comparable coerce(Object obj) {
            if (obj == null) {
                return new Date();
            }
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj instanceof Long) {
                return new Date((Long)obj);
            }
            if (obj instanceof IDateObject) {
                return ((IDateObject)obj).getValue();
            }
            if (obj instanceof String) {
                String inValue = (String)obj;
                System.err.println("So the date is supposed to be: " + inValue);
                return new Date(Date.parse(inValue));
            }
            return null;
        }

        public Date getValue() {
            return (Date)this.load();
        }

        public boolean setValue(Object value) throws IllegalStateException {
            Comparable coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private final class DecimalObject
    extends SimpleObject
    implements IDecimalObject {
        DecimalObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
        }

        DecimalObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        DecimalObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Decimal"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        Comparable coerce(Object obj) {
            if (obj == null) {
                return BigDecimal.valueOf(0L);
            }
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof BigInteger) {
                new BigDecimal((BigInteger)obj);
            }
            if (obj instanceof Float || obj instanceof Double) {
                return BigDecimal.valueOf(((Number)obj).doubleValue());
            }
            if (obj instanceof Number) {
                return BigDecimal.valueOf(((Number)obj).longValue());
            }
            if (obj instanceof IDecimalObject) {
                return ((IDecimalObject)obj).getValue();
            }
            if (obj instanceof INumberObject) {
                return BigDecimal.valueOf(((INumberObject)obj).getValue().longValue());
            }
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public BigDecimal getValue() {
            return (BigDecimal)this.load();
        }

        public boolean setValue(Object value) throws IllegalStateException {
            Comparable coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private class NumberObject
    extends SimpleObject
    implements INumberObject {
        NumberObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
        }

        NumberObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        NumberObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("Number"));
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        Comparable coerce(Object obj) {
            System.err.println("The object is " + obj);
            if (obj == null) {
                return new Integer(0);
            }
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            if (obj instanceof Number) {
                return new Integer(((Number)obj).intValue());
            }
            if (obj instanceof INumberObject) {
                return ((INumberObject)obj).getValue();
            }
            try {
                System.err.println("I have no idea what it is....");
                System.err.println("trying string: " + obj.toString());
                return new Integer(obj.toString());
            }
            catch (NumberFormatException e) {
                System.err.println("damn");
                e.printStackTrace();
                return null;
            }
        }

        public Integer getValue() {
            return (Integer)this.load();
        }

        public boolean setValue(Object value) throws IllegalStateException {
            Comparable coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }

    private abstract class SimpleObject
    extends DataObject {
        SimpleObject(String id, IDataType type) {
            super(id, type);
        }

        abstract Comparable coerce(Object var1);

        public final boolean isEqualTo(Object object) {
            if (super.isEqualTo(object)) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Comparable other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo(this.toValue()) == 0;
        }

        public final boolean isGreaterThan(Object object) {
            if (object == this) {
                return false;
            }
            if (object == null) {
                return false;
            }
            Comparable other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo(this.toValue()) < 0;
        }

        public final boolean isGreaterThanOrEqualTo(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Comparable other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo(this.toValue()) <= 0;
        }

        public final boolean isLessThan(Object object) {
            if (object == this) {
                return false;
            }
            if (object == null) {
                return false;
            }
            Comparable other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo(this.toValue()) > 0;
        }

        public final boolean isLessThanOrEqualTo(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Comparable other = this.coerce(object);
            if (other == null) {
                return false;
            }
            return other.compareTo(this.toValue()) >= 0;
        }

        public boolean hasValue() {
            return true;
        }

        public Object toValue() {
            return this.getEntry("value");
        }

        public final boolean hasEntry(String name) {
            return "value".equals(name) || super.hasEntry(name);
        }

        public final boolean clearEntry(String name) {
            if ("value".equals(name)) {
                return this.setEntry(name, null);
            }
            return super.clearEntry(name);
        }

        public final String toString() {
            return String.valueOf(this.toValue());
        }
    }

    private final class StringObject
    extends SimpleObject
    implements IStringObject {
        final NumberObject lengthField;

        StringObject() {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new NumberObject(VariableRegistry.this){

                public boolean isReadOnly() {
                    return true;
                }

                public Integer getValue() {
                    return new Integer(StringObject.this.getValue().length());
                }
            };
        }

        StringObject(Object initialValue) {
            super(null, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (!this.setValue(initialValue)) {
                this.setValue(null);
            }
        }

        StringObject(String id) {
            super(id, VariableRegistry.this.dataTypeRegistry.getDataType("String"));
            this.lengthField = new /* invalid duplicate definition of identical inner class */;
            if (this.getValue() == null) {
                this.setValue(null);
            }
        }

        Comparable coerce(Object obj) {
            if (obj == null) {
                return new String();
            }
            if (obj instanceof IStringObject) {
                return ((IStringObject)obj).getValue();
            }
            return obj.toString();
        }

        public INumberObject getLength() {
            return this.lengthField;
        }

        public String getValue() {
            return (String)this.load();
        }

        public boolean setValue(Object value) throws IllegalStateException {
            Comparable coerced = this.coerce(value);
            if (coerced == null) {
                return false;
            }
            this.save(coerced);
            return true;
        }

        public IDataObject getField(String fieldName) {
            return "length".equals(fieldName) ? this.lengthField : super.getField(fieldName);
        }

        public Object getEntry(String name) {
            if ("value".equals(name)) {
                return this.getValue();
            }
            return super.getEntry(name);
        }

        public boolean setEntry(String name, Object value) {
            if ("value".equals(name)) {
                return this.setValue(value);
            }
            return super.setEntry(name, value);
        }
    }
}

