/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.support;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.support.CustomDataField;

public class CustomDataType
implements IDataType {
    private final String name;
    private final String primaryFieldName;
    private final Map fields;

    public CustomDataType(String name, String primaryFieldName, CustomDataField[] fields) {
        this.name = name;
        this.primaryFieldName = primaryFieldName;
        this.fields = new HashMap(fields.length);
        int i = 0;
        while (i < fields.length) {
            this.fields.put(fields[i].getName(), fields[i]);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryFieldName() {
        return this.primaryFieldName;
    }

    public String[] getFieldNames() {
        return this.fields.keySet().toArray(new String[this.fields.size()]);
    }

    public String getFieldInitialValue(String fieldName) {
        return ((CustomDataField)this.fields.get(fieldName)).getInitialValue();
    }

    public IDataType getFieldType(String fieldName) {
        return ((CustomDataField)this.fields.get(fieldName)).getType();
    }

    public boolean isSimpleType() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isComplexType() {
        return true;
    }
}

