/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.actions;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceCallConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceInputConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceMappingConfiguration;

public class WebServiceCallAction
implements IAction {
    private static final Map PRIMITIVE_WRAPPERS;
    private static final Map DEFAULT_VALUES;
    private final IActionContext context;
    private final IVariableRegistry variables;
    private final String portName;
    private final String operationName;
    private final String locatorName;
    private final String resultName;
    private final IDataType arrayType;
    private final IDataType resultType;
    private final boolean resultArray;
    private final List mappings;
    private final List inputs;

    static {
        HashMap<Class<Comparable<Boolean>>, Object> map = new HashMap<Class<Comparable<Boolean>>, Object>(8);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Character.TYPE, Character.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(map);
        map = new HashMap(8);
        map.put(Boolean.TYPE, Boolean.FALSE);
        map.put(Byte.TYPE, new Byte(0));
        map.put(Short.TYPE, new Short(0));
        map.put(Character.TYPE, new Character('\u0000'));
        map.put(Integer.TYPE, new Integer(0));
        map.put(Float.TYPE, new Float(0.0f));
        map.put(Double.TYPE, new Double(0.0));
        map.put(Long.TYPE, new Long(0L));
        DEFAULT_VALUES = Collections.unmodifiableMap(map);
    }

    public WebServiceCallAction(IActionContext context, IDataTypeRegistry types, IVariableRegistry variables, WebServiceCallConfiguration configuration) {
        this.context = context;
        this.variables = variables;
        String portName = configuration.getPort();
        if (portName.endsWith("_PortType")) {
            portName = portName.substring(0, portName.length() - 9);
        }
        this.portName = portName;
        this.operationName = configuration.getOperation();
        String packageName = "org.eclipse.vtp.framework.synthetic_ws." + configuration.getWebService().replace(' ', '_') + ".";
        this.locatorName = String.valueOf(packageName) + configuration.getLocator();
        this.resultName = configuration.getResultName();
        this.arrayType = types.getDataType("Array");
        this.resultType = types.getDataType(configuration.getResultType());
        this.resultArray = configuration.isResultArray();
        WebServiceInputConfiguration[] inputConfigs = configuration.getInputs();
        ArrayList<Input> inputs = new ArrayList<Input>(inputConfigs.length);
        int i = 0;
        while (i < inputConfigs.length) {
            inputs.add(new Input(inputConfigs[i]));
            ++i;
        }
        this.mappings = Collections.unmodifiableList(Arrays.asList(configuration.getMappings()));
        this.inputs = Collections.unmodifiableList(inputs);
    }

    public IActionResult execute() {
        Class locatorClass = null;
        try {
            locatorClass = this.context.loadClass(this.locatorName);
        }
        catch (ClassNotFoundException e) {
            return this.context.createResult("error.webservice.connection", (Throwable)e);
        }
        Method locateMethod = null;
        try {
            locateMethod = locatorClass.getMethod("get" + new StringBuffer().append(Character.toUpperCase(this.portName.charAt(0))).append(this.portName.substring(1)).toString(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return this.context.createResult("error.webservice.connection", (Throwable)e);
        }
        Object locator = null;
        try {
            locator = locatorClass.newInstance();
        }
        catch (Exception e) {
            return this.context.createResult("error.webservice.connection", (Throwable)e);
        }
        Object service = null;
        try {
            service = locateMethod.invoke(locator, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return this.context.createResult("error.webservice.connection", e.getTargetException());
        }
        catch (Exception e) {
            return this.context.createResult("error.webservice.connection", (Throwable)e);
        }
        Method method = null;
        Method[] methods = service.getClass().getMethods();
        int i = 0;
        while (method == null && i < methods.length) {
            if (methods[i].getName().equals(this.operationName)) {
                method = methods[i];
            }
            ++i;
        }
        if (method == null) {
            return this.context.createResult("error.webservice.connection", (Throwable)new Exception("Operation method not found: " + this.operationName));
        }
        Class<?>[] parameters = method.getParameterTypes();
        Object[] arguments = new Object[parameters.length];
        int index = 0;
        Iterator i2 = this.inputs.iterator();
        while (i2.hasNext()) {
            arguments[index] = this.convert(parameters[index], ((Input)i2.next()).value);
            this.context.debug("argument " + index + " = " + arguments[index]);
            ++index;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event", "wscall.before");
        ((Dictionary)props).put("wscall.port", this.portName);
        ((Dictionary)props).put("wscall.operation", this.operationName);
        ((Dictionary)props).put("wscall.target", this.resultName);
        this.context.report(3, "Calling web service...", props);
        Object result = null;
        try {
            result = method.invoke(service, arguments);
        }
        catch (InvocationTargetException e) {
            return this.context.createResult("error.webservice.connection", e.getTargetException());
        }
        catch (Exception e) {
            return this.context.createResult("error.webservice.connection", (Throwable)e);
        }
        ((Dictionary)props).put("event", "wscall.after");
        this.context.report(3, "Called web service and got back \"" + result + "\".", props);
        if (result == null) {
            return this.context.createResult("default");
        }
        Object[] results = null;
        if (result instanceof Object[]) {
            results = (Object[])result;
        } else if (result.getClass().isArray()) {
            results = new Object[Array.getLength(result)];
            int i3 = 0;
            while (i3 < results.length) {
                results[i3] = Array.get(result, i3);
                ++i3;
            }
        } else {
            results = new Object[]{result};
        }
        IDataObject variable = this.variables.getVariable(this.resultName);
        if (this.resultArray) {
            if (variable == null || !this.arrayType.equals(variable.getType())) {
                variable = this.variables.createVariable(this.arrayType);
                this.variables.setVariable(this.resultName, variable);
            }
            int i4 = 0;
            while (i4 < results.length) {
                IDataObject element = this.variables.createVariable(this.resultType);
                ((IArrayObject)variable).addElement(element);
                this.map(results[i4], element);
                ++i4;
            }
        } else {
            if (variable == null || !this.resultType.equals(variable.getType())) {
                variable = this.variables.createVariable(this.resultType);
                this.variables.setVariable(this.resultName, variable);
            }
            if (results.length > 0) {
                this.map(results[0], variable);
            }
        }
        return this.context.createResult("default");
    }

    private void map(Object result, IDataObject variable) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event", "wscall.mapping");
        ((Dictionary)props).put("wscall.port", this.portName);
        ((Dictionary)props).put("wscall.operation", this.operationName);
        ((Dictionary)props).put("wscall.target", this.resultName);
        this.context.report(3, "Mapping \"" + result + "\" to \"" + variable.getType() + "\".", props);
        if (variable.getType().isSimpleType()) {
            WebServiceMappingConfiguration mapping = (WebServiceMappingConfiguration)this.mappings.iterator().next();
            Object value = null;
            if (mapping.getType() == 2) {
                value = mapping.getValue();
            } else if (mapping.getType() == 1) {
                value = this.resolve(mapping.getValue(), result);
            }
            if (value == null) {
                value = result;
            }
            if (variable instanceof IBooleanObject) {
                ((IBooleanObject)variable).setValue(value);
            } else if (variable instanceof IDateObject) {
                ((IDateObject)variable).setValue(value);
            } else if (variable instanceof IDecimalObject) {
                ((IDecimalObject)variable).setValue(value);
            } else if (variable instanceof INumberObject) {
                ((INumberObject)variable).setValue(value);
            } else if (variable instanceof IStringObject) {
                ((IStringObject)variable).setValue(value);
            }
            return;
        }
        for (WebServiceMappingConfiguration mapping : this.mappings) {
            IDataObject field = variable.getField(mapping.getName());
            Object value = null;
            if (mapping.getType() == 2) {
                value = mapping.getValue();
            } else if (mapping.getType() == 1) {
                value = this.resolve(mapping.getValue(), result);
            }
            if (value == null) continue;
            if (field instanceof IBooleanObject) {
                ((IBooleanObject)field).setValue(value);
                continue;
            }
            if (field instanceof IDateObject) {
                ((IDateObject)field).setValue(value);
                continue;
            }
            if (field instanceof IDecimalObject) {
                ((IDecimalObject)field).setValue(value);
                continue;
            }
            if (field instanceof INumberObject) {
                ((INumberObject)field).setValue(value);
                continue;
            }
            if (!(field instanceof IStringObject)) continue;
            ((IStringObject)field).setValue(value);
        }
    }

    private Object resolve(String path, Object obj) {
        if (path.equals("result")) {
            return obj;
        }
        if (!path.startsWith("result.")) {
            return null;
        }
        return this.acquire(path.substring(7), obj);
    }

    private Object acquire(String path, Object obj) {
        this.context.debug("Acquiring value for: " + path);
        int dot = path.indexOf(46);
        String property = dot < 0 ? path : path.substring(0, dot);
        String nextPath = dot < 0 ? null : path.substring(dot + 1);
        Method method = null;
        try {
            method = obj.getClass().getMethod(new StringBuffer("get").append(Character.toUpperCase(property.charAt(0))).append(property.substring(1)).toString(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        Object value = null;
        try {
            value = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.context.debug("Acquired value: " + value);
        if (nextPath == null) {
            return value;
        }
        if (value != null) {
            return this.acquire(nextPath, value);
        }
        return null;
    }

    private Object convert(Class type, Object value) {
        if (value == null) {
            return DEFAULT_VALUES.get(type);
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive()) {
                if (value.getClass().isArray()) {
                    if (value.getClass().getComponentType().isPrimitive()) {
                        return this.convertPrimitiveArrayToPrimitiveArray(type.getComponentType(), value);
                    }
                    return this.convertObjectArrayToPrimitiveArray(type.getComponentType(), (Object[])value);
                }
                return this.convertObjectToPrimitiveArray(type.getComponentType(), value);
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType().isPrimitive()) {
                    return this.convertPrimitiveArrayToObjectArray(type.getComponentType(), value);
                }
                return this.convertObjectArrayToObjectArray(type.getComponentType(), (Object[])value);
            }
            return this.convertObjectToObjectArray(type.getComponentType(), value);
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return this.convertPrimitiveArrayToObject(type, value);
            }
            return this.convertObjectArrayToObject(type, (Object[])value);
        }
        return this.convertObjectToObject(type, value);
    }

    private Object convertObjectToObject(Class type, Object objectValue) {
        if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
            if (objectValue instanceof Boolean) {
                return objectValue;
            }
            return objectValue instanceof Boolean ? objectValue : (Boolean.TRUE.toString().equalsIgnoreCase(objectValue.toString()) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (Byte.class.equals((Object)type) || Byte.TYPE.equals(type)) {
            try {
                return objectValue instanceof Byte ? objectValue : (objectValue instanceof Number ? new Byte(((Number)objectValue).byteValue()) : new Byte(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Byte.TYPE);
            }
        }
        if (Short.class.equals((Object)type) || Short.TYPE.equals(type)) {
            try {
                return objectValue instanceof Short ? objectValue : (objectValue instanceof Number ? new Short(((Number)objectValue).shortValue()) : new Short(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Short.TYPE);
            }
        }
        if (Character.class.equals((Object)type) || Character.TYPE.equals(type)) {
            return objectValue instanceof Character ? objectValue : (objectValue.toString().length() == 0 ? DEFAULT_VALUES.get(Character.TYPE) : new Character(objectValue.toString().charAt(0)));
        }
        if (Integer.class.equals((Object)type) || Integer.TYPE.equals(type)) {
            try {
                return objectValue instanceof Integer ? objectValue : (objectValue instanceof Number ? new Integer(((Number)objectValue).intValue()) : new Integer(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Integer.TYPE);
            }
        }
        if (Float.class.equals((Object)type) || Float.TYPE.equals(type)) {
            try {
                return objectValue instanceof Float ? objectValue : (objectValue instanceof Number ? new Float(((Number)objectValue).floatValue()) : new Float(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Float.TYPE);
            }
        }
        if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
            try {
                return objectValue instanceof Long ? objectValue : (objectValue instanceof Number ? new Long(((Number)objectValue).longValue()) : new Long(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Long.TYPE);
            }
        }
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            try {
                return objectValue instanceof Double ? objectValue : (objectValue instanceof Number ? new Double(((Number)objectValue).doubleValue()) : new Double(objectValue.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                return DEFAULT_VALUES.get(Double.TYPE);
            }
        }
        if (BigDecimal.class.equals((Object)type)) {
            try {
                return objectValue instanceof BigDecimal ? objectValue : new BigDecimal(objectValue.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (BigInteger.class.equals((Object)type)) {
            try {
                return objectValue instanceof Double ? objectValue : new BigInteger(objectValue.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (Date.class.equals((Object)type)) {
            try {
                return objectValue instanceof Date ? objectValue : (objectValue instanceof Calendar ? new Date(((Calendar)objectValue).getTimeInMillis()) : (objectValue instanceof Number ? new Date(((Number)objectValue).longValue()) : SimpleDateFormat.getDateTimeInstance().parse(objectValue.toString())));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        if (Calendar.class.equals((Object)type)) {
            if (objectValue instanceof Calendar) {
                return objectValue;
            }
            Calendar instance = Calendar.getInstance();
            if (objectValue instanceof Date) {
                instance.setTime((Date)objectValue);
            } else if (objectValue instanceof Number) {
                instance.setTimeInMillis(((Number)objectValue).longValue());
            } else {
                try {
                    instance.setTime(SimpleDateFormat.getDateTimeInstance().parse(objectValue.toString()));
                }
                catch (ParseException parseException) {
                    instance = null;
                }
            }
            return instance;
        }
        if (String.class.equals((Object)type)) {
            return objectValue.toString();
        }
        return null;
    }

    private Object convertObjectArrayToObject(Class type, Object[] objectValues) {
        return objectValues.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, objectValues[0]);
    }

    private Object convertPrimitiveArrayToObject(Class type, Object primitiveValues) {
        if (Boolean.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            boolean[] inputArray = (boolean[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, inputArray[0] ? Boolean.TRUE : Boolean.FALSE);
        }
        if (Byte.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            byte[] inputArray = (byte[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Byte(inputArray[0]));
        }
        if (Short.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            short[] inputArray = (short[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Short(inputArray[0]));
        }
        if (Character.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            char[] inputArray = (char[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Character(inputArray[0]));
        }
        if (Integer.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            int[] inputArray = (int[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Integer(inputArray[0]));
        }
        if (Float.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            float[] inputArray = (float[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Float(inputArray[0]));
        }
        if (Long.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            long[] inputArray = (long[])primitiveValues;
            return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Long(inputArray[0]));
        }
        double[] inputArray = (double[])primitiveValues;
        return inputArray.length == 0 ? DEFAULT_VALUES.get(type) : this.convertObjectToObject(type, new Double(inputArray[0]));
    }

    private Object[] convertObjectToObjectArray(Class componentType, Object objectValue) {
        Object[] result = (Object[])Array.newInstance(componentType, 1);
        result[0] = this.convertObjectToObject(componentType, objectValue);
        return result;
    }

    private Object[] convertObjectArrayToObjectArray(Class componentType, Object[] objectValues) {
        Object[] result = (Object[])Array.newInstance(componentType, objectValues.length);
        int i = 0;
        while (i < objectValues.length) {
            result[i] = this.convertObjectToObject(componentType, objectValues[i]);
            ++i;
        }
        return result;
    }

    private Object[] convertPrimitiveArrayToObjectArray(Class componentType, Object primitiveValues) {
        if (Boolean.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            boolean[] inputArray = (boolean[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, inputArray[i] ? Boolean.TRUE : Boolean.FALSE);
                ++i;
            }
            return result;
        }
        if (Byte.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            byte[] inputArray = (byte[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Byte(inputArray[i]));
                ++i;
            }
            return result;
        }
        if (Short.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            short[] inputArray = (short[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Short(inputArray[i]));
                ++i;
            }
            return result;
        }
        if (Character.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            char[] inputArray = (char[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Character(inputArray[i]));
                ++i;
            }
            return result;
        }
        if (Integer.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            int[] inputArray = (int[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Integer(inputArray[i]));
                ++i;
            }
            return result;
        }
        if (Float.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            float[] inputArray = (float[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Float(inputArray[i]));
                ++i;
            }
            return result;
        }
        if (Long.TYPE.equals(primitiveValues.getClass().getComponentType())) {
            long[] inputArray = (long[])primitiveValues;
            Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
            int i = 0;
            while (i < inputArray.length) {
                result[i] = this.convertObjectToObject(componentType, new Long(inputArray[i]));
                ++i;
            }
            return result;
        }
        double[] inputArray = (double[])primitiveValues;
        Object[] result = (Object[])Array.newInstance(componentType, inputArray.length);
        int i = 0;
        while (i < inputArray.length) {
            result[i] = this.convertObjectToObject(componentType, new Double(inputArray[i]));
            ++i;
        }
        return result;
    }

    private Object convertObjectToPrimitiveArray(Class componentType, Object objectValue) {
        Object[] result = (Object[])Array.newInstance(objectValue.getClass(), 1);
        result[0] = objectValue;
        return this.convertObjectArrayToPrimitiveArray(componentType, result);
    }

    private Object convertObjectArrayToPrimitiveArray(Class componentType, Object[] objectValues) {
        if (Boolean.TYPE.equals(componentType)) {
            boolean[] result = new boolean[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = (Boolean)this.convertObjectToObject(componentType, objectValues[i]);
                ++i;
            }
            return result;
        }
        if (Byte.TYPE.equals(componentType)) {
            byte[] result = new byte[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = (Byte)this.convertObjectToObject(componentType, objectValues[i]);
                ++i;
            }
            return result;
        }
        if (Short.TYPE.equals(componentType)) {
            short[] result = new short[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = (Short)this.convertObjectToObject(componentType, objectValues[i]);
                ++i;
            }
            return result;
        }
        if (Character.TYPE.equals(componentType)) {
            char[] result = new char[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = ((Character)this.convertObjectToObject(componentType, objectValues[i])).charValue();
                ++i;
            }
            return result;
        }
        if (Integer.TYPE.equals(componentType)) {
            int[] result = new int[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = (Integer)this.convertObjectToObject(componentType, objectValues[i]);
                ++i;
            }
            return result;
        }
        if (Float.TYPE.equals(componentType)) {
            float[] result = new float[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = ((Float)this.convertObjectToObject(componentType, objectValues[i])).floatValue();
                ++i;
            }
            return result;
        }
        if (Long.TYPE.equals(componentType)) {
            long[] result = new long[objectValues.length];
            int i = 0;
            while (i < objectValues.length) {
                result[i] = (Long)this.convertObjectToObject(componentType, objectValues[i]);
                ++i;
            }
            return result;
        }
        double[] result = new double[objectValues.length];
        int i = 0;
        while (i < objectValues.length) {
            result[i] = (Double)this.convertObjectToObject(componentType, objectValues[i]);
            ++i;
        }
        return result;
    }

    private Object extract(IDataObject value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArrayObject) {
            IArrayObject array = (IArrayObject)value;
            Object[] objects = new Object[array.getLength().getValue().intValue()];
            int i = 0;
            while (i < objects.length) {
                objects[i] = this.extract(array.getElement(i));
                ++i;
            }
            return objects;
        }
        if (value instanceof IBooleanObject) {
            return ((IBooleanObject)value).getValue();
        }
        if (value instanceof IDateObject) {
            return ((IDateObject)value).getValue();
        }
        if (value instanceof IDecimalObject) {
            return ((IDecimalObject)value).getValue();
        }
        if (value instanceof INumberObject) {
            return ((INumberObject)value).getValue();
        }
        return value.toString();
    }

    private Object convertPrimitiveArrayToPrimitiveArray(Class componentType, Object primitiveValues) {
        return this.convertObjectArrayToPrimitiveArray(componentType, this.convertPrimitiveArrayToObjectArray((Class)PRIMITIVE_WRAPPERS.get(componentType), primitiveValues));
    }

    private final class Input {
        final String name;
        final Object value;

        Input(WebServiceInputConfiguration configuration) {
            this.name = configuration.getName();
            switch (configuration.getType()) {
                case 2: {
                    this.value = configuration.getValue();
                    break;
                }
                case 1: {
                    this.value = WebServiceCallAction.this.extract(WebServiceCallAction.this.variables.getVariable(configuration.getValue()));
                    break;
                }
                default: {
                    this.value = null;
                }
            }
        }
    }
}

