/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConstants;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceInputConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceMappingConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServiceCallConfiguration
implements IConfiguration,
WebServiceConstants {
    private String locator = "";
    private String webService = "";
    private String port = "";
    private String operation = "";
    private String resultName = "";
    private String resultType = null;
    private boolean resultArray = true;
    private final Set inputs = new LinkedHashSet();
    private final Set mappings = new LinkedHashSet();

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public String getWebService() {
        return this.webService;
    }

    public void setWebService(String webService) {
        this.webService = webService == null ? "" : webService;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port == null ? "" : port;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName == null ? "" : resultName;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public boolean isResultArray() {
        return this.resultArray;
    }

    public void setResultArray(boolean resultArray) {
        this.resultArray = resultArray;
    }

    public WebServiceInputConfiguration[] getInputs() {
        return this.inputs.toArray(new WebServiceInputConfiguration[this.inputs.size()]);
    }

    public void addInput(WebServiceInputConfiguration input) {
        if (input != null) {
            this.inputs.add(input);
        }
    }

    public void removeInput(WebServiceInputConfiguration input) {
        if (input != null) {
            this.inputs.remove(input);
        }
    }

    public WebServiceMappingConfiguration[] getMappings() {
        return this.mappings.toArray(new WebServiceMappingConfiguration[this.mappings.size()]);
    }

    public void addMapping(WebServiceMappingConfiguration mapping) {
        if (mapping != null) {
            this.mappings.add(mapping);
        }
    }

    public void removeMapping(WebServiceMappingConfiguration mapping) {
        if (mapping != null) {
            this.mappings.remove(mapping);
        }
    }

    public void load(Element configurationElement) {
        IConfiguration item;
        Element element;
        this.locator = configurationElement.getAttribute("locator");
        this.webService = configurationElement.getAttribute("web-service");
        this.port = configurationElement.getAttribute("port");
        this.operation = configurationElement.getAttribute("operation");
        this.resultName = configurationElement.getAttribute("result-name");
        this.resultType = configurationElement.hasAttribute("result-type") ? configurationElement.getAttribute("result-type") : null;
        this.resultArray = "many".equalsIgnoreCase(configurationElement.getAttribute("result-cardinality"));
        this.inputs.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", "input");
        int i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            item = new WebServiceInputConfiguration();
            item.load(element);
            this.inputs.add(item);
            ++i;
        }
        this.mappings.clear();
        list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", "mapping");
        i = 0;
        while (i < list.getLength()) {
            element = (Element)list.item(i);
            item = new WebServiceMappingConfiguration();
            item.load(element);
            this.mappings.add(item);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        Element element;
        configurationElement.setAttribute("locator", this.locator);
        configurationElement.setAttribute("web-service", this.webService);
        configurationElement.setAttribute("port", this.port);
        configurationElement.setAttribute("operation", this.operation);
        configurationElement.setAttribute("result-name", this.resultName);
        if (this.resultType != null) {
            configurationElement.setAttribute("result-type", this.resultType);
        }
        if (this.resultArray) {
            configurationElement.setAttribute("result-cardinality", "many");
        }
        String inputName = "input";
        String mappingName = "mapping";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            inputName = String.valueOf(prefix) + ":" + inputName;
            mappingName = String.valueOf(prefix) + ":" + mappingName;
        }
        for (IConfiguration item : this.inputs) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", inputName);
            item.save(element);
            configurationElement.appendChild(element);
        }
        for (IConfiguration item : this.mappings) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", mappingName);
            item.save(element);
            configurationElement.appendChild(element);
        }
    }
}

