/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServiceConfiguration
implements IConfiguration,
WebServiceConstants {
    private String name = "";
    private final Map endpoints = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String[] getPorts() {
        return this.endpoints.keySet().toArray(new String[this.endpoints.size()]);
    }

    public String getEndpoint(String port) {
        return (String)this.endpoints.get(port);
    }

    public void setEndpoint(String port, String endpoint) {
        if (endpoint == null) {
            this.endpoints.remove(port);
        } else {
            this.endpoints.put(port, endpoint);
        }
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        this.endpoints.clear();
        NodeList list = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", "endpoint");
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            try {
                this.endpoints.put(element.getAttribute("port"), XMLUtilities.getElementTextData((Element)element, (boolean)true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        String endpointName = "endpoint";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            endpointName = String.valueOf(prefix) + ":" + endpointName;
        }
        for (Map.Entry entry : this.endpoints.entrySet()) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/webservices/configurations", endpointName);
            element.setAttribute("port", (String)entry.getKey());
            element.appendChild(configurationElement.getOwnerDocument().createTextNode((String)entry.getValue()));
            configurationElement.appendChild(element);
        }
    }
}

