/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConstants;
import org.w3c.dom.Element;

public class WebServiceMappingConfiguration
implements IConfiguration,
WebServiceConstants {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_FIELD = 1;
    public static final int TYPE_STATIC = 2;
    private String name = "";
    private int type = -1;
    private String value = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        String typeStr = configurationElement.getAttribute("type");
        this.type = "field".equalsIgnoreCase(typeStr) ? 1 : ("static".equalsIgnoreCase(typeStr) ? 2 : 0);
        this.value = configurationElement.hasAttribute("value") ? configurationElement.getAttribute("value") : null;
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        switch (this.type) {
            case 1: {
                configurationElement.setAttribute("type", "field");
                break;
            }
            case 2: {
                configurationElement.setAttribute("type", "static");
                break;
            }
            default: {
                configurationElement.setAttribute("type", "none");
            }
        }
        if (this.value != null) {
            configurationElement.setAttribute("value", this.value);
        }
    }
}

