/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.webservices.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.webservices.IWebService;
import org.eclipse.vtp.framework.webservices.IWebServiceRegistry;
import org.eclipse.vtp.framework.webservices.configurations.WebServiceConfiguration;

public class WebServiceRegistry
implements IWebServiceRegistry {
    private final Map webServices;

    public WebServiceRegistry(WebServiceConfiguration[] configurations) {
        HashMap<String, WebService> webServices = new HashMap<String, WebService>(configurations.length);
        int i = 0;
        while (i < configurations.length) {
            webServices.put(configurations[i].getName(), new WebService(configurations[i]));
            ++i;
        }
        this.webServices = Collections.unmodifiableMap(webServices);
    }

    public String[] getWebServiceNames() {
        return this.webServices.keySet().toArray(new String[this.webServices.size()]);
    }

    public IWebService getWebService(String webServiceName) {
        return (IWebService)this.webServices.get(webServiceName);
    }

    private final class WebService
    implements IWebService {
        private final String name;
        private final Map endpoints;

        public WebService(WebServiceConfiguration configuration) {
            this.name = configuration.getName();
            String[] ports = configuration.getPorts();
            HashMap<String, URL> endpoints = new HashMap<String, URL>(ports.length);
            int i = 0;
            while (i < ports.length) {
                String endpoint = configuration.getEndpoint(ports[i]);
                try {
                    if (endpoint != null) {
                        endpoints.put(ports[i], new URL(endpoint));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.endpoints = Collections.unmodifiableMap(endpoints);
        }

        public String getName() {
            return this.name;
        }

        public String[] getConfiguredPorts() {
            return this.endpoints.keySet().toArray(new String[this.endpoints.size()]);
        }

        public URL getEndpointAddress(String configuredPortName) {
            return (URL)this.endpoints.get(configuredPortName);
        }
    }
}

