/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.dialogs.ContentPage;
import org.eclipse.vtp.desktop.editors.core.commands.BeginConnector;
import org.eclipse.vtp.desktop.editors.core.commands.Command;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.commands.LocateElement;
import org.eclipse.vtp.desktop.editors.core.commands.ShowProperties;
import org.eclipse.vtp.desktop.editors.core.commands.StartMove;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.controller.ModelNavigationListener;
import org.eclipse.vtp.desktop.editors.core.dialogs.CanvasPropertiesDialog;
import org.eclipse.vtp.desktop.editors.core.dialogs.CreateDialogTemplateWizard;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentElement;
import org.eclipse.vtp.desktop.editors.core.elements.DialogElement;
import org.eclipse.vtp.desktop.editors.core.elements.DialogElementManager;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.properties.AttachedDataPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.impl.ConnectorPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.impl.DialogCustomizerWindow;
import org.eclipse.vtp.desktop.editors.core.model.DialogContainer;
import org.eclipse.vtp.desktop.editors.core.model.FragmentContainer;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.core.model.UIComponent;
import org.eclipse.vtp.desktop.editors.core.model.UIConnector;
import org.eclipse.vtp.desktop.editors.core.model.UIElement;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ElementFrame;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesDialog;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.views.pallet.PallateProviderManager;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class BasicController
implements CommandListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
PaintListener,
DropTargetListener,
DragSourceListener,
KeyListener,
RenderedCanvasListener {
    RenderedCanvas currentCanvas;
    Point commandPosition = null;
    List listeners = new ArrayList();
    Map resourceMap = new HashMap();
    Control interactionSurface = null;
    boolean dragging = false;
    Point dragPoint = null;
    boolean isLine = false;
    boolean isArea = false;
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    IAdaptable adaptableContainer = null;
    BrandManager brandManager = null;
    List providers = null;

    public BasicController(BrandManager brandManager, RenderedCanvas renderedCanvas) {
        this.currentCanvas = renderedCanvas;
        this.currentCanvas.addListener(this);
        this.brandManager = brandManager;
        this.providers = PallateProviderManager.getPallateProviders();
        renderedCanvas.getUICanvas().validateCanvasStatus();
    }

    public void setContainer(IAdaptable adaptableContainer) {
        this.adaptableContainer = adaptableContainer;
    }

    public void setResourceMap(Map resourceMap) {
        this.resourceMap = resourceMap;
    }

    public void showConnectorProperties(Connector connector) {
        System.out.println("Show properties!");
        try {
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            boolean canDelete = connector.getExitCodes().isEmpty();
            if (connector.getModel().getBrandManager().getSupportedInteractionTypes().size() < 1) {
                MessageDialog.openError((Shell)workbenchShell, (String)"No Media Projects Defined", (String)"There are currently no media projects defined for this desing project.  Please right click on the project and select Properties.  Navigate to the Build Path settings panel and add at least one media project.");
                if (canDelete) {
                    connector.getModel().removeConnector(connector);
                }
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
                return;
            }
            ComponentPropertiesDialog cpd = new ComponentPropertiesDialog(this.brandManager, workbenchShell);
            Color dialogFrameColor = new Color((Device)Display.getCurrent(), 77, 113, 179);
            Color dialogSideBarColor = new Color((Device)Display.getCurrent(), 240, 243, 249);
            if (dialogFrameColor != null) {
                cpd.setFrameColor(dialogFrameColor);
            }
            if (dialogSideBarColor != null) {
                cpd.setSideBarColor(dialogSideBarColor);
            }
            cpd.setTitle("Connector Properties: " + connector.getOrigin().getName() + " -> " + connector.getDestination().getName());
            ConnectorPropertiesPanel connectorPropertiesPanel = new ConnectorPropertiesPanel(connector);
            AttachedDataPropertiesPanel attachedDataPropertiesPanel = new AttachedDataPropertiesPanel(connector);
            connectorPropertiesPanel.addEndPointListener(attachedDataPropertiesPanel);
            cpd.addPage((ContentPage)connectorPropertiesPanel);
            cpd.addPage((ContentPage)attachedDataPropertiesPanel);
            cpd.open();
            if (connector.getExitCodes().isEmpty() && canDelete) {
                connector.getModel().removeConnector(connector);
            }
            this.currentCanvas.getUICanvas().validateCanvasStatus();
            this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
            dialogFrameColor.dispose();
            dialogSideBarColor.dispose();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void showCanvasProperties() {
        System.out.println("Show canvas properties!");
        Shell workbenchShell = Display.getCurrent().getActiveShell();
        CanvasPropertiesDialog cpd = new CanvasPropertiesDialog(workbenchShell);
        cpd.setRenderedCanvas(this.currentCanvas);
        if (cpd.open() == 0) {
            this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
        }
    }

    public void showElementProperties(Element element) {
        this.showElementProperties(element, false);
    }

    public void showElementProperties(Element element, boolean deleteOnCancel) {
        System.out.println("showing properties for " + element.getTypeName() + ":" + element.getName());
        try {
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            if (element.getModel().getBrandManager().getSupportedInteractionTypes().size() < 1) {
                MessageDialog.openError((Shell)workbenchShell, (String)"No Media Projects Defined", (String)"There are currently no media projects defined for this desing project.  Please right click on the project and select Properties.  Navigate to the Build Path settings panel and add at least one media project.");
                if (deleteOnCancel) {
                    element.getModel().removeElement(element);
                }
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
                return;
            }
            ComponentPropertiesDialog cpd = new ComponentPropertiesDialog(this.brandManager, workbenchShell);
            Color dialogFrameColor = new Color((Device)Display.getCurrent(), 77, 113, 179);
            Color dialogSideBarColor = new Color((Device)Display.getCurrent(), 240, 243, 249);
            if (dialogFrameColor != null) {
                cpd.setFrameColor(dialogFrameColor);
            }
            if (dialogSideBarColor != null) {
                cpd.setSideBarColor(dialogSideBarColor);
            }
            String elementType = "";
            if (element instanceof PrimitiveElement) {
                elementType = "(" + ((PrimitiveElement)element).getTypeName() + ")";
            }
            cpd.setTitle(String.valueOf(element.getName()) + " Properties " + elementType);
            List panels = element.getConfigurationPanels();
            if (panels.size() > 0) {
                for (ComponentPropertiesPanel cpp : panels) {
                    cpd.addPage((ContentPage)cpp);
                }
                int open = cpd.open();
                System.out.println(0);
                System.out.println("open: " + open + " deleteOnCancel: " + deleteOnCancel);
                if (open != 0 && deleteOnCancel) {
                    element.getModel().removeElement(element);
                }
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
            }
            dialogFrameColor.dispose();
            dialogSideBarColor.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setControl(Control interactiveSurface) {
        this.interactionSurface = interactiveSurface;
        this.dropTarget = new DropTarget(this.interactionSurface, 19);
        this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), PalletItemTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)this);
        interactiveSurface.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BasicController.this.dropTarget.dispose();
                if (BasicController.this.dragSource != null) {
                    BasicController.this.dragSource.dispose();
                }
            }
        });
    }

    public void addListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    public void fillContextMenu(IMenuManager menuManager) {
        boolean canDelete;
        final Point contextPoint = new Point(this.commandPosition.x, this.commandPosition.y);
        MenuManager addMenu = new MenuManager("Add");
        menuManager.add((IContributionItem)addMenu);
        int i = 0;
        while (i < this.providers.size()) {
            PalletItemProvider provider = (PalletItemProvider)this.providers.get(i);
            List items = provider.getPalletItems();
            for (final PalletItem item : items) {
                if (!item.canBeContainedBy(this.adaptableContainer)) continue;
                addMenu.add((IAction)new Action(item.getName()){

                    public void run() {
                        BasicController.this.addElement(item, contextPoint);
                    }
                });
            }
            ++i;
        }
        if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() > 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
            MenuManager alignEdgeMenu = new MenuManager("Align Edges");
            menuManager.add((IContributionItem)alignEdgeMenu);
            alignEdgeMenu.add((IAction)new Action("Left"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignEdge(16384);
                }
            });
            alignEdgeMenu.add((IAction)new Action("Top"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignEdge(128);
                }
            });
            alignEdgeMenu.add((IAction)new Action("Right"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignEdge(131072);
                }
            });
            alignEdgeMenu.add((IAction)new Action("Bottom"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignEdge(1024);
                }
            });
            MenuManager alignCenterMenu = new MenuManager("Align Centers");
            menuManager.add((IContributionItem)alignCenterMenu);
            alignCenterMenu.add((IAction)new Action("Horizontal"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignCenter(256);
                }
            });
            alignCenterMenu.add((IAction)new Action("Vertical"){

                public void run() {
                    BasicController.this.currentCanvas.getSelection().alignCenter(512);
                }
            });
        }
        if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getUIElement().getElement() instanceof PrimitiveElement) {
            PrimitiveElement primitiveElement = (PrimitiveElement)((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getUIElement().getElement();
            List actionList = primitiveElement.getActions(this);
            for (Action action : actionList) {
                menuManager.add((IAction)action);
            }
        }
        if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getUIElement().getElement() instanceof DialogElement) {
            final DialogElement primitiveElement = (DialogElement)((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getUIElement().getElement();
            menuManager.add((IAction)new Action("Create Template"){

                public void run() {
                    CreateDialogTemplateWizard cdtw = new CreateDialogTemplateWizard(primitiveElement);
                    WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)cdtw);
                    wd.open();
                }
            });
        }
        if (this.currentCanvas.getSelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame) {
            menuManager.add((IAction)new Action("Toggle Midpoint"){

                public void run() {
                    ConnectorFrame cf = (ConnectorFrame)BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                    cf.toggleMidPoint(contextPoint.x, contextPoint.y);
                    BasicController.this.fireGraphicUpdate(cf.getBounds(), false);
                }
            });
        }
        if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
            boolean canDelete2 = true;
            List items = this.currentCanvas.getSelection().getSelectedItems();
            for (ElementFrame ef : items) {
                Element el = ef.getUIElement().getElement();
                if (!(el instanceof PrimitiveElement)) continue;
                canDelete2 &= ((PrimitiveElement)el).canDelete();
            }
            if (canDelete2) {
                menuManager.add((IAction)new Action("Delete"){

                    public void run() {
                        MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                        confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
                        int result = confirmationDialog.open();
                        if (result == 64) {
                            BasicController.this.currentCanvas.deleteSelectedItems();
                            BasicController.this.fireGraphicUpdate(0, 0, BasicController.this.currentCanvas.getUICanvas().getWidth(), BasicController.this.currentCanvas.getUICanvas().getHeight(), false);
                        }
                    }
                });
            }
        }
        if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame && (canDelete = true)) {
            menuManager.add((IAction)new Action("Delete"){

                public void run() {
                    MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
                    int result = confirmationDialog.open();
                    if (result == 64) {
                        BasicController.this.currentCanvas.deleteSelectedItems();
                        BasicController.this.fireGraphicUpdate(0, 0, BasicController.this.currentCanvas.getUICanvas().getWidth(), BasicController.this.currentCanvas.getUICanvas().getHeight(), false);
                    }
                }
            });
        }
        menuManager.add((IContributionItem)new Separator());
        if (this.currentCanvas.getSelection().getPrimarySelection() == null || this.currentCanvas.getSelection().getPrimarySelection() instanceof ConnectorFrame) {
            menuManager.add((IAction)new Action("Properties"){

                public void run() {
                    ComponentFrame cf;
                    ComponentFrame componentFrame = cf = BasicController.this.currentCanvas.getSelection().getSelectedItems().size() > 1 ? null : BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                    if (cf != null) {
                        if (cf instanceof ConnectorFrame) {
                            BasicController.this.showConnectorProperties(((ConnectorFrame)cf).getUIConnector().getConnector());
                        } else {
                            BasicController.this.showElementProperties(((ElementFrame)cf).getUIElement().getElement());
                        }
                    } else {
                        BasicController.this.showCanvasProperties();
                    }
                }
            });
        }
        if (this.currentCanvas.getSelection().getPrimarySelection() != null && this.currentCanvas.getSelection().getSelectedItems().size() == 1 && this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame && ((ElementFrame)this.currentCanvas.getSelection().getPrimarySelection()).getUIElement().getElement().getConfigurationPanels().size() > 0) {
            menuManager.add((IAction)new Action("Properties"){

                public void run() {
                    ComponentFrame cf;
                    ComponentFrame componentFrame = cf = BasicController.this.currentCanvas.getSelection().getSelectedItems().size() > 1 ? null : BasicController.this.currentCanvas.getSelection().getPrimarySelection();
                    if (cf != null) {
                        if (cf instanceof ConnectorFrame) {
                            BasicController.this.showConnectorProperties(((ConnectorFrame)cf).getUIConnector().getConnector());
                        } else {
                            BasicController.this.showElementProperties(((ElementFrame)cf).getUIElement().getElement());
                        }
                    } else {
                        BasicController.this.showCanvasProperties();
                    }
                }
            });
        }
    }

    public void fireGraphicUpdate(Rectangle rec, boolean inProgress) {
        this.fireGraphicUpdate(rec.x, rec.y, rec.width, rec.height, inProgress);
    }

    public void fireGraphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ControllerListener)this.listeners.get(i)).graphicUpdate(x, y, width, height, inProgress);
            ++i;
        }
    }

    public void fireSelectionChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ControllerListener)this.listeners.get(i)).selectionChanged(this.currentCanvas.getSelection());
            ++i;
        }
    }

    public void mouseDown(MouseEvent event) {
        System.out.println("mouse down");
        try {
            this.commandPosition = new Point(event.x, event.y);
            Rectangle initialSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
            ComponentFrame initialPrimarySelection = this.currentCanvas.getSelection().getPrimarySelection();
            SelectionResult result = this.currentCanvas.selectAt(event.x, event.y, (event.stateMask & 0x20000) != 0);
            System.out.println("result: hit=" + result.wasHit() + " selectionChanged=" + result.wasSelectionChanged() + " primaryChanged=" + result.wasPrimaryChanged());
            if (result.wasSelectionChanged()) {
                if (initialPrimarySelection == null) {
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds(), false);
                } else {
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds() == null ? initialSelectionRect : initialSelectionRect.union(this.currentCanvas.getSelection().getTertiaryBounds()), false);
                }
                this.fireSelectionChanged();
            }
            if (event.button == 1) {
                if (result.wasHit()) {
                    this.currentCanvas.getSelection().getPrimarySelection().mouseDown(this, event.x, event.y, event.stateMask);
                } else {
                    this.dragPoint = this.commandPosition;
                    this.dragging = true;
                    this.isArea = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseUp(MouseEvent event) {
        System.out.println("mouse up");
        try {
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(0));
            this.commandPosition = new Point(event.x, event.y);
            if (this.dragging) {
                boolean wasLine = this.isLine;
                boolean wasArea = this.isArea;
                this.dragging = false;
                this.isLine = false;
                this.isArea = false;
                if (wasLine) {
                    ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
                    ElementFrame dest = this.currentCanvas.findElementAt(event.x, event.y);
                    if (dest != null) {
                        if (dest.getUIElement().getElement().acceptConnector(ef.getUIElement().getElement())) {
                            ConnectorFrame connectorFrame = this.currentCanvas.connectElements(ef, dest);
                            this.showConnectorProperties(connectorFrame.getUIConnector().getConnector());
                        }
                        this.currentCanvas.getSelection().validateSelection();
                        this.fireGraphicUpdate(ef.getBounds().union(dest.getBounds()), false);
                    } else {
                        this.fireGraphicUpdate(ef.getBounds().union(new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.commandPosition.x - this.dragPoint.x) + 2, Math.abs(this.commandPosition.y - this.dragPoint.y) + 2)), false);
                    }
                } else if (wasArea) {
                    Rectangle selectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x) - 2, Math.min(this.dragPoint.y, this.commandPosition.y) - 2, Math.abs(this.dragPoint.x - this.commandPosition.x) + 4, Math.abs(this.dragPoint.y - this.commandPosition.y) + 4);
                    Rectangle initialSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
                    this.currentCanvas.selectRegion(selectionArea, (event.stateMask & 0x20000) != 0);
                    Rectangle currentSelectionRect = this.currentCanvas.getSelection().getTertiaryBounds();
                    if (initialSelectionRect != null && !initialSelectionRect.isEmpty()) {
                        selectionArea.add(initialSelectionRect);
                    }
                    if (currentSelectionRect != null && !currentSelectionRect.isEmpty()) {
                        selectionArea.add(currentSelectionRect);
                    }
                    this.fireGraphicUpdate(selectionArea, false);
                } else {
                    this.fireGraphicUpdate(this.currentCanvas.getSelection().getTertiaryBounds(), false);
                }
            } else {
                ComponentFrame cf = this.currentCanvas.findComponentAt(event.x, event.y);
                if (cf != null) {
                    cf.mouseUp(this, event.x, event.y, event.stateMask);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.commandPosition = new Point(event.x, event.y);
        this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(0));
        this.dragging = false;
        this.isLine = false;
        this.isArea = false;
        ComponentFrame cf = this.currentCanvas.findComponentAt(event.x, event.y);
        if (cf != null) {
            cf.mouseDoubleClick(this, event.x, event.y, event.stateMask);
        } else {
            this.showCanvasProperties();
        }
    }

    public void mouseMove(MouseEvent event) {
        Point oldPosition = this.commandPosition;
        this.commandPosition = new Point(event.x, event.y);
        if (this.dragging) {
            Rectangle redrawArea = null;
            if (!this.isLine && !this.isArea) {
                redrawArea = this.currentCanvas.getSelection().getTertiaryBounds();
                this.currentCanvas.getSelection().adjustPosition(this.commandPosition.x - this.dragPoint.x, this.commandPosition.y - this.dragPoint.y);
                redrawArea.add(this.currentCanvas.getSelection().getTertiaryBounds());
                this.dragPoint = this.commandPosition;
                new Rectangle(0, 0, this.interactionSurface.getSize().x, this.interactionSurface.getSize().y);
            } else if (this.isArea) {
                if (oldPosition == null) {
                    oldPosition = new Point(0, 0);
                }
                Rectangle previousSelectionArea = new Rectangle(Math.min(this.dragPoint.x, oldPosition.x) - 2, Math.min(this.dragPoint.y, oldPosition.y) - 2, Math.abs(this.dragPoint.x - oldPosition.x) + 4, Math.abs(this.dragPoint.y - oldPosition.y) + 4);
                Rectangle currentSelectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x) - 2, Math.min(this.dragPoint.y, this.commandPosition.y) - 2, Math.abs(this.dragPoint.x - this.commandPosition.x) + 4, Math.abs(this.dragPoint.y - this.commandPosition.y) + 4);
                redrawArea = previousSelectionArea.union(currentSelectionArea);
            } else {
                ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
                redrawArea = ef.getBounds().union(new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.commandPosition.x - this.dragPoint.x) + 2, Math.abs(this.commandPosition.y - this.dragPoint.y) + 2));
                redrawArea.add(new Rectangle(Math.min(this.dragPoint.x, oldPosition.x), Math.min(this.dragPoint.y, oldPosition.y), Math.abs(oldPosition.x - this.dragPoint.x) + 2, Math.abs(oldPosition.y - this.dragPoint.y) + 2));
                ElementFrame df = this.currentCanvas.findElementAt(event.x, event.y);
                if (df != null) {
                    if (!df.getUIElement().getElement().acceptConnector(ef.getUIElement().getElement())) {
                        this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(20));
                    }
                } else {
                    this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(2));
                }
            }
            if (redrawArea != null) {
                this.fireGraphicUpdate(redrawArea, true);
            }
        }
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
        System.out.println("mouse exit");
        if (!this.dragging || !this.isLine) {
            // empty if block
        }
    }

    public void mouseHover(MouseEvent event) {
        this.commandPosition = new Point(event.x, event.y);
    }

    public void paintControl(PaintEvent e) {
        Rectangle clipping = e.gc.getClipping();
        e.gc.fillRectangle(clipping);
        if (this.isLine && this.dragging) {
            e.gc.drawLine(this.dragPoint.x, this.dragPoint.y, this.commandPosition.x, this.commandPosition.y);
        }
        this.currentCanvas.paintCanvas(e.gc, this.resourceMap, 0);
        if (this.isArea && this.dragging) {
            e.gc.setLineStyle(3);
            e.gc.setLineWidth(2);
            Rectangle currentSelectionArea = new Rectangle(Math.min(this.dragPoint.x, this.commandPosition.x), Math.min(this.dragPoint.y, this.commandPosition.y), Math.abs(this.dragPoint.x - this.commandPosition.x), Math.abs(this.dragPoint.y - this.commandPosition.y));
            e.gc.drawRectangle(currentSelectionArea);
            e.gc.setLineWidth(1);
        }
    }

    public void executeCommand(Command command) {
        if (command instanceof StartMove) {
            System.out.println("start move");
            this.dragging = true;
            this.dragPoint = this.commandPosition;
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(5));
        } else if (command instanceof BeginConnector) {
            System.out.println("start connector");
            this.dragging = true;
            ElementFrame ef = (ElementFrame)this.currentCanvas.getSelection().getPrimarySelection();
            this.dragPoint = ef.getUIElement().getCenterPoint();
            this.isLine = true;
            this.interactionSurface.setCursor(Display.getCurrent().getSystemCursor(2));
        } else if (command instanceof ShowProperties) {
            Element component;
            ComponentFrame cof = this.currentCanvas.getSelection().getPrimarySelection();
            UIComponent uiComponent = cof instanceof ElementFrame ? ((ElementFrame)cof).getUIElement() : ((ConnectorFrame)cof).getUIConnector();
            Object object = component = uiComponent instanceof UIElement ? ((UIElement)uiComponent).getElement() : ((UIConnector)uiComponent).getConnector();
            if (component instanceof Connector) {
                this.showConnectorProperties((Connector)component);
            } else {
                Element element = component;
                Shell workbenchShell = Display.getCurrent().getActiveShell();
                if (element instanceof DialogElement) {
                    try {
                        DialogCustomizerWindow dcw = new DialogCustomizerWindow(workbenchShell);
                        dcw.init(((DialogElement)element).getDialogModel());
                        dcw.setContainer(this.adaptableContainer);
                        dcw.create();
                        dcw.getShell().setText("Customizing Dialog: " + element.getName());
                        dcw.open();
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (element instanceof ApplicationFragmentElement) {
                    FragmentContainer fc = (FragmentContainer)this.adaptableContainer.getAdapter(FragmentContainer.class);
                    fc.displayFragment(((ApplicationFragmentElement)element).getFragmentId());
                    return;
                }
                this.showElementProperties(element);
            }
        } else if (command instanceof LocateElement) {
            LocateElement le = (LocateElement)command;
            String elementId = le.getElementId();
            ModelNavigationListener navigationListener = (ModelNavigationListener)this.adaptableContainer.getAdapter(ModelNavigationListener.class);
            if (navigationListener != null) {
                navigationListener.navigateToElement(elementId);
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            System.out.println("sending false escape key");
            Event fakeEscape = new Event();
            fakeEscape.type = 1;
            fakeEscape.character = (char)27;
            System.out.println(this.interactionSurface.getDisplay().post(fakeEscape));
        }
        System.out.println("drag enter: " + event);
        System.out.println(event.currentDataType);
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        try {
            PalletItem pi = PalletItemTransfer.getInstance().getPalletItem();
            System.out.println("drop location: " + event.x + ", " + event.y);
            Point dropPoint = this.interactionSurface.toControl(event.x, event.y);
            this.addElement(pi, dropPoint);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void addElement(PalletItem pi, Point dropPoint) {
        Element createdElement = pi.createElement(this.adaptableContainer);
        if (createdElement instanceof DialogElement) {
            DialogContainer dialogContainer = (DialogContainer)this.adaptableContainer.getAdapter(DialogContainer.class);
            if (dialogContainer == null) {
                System.out.println("container does not accept dialogs!");
                return;
            }
            ((DialogElement)createdElement).setDialogModel(dialogContainer.addDialog(createdElement.getId(), DialogElementManager.getDefault().getTemplate(((DialogElement)createdElement).getTypeid())));
        } else if (createdElement instanceof ApplicationFragmentElement) {
            FragmentContainer dialogContainer = (FragmentContainer)this.adaptableContainer.getAdapter(FragmentContainer.class);
            if (dialogContainer == null) {
                System.out.println("container does not accept fragments!");
                return;
            }
            ((ApplicationFragmentElement)createdElement).setFragmentModel(dialogContainer.addFragment((ApplicationFragmentElement)createdElement));
        }
        this.currentCanvas.addElement(createdElement, dropPoint.x, dropPoint.y);
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
        if (pi.isPopOnDrop()) {
            this.showElementProperties(createdElement, true);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        System.out.println("drop accept: " + event);
        if (!PalletItemTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
    }

    public void dragStart(DragSourceEvent event) {
        System.out.println("canvas drag start");
        event.doit = event.x == -1 && event.y == -1;
        System.out.println(event.doit);
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\u007f' && this.currentCanvas.getSelection().getPrimarySelection() != null) {
            boolean canDelete = true;
            if (this.currentCanvas.getSelection().getPrimarySelection() instanceof ElementFrame) {
                List items = this.currentCanvas.getSelection().getSelectedItems();
                for (ElementFrame ef : items) {
                    Element el = ef.getUIElement().getElement();
                    if (!(el instanceof PrimitiveElement)) continue;
                    canDelete &= ((PrimitiveElement)el).canDelete();
                }
            }
            if (!canDelete) {
                return;
            }
            System.out.println("is delete");
            MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            confirmationDialog.setMessage("Are you sure you want to delete the selected item(s)?");
            int result = confirmationDialog.open();
            if (result == 64) {
                this.currentCanvas.deleteSelectedItems();
                this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void renderedCanvasChanged(RenderedCanvas renderedCanvas) {
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
    }

    public void renderedCanvasDeleted(RenderedCanvas renderedCanvas) {
    }

    public void renderedCanvasFormatChanged(RenderedCanvas renderedCanvas) {
        this.fireGraphicUpdate(0, 0, this.currentCanvas.getUICanvas().getWidth(), this.currentCanvas.getUICanvas().getHeight(), false);
    }
}

