/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.model.PaperSize;
import org.eclipse.vtp.desktop.editors.core.model.PaperSizeManager;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;

public class CanvasPropertiesDialog
extends Dialog {
    RenderedCanvas canvas = null;
    Text canvasName = null;
    Combo paperSizeCombo = null;
    List paperSizes = PaperSizeManager.getDefault().getPaperSizes();
    Button portraitButton = null;
    Button landscapeButton = null;

    public CanvasPropertiesDialog(Shell parentShell) {
        super(parentShell);
    }

    public CanvasPropertiesDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public void setRenderedCanvas(RenderedCanvas canvas) {
        this.canvas = canvas;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label canvasNameLabel = new Label(comp, 0);
        canvasNameLabel.setText("Canvas Name:");
        GridData gd = new GridData();
        canvasNameLabel.setLayoutData((Object)gd);
        this.canvasName = new Text(comp, 0x800804);
        this.canvasName.setText(this.canvas.getUICanvas().getName());
        gd = new GridData(768);
        this.canvasName.setLayoutData((Object)gd);
        Group paperSizeGroup = new Group(comp, 0);
        paperSizeGroup.setText("Canvas Size");
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        paperSizeGroup.setLayoutData((Object)gd);
        paperSizeGroup.setLayout((Layout)new FormLayout());
        Label paperSizeLabel = new Label((Composite)paperSizeGroup, 0);
        paperSizeLabel.setText("Paper Size:");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        paperSizeLabel.setLayoutData((Object)fd);
        this.paperSizeCombo = new Combo((Composite)paperSizeGroup, 12);
        int i = 0;
        while (i < this.paperSizes.size()) {
            PaperSize ps = (PaperSize)this.paperSizes.get(i);
            this.paperSizeCombo.add(ps.getName());
            if (ps.equals(this.canvas.getUICanvas().getPaperSize())) {
                this.paperSizeCombo.select(i);
            }
            ++i;
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)paperSizeLabel, 0);
        fd.top = new FormAttachment(0, 0);
        this.paperSizeCombo.setLayoutData((Object)fd);
        this.portraitButton = new Button((Composite)paperSizeGroup, 0x800010);
        this.portraitButton.setText("Portrait");
        if (this.canvas.getUICanvas().getOrientation() == 1) {
            this.portraitButton.setSelection(true);
        }
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)paperSizeLabel, 15);
        this.portraitButton.setLayoutData((Object)fd);
        this.landscapeButton = new Button((Composite)paperSizeGroup, 0x800010);
        this.landscapeButton.setText("Landscape");
        if (this.canvas.getUICanvas().getOrientation() == 2) {
            this.landscapeButton.setSelection(true);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.portraitButton, 0);
        fd.top = new FormAttachment((Control)paperSizeLabel, 15);
        this.landscapeButton.setLayoutData((Object)fd);
        return comp;
    }

    protected void okPressed() {
        try {
            this.canvas.getUICanvas().setOrientation(this.portraitButton.getSelection() ? 1 : 2);
            this.canvas.getUICanvas().setPaperSize((PaperSize)this.paperSizes.get(this.paperSizeCombo.getSelectionIndex()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

