/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentVariableMapping;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.ReturnInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.FragmentMissingModelPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.FragmentOutputMappingPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.FragmentVariableMappingPanel;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.ElementResolutionVisitor;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationFragmentElement
extends org.eclipse.vtp.desktop.model.core.Element {
    private RenderedModel fragmentModel;
    private List connectorRecords = new ArrayList();
    private List variableMappings = new ArrayList();
    private Map<String, List<OutputMapping>> outgoingVariableMappings = new HashMap<String, List<OutputMapping>>();
    private List<PrimitiveElement> returnElements = new ArrayList<PrimitiveElement>();
    private String fragmentId;
    private boolean hasConnectors = false;
    private boolean missingModelMode = true;

    public ApplicationFragmentElement(String name) {
        super(name);
    }

    public ApplicationFragmentElement(String id, String name) {
        super(id, name);
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentModel(RenderedModel dialogModel) {
        if (dialogModel == null) {
            this.missingModelMode = true;
        } else {
            this.missingModelMode = false;
            ArrayList oldCRs = new ArrayList();
            oldCRs.addAll(this.connectorRecords);
            this.connectorRecords.clear();
            this.fragmentModel = dialogModel;
            List elements = dialogModel.getUIModel().getModel().listElements();
            this.returnElements.clear();
            int i = 0;
            while (i < elements.size()) {
                if (elements.get(i) instanceof PrimitiveElement) {
                    PrimitiveElement primitiveElement = (PrimitiveElement)((Object)elements.get(i));
                    System.out.println("primitive element in dialog: " + primitiveElement.getTypeId());
                    if (primitiveElement.getTypeId().equals("org.eclipse.vtp.desktop.editors.core.return")) {
                        this.returnElements.add(primitiveElement);
                        String exitType = ((ReturnInformationProvider)primitiveElement.getInformationProvider()).getExitType();
                        boolean found = false;
                        int e = 0;
                        while (e < oldCRs.size()) {
                            ConnectorRecord cr = (ConnectorRecord)oldCRs.get(e);
                            if (cr.getName().equals(primitiveElement.getName())) {
                                found = true;
                                this.connectorRecords.add(cr);
                                cr.setType(exitType.equals("Normal") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
                                oldCRs.remove(cr);
                                break;
                            }
                            ++e;
                        }
                        if (!found) {
                            this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)this, primitiveElement.getName(), exitType.equals("Normal") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT));
                        }
                        this.hasConnectors = true;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < oldCRs.size()) {
                ConnectorRecord cr = (ConnectorRecord)oldCRs.get(i);
                Connector connector = cr.getConnector();
                connector.removeExitPoint(cr);
                if (connector.getExitCodes().size() == 0) {
                    this.getModel().removeConnector(connector);
                }
                ++i;
            }
        }
    }

    public RenderedModel getFragmentModel() {
        return this.fragmentModel;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        if (this.missingModelMode) {
            ConnectorRecord cr = new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)this, recordName, recordName.startsWith("error.") ? ConnectorRecord.ERROR_POINT : ConnectorRecord.EXIT_POINT);
            this.connectorRecords.add(cr);
            this.hasConnectors = true;
            return cr;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList mappingElements = configuration.getElementsByTagName("mapping");
        int i = 0;
        while (i < mappingElements.getLength()) {
            Element mappingElement = (Element)mappingElements.item(i);
            String fragVarName = mappingElement.getAttribute("fragment-variable-name");
            String mappingTypeString = mappingElement.getAttribute("mapping-type");
            int mappingType = 0;
            mappingType = "".equalsIgnoreCase(mappingTypeString) ? 0 : ("none".equalsIgnoreCase(mappingTypeString) ? 0 : ("static".equalsIgnoreCase(mappingTypeString) ? 1 : ("expression".equalsIgnoreCase(mappingTypeString) ? 2 : ("variable".equalsIgnoreCase(mappingTypeString) ? 3 : Integer.parseInt(mappingTypeString)))));
            String mappingValue = mappingElement.getAttribute("mapping-value");
            ApplicationFragmentVariableMapping afvm = new ApplicationFragmentVariableMapping(fragVarName, mappingType, mappingValue);
            this.variableMappings.add(afvm);
            ++i;
        }
        NodeList outgoingElements = configuration.getElementsByTagName("outgoing-data");
        int i2 = 0;
        while (i2 < outgoingElements.getLength()) {
            Element outgoingElement = (Element)outgoingElements.item(i2);
            String exitPath = outgoingElement.getAttribute("exit-path");
            NodeList outgoingMappingElements = configuration.getElementsByTagName("data-mapping");
            int m = 0;
            while (m < outgoingMappingElements.getLength()) {
                Element outgoingMappingElement = (Element)outgoingMappingElements.item(m);
                String outputName = outgoingMappingElement.getAttribute("output");
                String targetName = outgoingMappingElement.getAttribute("target");
                List<OutputMapping> obj = this.outgoingVariableMappings.get(exitPath);
                if (obj == null) {
                    obj = new ArrayList<OutputMapping>();
                    this.outgoingVariableMappings.put(exitPath, obj);
                }
                obj.add(new OutputMapping(outputName, targetName));
                ++m;
            }
            ++i2;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element elementElement = configuration.getOwnerDocument().createElement("fragment-element");
        configuration.appendChild(elementElement);
        elementElement.setAttribute("id", this.getId());
        elementElement.setAttribute("name", this.getName());
        elementElement.setAttribute("instanceId", this.fragmentId);
        List configurationManagers = this.listConfigurationManagers();
        for (ConfigurationManager manager : configurationManagers) {
            manager.writeConfiguration(elementElement);
        }
        Element customElement = elementElement.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config");
        elementElement.appendChild(customElement);
        for (ApplicationFragmentVariableMapping mapping : this.variableMappings) {
            Element mappingElement = configuration.getOwnerDocument().createElement("mapping");
            customElement.appendChild(mappingElement);
            mappingElement.setAttribute("fragment-variable-name", mapping.getFragmentVariableName());
            String mappingType = "none";
            switch (mapping.getMappingType()) {
                case 1: {
                    mappingType = "static";
                    break;
                }
                case 2: {
                    mappingType = "expression";
                    break;
                }
                case 3: {
                    mappingType = "variable";
                }
            }
            mappingElement.setAttribute("mapping-type", mappingType);
            mappingElement.setAttribute("mapping-value", mapping.getMappingValue());
        }
        for (PrimitiveElement pe : this.returnElements) {
            Element outgoingElement = configuration.getOwnerDocument().createElement("outgoing-data");
            customElement.appendChild(outgoingElement);
            outgoingElement.setAttribute("exit-path", pe.getName());
            List<OutputMapping> mappings = this.outgoingVariableMappings.get(pe.getName());
            if (mappings == null) continue;
            for (OutputMapping mapping : mappings) {
                if (mapping.getTargetName() == null) continue;
                Element dataElement = configuration.getOwnerDocument().createElement("data-mapping");
                outgoingElement.appendChild(dataElement);
                dataElement.setAttribute("output", mapping.getOutputName());
                dataElement.setAttribute("target", mapping.getTargetName());
            }
        }
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return true;
    }

    public List getConfigurationPanels() {
        ArrayList<ComponentPropertiesPanel> ret = new ArrayList<ComponentPropertiesPanel>();
        if (!this.missingModelMode) {
            ret.add(new FragmentVariableMappingPanel(this));
            ret.add(new FragmentOutputMappingPanel(this, this.returnElements, this.outgoingVariableMappings));
        } else {
            ret.add(new FragmentMissingModelPanel(this));
        }
        return ret;
    }

    public String getTypeName() {
        return "Application Fragment";
    }

    public Image getIcon() {
        return null;
    }

    public void resolve(ElementResolutionVisitor resolutionVisitor) {
    }

    public void setOutputMappings(Map<String, List<OutputMapping>> maps) {
        this.outgoingVariableMappings = maps;
    }

    public List getVariableMappings() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (ApplicationFragmentVariableMapping mapping : this.variableMappings) {
            ret.add(mapping.clone());
        }
        return ret;
    }

    public void setVariableMappings(List variableMappings) {
        this.variableMappings = variableMappings;
    }

    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public class OutputMapping {
        private String outputName;
        private String targetName;

        public OutputMapping(String outputName, String targetName) {
            this.outputName = outputName;
            this.targetName = targetName;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public void setTargetName(String targetName) {
            this.targetName = targetName;
        }
    }
}

