/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ApplicationFragmentElementManager {
    public static String fragmentExtensionPointId = "org.eclipse.vtp.desktop.editors.core.fragmentElement";
    private static ApplicationFragmentElementManager instance = new ApplicationFragmentElementManager();
    private Map dialogTypes = new HashMap();

    public static ApplicationFragmentElementManager getDefault() {
        return instance;
    }

    public ApplicationFragmentElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(fragmentExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            ApplicationFragmentElementRecord der = new ApplicationFragmentElementRecord();
            der.id = primitiveExtensions[i].getAttribute("id");
            der.name = primitiveExtensions[i].getAttribute("name");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            der.resourceURL = contributor.getResource(primitiveExtensions[i].getAttribute("template"));
            this.dialogTypes.put(der.id, der);
            ++i;
        }
    }

    public String getName(String id) {
        ApplicationFragmentElementRecord der = (ApplicationFragmentElementRecord)this.dialogTypes.get(id);
        if (der != null) {
            return der.name;
        }
        return null;
    }

    public URL getTemplate(String id) {
        ApplicationFragmentElementRecord der = (ApplicationFragmentElementRecord)this.dialogTypes.get(id);
        if (der != null) {
            return der.resourceURL;
        }
        return null;
    }

    private class ApplicationFragmentElementRecord {
        String id;
        String name;
        URL resourceURL;

        private ApplicationFragmentElementRecord() {
        }
    }
}

