/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentElementFactory;
import org.eclipse.vtp.desktop.editors.core.model.FragmentContainer;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragmentProject;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;

public class ApplicationFragmentPalletProvider
implements PalletItemProvider,
IResourceChangeListener {
    List primitiveItems = new ArrayList();
    List observers = new ArrayList();

    public ApplicationFragmentPalletProvider() {
        this.loadProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void loadProjects() {
        this.primitiveItems.clear();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            System.out.println("inspecting project: " + projects[i].getFullPath());
            if (DesktopCorePlugin.isApplicationFragmentProject((IProject)projects[i])) {
                System.err.println("is a fragment");
                try {
                    IApplicationFragmentProject iafp = DesktopCorePlugin.convertToApplicationFragment((IProject)projects[i]);
                    this.primitiveItems.add(new PalletItem(iafp.getApplicationFragmentName(), null, new ApplicationFragmentElementFactory(), iafp.getApplicationFragmentId()){

                        public boolean canBeContainedBy(IAdaptable container) {
                            return container.getAdapter(FragmentContainer.class) != null;
                        }
                    });
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public String getName() {
        return "Application Fragments";
    }

    public List getPalletItems() {
        return this.primitiveItems;
    }

    public int getRanking() {
        return 30;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, PalletItem[] selectedItems) {
    }

    public void fireUpdate() {
        for (PalletItemObserver observer : this.observers) {
            observer.palletItemsChanged();
        }
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
        this.observers.add(observer);
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
        this.observers.remove(observer);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final boolean[] bs = new boolean[1];
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 1 && (delta.getResource().getName().equals(".buildPath") || delta.getResource().getName().equals(".config"))) {
                            bs[0] = true;
                        } else if (delta.getKind() == 2) {
                            System.out.println("Resource Removed: " + delta.getFullPath());
                            bs[0] = true;
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (bs[0]) {
            this.loadProjects();
            this.fireUpdate();
        }
    }
}

