/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.adrequest.AttachedDataBinding;
import org.eclipse.vtp.desktop.core.configuration.adrequest.AttachedDataBindingItem;
import org.eclipse.vtp.desktop.core.configuration.adrequest.AttachedDataItemEntry;
import org.eclipse.vtp.desktop.core.configuration.adrequest.AttachedDataManager;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;

public class AttachedDataRequestInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();

    public AttachedDataRequestInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
    }

    public List getPropertiesPanels() {
        AttachedDataManager manager = (AttachedDataManager)this.getElement().getConfigurationManager("org.eclipse.vtp.configuration.attacheddata.request");
        AttachedDataBinding binding = manager.getAttachedDataBinding("default");
        AttachedDataBindingItem adbi = binding.getAttachedDataItem("Default", "", "");
        adbi.clearEntries();
        AttachedDataItemEntry attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("Residential");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("Residential");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("Business");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("Business");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("EasyMax");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("EasyMax");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("PA");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("PA");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("IsHoliday");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("IsHoliday");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("IsClosure");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("IsClosure");
        adbi.addEntry(attachedDataItemEntry);
        attachedDataItemEntry = new AttachedDataItemEntry();
        attachedDataItemEntry.setName("WorkingHours");
        attachedDataItemEntry.setDataType(0);
        attachedDataItemEntry.setValue("WorkingHours");
        adbi.addEntry(attachedDataItemEntry);
        binding.putAttachedDataItem("Default", "", "", adbi);
        this.getElement().commitConfigurationChanges((ConfigurationManager)manager);
        ArrayList<PrimitiveGeneralPropertiesPanel> ret = new ArrayList<PrimitiveGeneralPropertiesPanel>();
        ret.add(new PrimitiveGeneralPropertiesPanel("General", this.getElement()));
        return ret;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (exitPoint.equals("Continue")) {
            Variable var = new Variable("Residential", FieldType.STRING);
            ret.add(var);
            var = new Variable("Business", FieldType.STRING);
            ret.add(var);
            var = new Variable("EasyMax", FieldType.STRING);
            ret.add(var);
            var = new Variable("PA", FieldType.STRING);
            ret.add(var);
            var = new Variable("IsHoliday", FieldType.STRING);
            ret.add(var);
            var = new Variable("IsClosure", FieldType.STRING);
            ret.add(var);
            var = new Variable("WorkingHours", FieldType.STRING);
            ret.add(var);
        }
        return ret;
    }

    public boolean hasConnectors() {
        return true;
    }
}

