/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.VariableDeclaration;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ApplicationStartVariablesPropertyPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeginInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    private List variableDeclarations;

    public BeginInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.variableDeclarations = new ArrayList();
    }

    public List getDeclarations() {
        ArrayList copy = new ArrayList();
        copy.addAll(this.variableDeclarations);
        return copy;
    }

    public void setDeclarations(List declarations) {
        this.variableDeclarations = declarations;
        this.getElement().fireChange();
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return false;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList decGroupList = configuration.getElementsByTagName("declarations");
        if (decGroupList.getLength() != 1) {
            return;
        }
        Element decGroupElement = (Element)decGroupList.item(0);
        NodeList varList = decGroupElement.getElementsByTagName("variable");
        int v = 0;
        while (v < varList.getLength()) {
            Element varElement = (Element)varList.item(v);
            String vname = varElement.getAttribute("name");
            String vtype = varElement.getAttribute("type");
            int vmulti = varElement.getAttribute("multiplicity").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("multiplicity"));
            int vvaluetype = varElement.getAttribute("value-type").equals("") ? 0 : Integer.parseInt(varElement.getAttribute("value-type"));
            String vvalue = varElement.getAttribute("value");
            VariableDeclaration vd = new VariableDeclaration(vname, vmulti, vtype, vvaluetype, vvalue);
            this.variableDeclarations.add(vd);
            ++v;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element declarationsElement = configuration.getOwnerDocument().createElement("declarations");
        configuration.appendChild(declarationsElement);
        int i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i);
            Element declarationElement = declarationsElement.getOwnerDocument().createElement("variable");
            declarationsElement.appendChild(declarationElement);
            declarationElement.setAttribute("name", vd.name == null ? "" : vd.name);
            declarationElement.setAttribute("type", vd.type == null ? "" : vd.type);
            declarationElement.setAttribute("multiplicity", Integer.toString(vd.multiplicity));
            declarationElement.setAttribute("value-type", Integer.toString(vd.valueType));
            declarationElement.setAttribute("value", vd.value == null ? "" : vd.value);
            ++i;
        }
    }

    public List getPropertiesPanels() {
        ArrayList<ApplicationStartVariablesPropertyPanel> ret = new ArrayList<ApplicationStartVariablesPropertyPanel>();
        ret.add(new ApplicationStartVariablesPropertyPanel("Variables", this.getElement()));
        return ret;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable platform = new Variable("Platform", FieldType.custom((String)"Platform", (boolean)true, (boolean)false, (int)0));
        platform.addField(new ObjectField("ANI", FieldType.STRING, true));
        platform.addField(new ObjectField("DNIS", FieldType.STRING, true));
        platform.addField(new ObjectField("Brand", FieldType.STRING, true));
        variables.add(platform);
        HashMap map = new HashMap();
        int i = 0;
        while (i < variables.size()) {
            map.put(((Variable)variables.get(i)).getName(), variables.get(i));
            ++i;
        }
        i = 0;
        while (i < this.variableDeclarations.size()) {
            VariableDeclaration vd = (VariableDeclaration)this.variableDeclarations.get(i);
            if (map.get(vd.name) == null) {
                FieldType ft = FieldType.custom((String)vd.type, (this.isObject(vd.type) && vd.multiplicity != 1 ? 1 : 0) != 0, (vd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                Variable v = new Variable(vd.name, ft);
                this.buildObjectFields((ObjectDefinition)v);
                variables.add(v);
            }
            ++i;
        }
        System.out.println("returning variables: " + variables.size());
        return variables;
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields((ObjectDefinition)def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public boolean canDelete() {
        return false;
    }

    public boolean hasPathToStart(Map path) {
        return true;
    }

    public boolean hasConnectors() {
        return true;
    }
}

