/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ComparisonPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.w3c.dom.NodeList;

public class ComparisonInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    private int lType = 0;
    private String lValue = "";
    private int compType = 0;
    private int rType = 0;
    private String rValue = "";

    public ComparisonInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((Element)element, "True", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "False", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.script", ConnectorRecord.ERROR_POINT));
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        NodeList nl = configuration.getElementsByTagName("comparison");
        org.w3c.dom.Element comparisonElement = null;
        comparisonElement = nl.getLength() == 0 ? configuration.getOwnerDocument().createElement("comparison") : (org.w3c.dom.Element)nl.item(0);
        System.err.println("left-type: " + comparisonElement.getAttribute("left-type") + " left-value: " + comparisonElement.getAttribute("left-value"));
        System.err.println("comp-type: " + comparisonElement.getAttribute("type"));
        System.err.println("right-type: " + comparisonElement.getAttribute("right-type") + " right-value: " + comparisonElement.getAttribute("right-value"));
        String compTypeStr = comparisonElement.getAttribute("type");
        if ("equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 0;
        }
        if ("less-than".equalsIgnoreCase(compTypeStr)) {
            this.compType = 1;
        }
        if ("less-than-or-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 2;
        }
        if ("greater-than".equalsIgnoreCase(compTypeStr)) {
            this.compType = 3;
        }
        if ("greater-than-or-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 4;
        }
        if ("not-equal".equalsIgnoreCase(compTypeStr)) {
            this.compType = 5;
        }
        this.lType = "expression".equalsIgnoreCase(comparisonElement.getAttribute("left-type")) ? 1 : 0;
        this.lValue = comparisonElement.getAttribute("left-value");
        this.rType = "expression".equalsIgnoreCase(comparisonElement.getAttribute("right-type")) ? 1 : 0;
        this.rValue = comparisonElement.getAttribute("right-value");
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        org.w3c.dom.Element comparisonElement = configuration.getOwnerDocument().createElement("comparison");
        String compTypeStr = null;
        switch (this.compType) {
            case 0: {
                compTypeStr = "equal";
                break;
            }
            case 1: {
                compTypeStr = "less-than";
                break;
            }
            case 2: {
                compTypeStr = "less-than-or-equal";
                break;
            }
            case 3: {
                compTypeStr = "greater-than";
                break;
            }
            case 4: {
                compTypeStr = "greater-than-or-equal";
                break;
            }
            case 5: {
                compTypeStr = "not-equal";
            }
        }
        comparisonElement.setAttribute("type", compTypeStr);
        comparisonElement.setAttribute("left-type", this.lType == 0 ? "variable" : "expression");
        comparisonElement.setAttribute("left-value", this.lValue);
        comparisonElement.setAttribute("right-type", this.rType == 0 ? "variable" : "expression");
        comparisonElement.setAttribute("right-value", this.rValue);
        configuration.appendChild(comparisonElement);
    }

    public List getPropertiesPanels() {
        ArrayList<PrimitivePropertiesPanel> ret = new ArrayList<PrimitivePropertiesPanel>();
        ret.add(new PrimitiveGeneralPropertiesPanel(this.getElement()));
        ret.add(new ComparisonPropertiesPanel("Comparison", this.getElement()));
        return ret;
    }

    public int getCompType() {
        return this.compType;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public int getLType() {
        return this.lType;
    }

    public void setLType(int type) {
        this.lType = type;
    }

    public String getLValue() {
        return this.lValue;
    }

    public void setLValue(String value) {
        this.lValue = value;
    }

    public int getRType() {
        return this.rType;
    }

    public void setRType(int type) {
        this.rType = type;
    }

    public String getRValue() {
        return this.rValue;
    }

    public void setRValue(String value) {
        this.rValue = value;
    }

    public boolean hasConnectors() {
        return true;
    }
}

