/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationElement;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.MissingCustomIntegrationInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.ScriptedCustomIntegrationInformationProvider;
import org.osgi.framework.Bundle;

public class CustomIntegrationElementManager {
    public static String customIntegrationExtensionPointId = "org.eclipse.vtp.desktop.editors.core.customIntegrationElement";
    private static CustomIntegrationElementManager instance = new CustomIntegrationElementManager();
    private Map customIntegrationTypes = new HashMap();

    public static CustomIntegrationElementManager getDefault() {
        return instance;
    }

    public CustomIntegrationElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(customIntegrationExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            IConfigurationElement[] scriptElements;
            CustomIntegrationElementTemplate template = null;
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String iconPath = primitiveExtensions[i].getAttribute("icon");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            if (iconPath != null) {
                Activator.getDefault().getImageRegistry().put(id, ImageDescriptor.createFromURL((URL)contributor.getEntry(iconPath)));
            }
            if ((scriptElements = primitiveExtensions[i].getChildren("information_script")).length < 1) {
                scriptElements = primitiveExtensions[i].getChildren("information_provider");
                if (scriptElements.length >= 1) {
                    String className = scriptElements[0].getAttribute("class");
                    try {
                        Class providerClass = contributor.loadClass(className);
                        template = new ImplementedClassTemplate(id, name, providerClass);
                        break block7;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                block7: {
                    template = new ScriptedTemplate(id, name, scriptElements[0]);
                }
                this.customIntegrationTypes.put(template.getId(), template);
            }
            ++i;
        }
    }

    public CustomIntegrationElement createElement(String typeId) {
        Object obj = this.customIntegrationTypes.get(typeId);
        if (obj == null) {
            return null;
        }
        CustomIntegrationElementTemplate template = (CustomIntegrationElementTemplate)obj;
        CustomIntegrationElement ret = new CustomIntegrationElement(template.getName());
        ret.setTypeId(template.getId());
        ret.setTypeName(template.getName());
        ret.setInformationProvider(template.getInformationProviderInstance(ret));
        return ret;
    }

    public CustomIntegrationElement createElement(String typeId, String id, String name) {
        Object obj = this.customIntegrationTypes.get(typeId);
        if (obj == null) {
            CustomIntegrationElement ret = new CustomIntegrationElement(id, name);
            ret.setTypeId(typeId);
            ret.setTypeName("Missing Integration");
            ret.setInformationProvider(new MissingCustomIntegrationInformationProvider(ret));
            return ret;
        }
        CustomIntegrationElementTemplate template = (CustomIntegrationElementTemplate)obj;
        CustomIntegrationElement ret = new CustomIntegrationElement(id, name);
        ret.setTypeId(template.getId());
        ret.setTypeName(template.getName());
        ret.setInformationProvider(template.getInformationProviderInstance(ret));
        return ret;
    }

    private abstract class CustomIntegrationElementTemplate {
        private String id;
        private String name;

        public CustomIntegrationElementTemplate(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public abstract CustomIntegrationInformationProvider getInformationProviderInstance(CustomIntegrationElement var1);
    }

    private class ImplementedClassTemplate
    extends CustomIntegrationElementTemplate {
        Class informationProviderClass;

        public ImplementedClassTemplate(String id, String name, Class informationProviderClass) {
            super(id, name);
            this.informationProviderClass = informationProviderClass;
        }

        public CustomIntegrationInformationProvider getInformationProviderInstance(CustomIntegrationElement element) {
            try {
                Constructor con = this.informationProviderClass.getConstructor(CustomIntegrationElement.class);
                return (CustomIntegrationInformationProvider)con.newInstance(new Object[]{element});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class ScriptedTemplate
    extends CustomIntegrationElementTemplate {
        private IConfigurationElement scriptElement;

        public ScriptedTemplate(String id, String name, IConfigurationElement scriptElement) {
            super(id, name);
            this.scriptElement = scriptElement;
        }

        public CustomIntegrationInformationProvider getInformationProviderInstance(CustomIntegrationElement element) {
            ScriptedCustomIntegrationInformationProvider ret = new ScriptedCustomIntegrationInformationProvider(element);
            ret.init(this.scriptElement);
            return ret;
        }
    }
}

