/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationElementFactory;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationElementManager;
import org.eclipse.vtp.desktop.model.core.ElementFactory;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.osgi.framework.Bundle;

public class CustomIntegrationPalletProvider
implements PalletItemProvider {
    List customIntegrationItems = new ArrayList();

    public CustomIntegrationPalletProvider() {
        IConfigurationElement[] customIntegrationExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CustomIntegrationElementManager.customIntegrationExtensionPointId);
        int i = 0;
        while (i < customIntegrationExtensions.length) {
            String id = customIntegrationExtensions[i].getAttribute("id");
            String name = customIntegrationExtensions[i].getAttribute("name");
            boolean popOnDrop = false;
            String popOnDropString = customIntegrationExtensions[i].getAttribute("pop-on-drop");
            if (popOnDropString != null) {
                popOnDrop = Boolean.parseBoolean(popOnDropString);
            }
            System.out.println("Custom Integration Item: " + name + " pop=" + popOnDrop);
            Bundle contributor = Platform.getBundle((String)customIntegrationExtensions[i].getContributor().getName());
            String className = customIntegrationExtensions[i].getAttribute("container-type");
            if (className != null) {
                try {
                    final Class providerClass = contributor.loadClass(className);
                    PalletItem palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), new CustomIntegrationElementFactory(), id){

                        public boolean canBeContainedBy(IAdaptable container) {
                            return container.getAdapter(providerClass) != null;
                        }
                    };
                    palletItem.setPopOnDrop(popOnDrop);
                    this.customIntegrationItems.add(palletItem);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                PalletItem palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), (ElementFactory)new CustomIntegrationElementFactory(), (Object)id);
                palletItem.setPopOnDrop(popOnDrop);
                this.customIntegrationItems.add(palletItem);
            }
            ++i;
        }
    }

    public String getName() {
        return "Custom Integrations";
    }

    public List getPalletItems() {
        return this.customIntegrationItems;
    }

    public int getRanking() {
        return 40;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, PalletItem[] selectedItems) {
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
    }
}

