/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.DatabaseQueryDataMappingPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.DatabaseQuerySearchCriteriaPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.DatabaseQuerySettingsStructure;
import org.eclipse.vtp.desktop.editors.core.elements.properties.DatabaseQuerySourceDatabasePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.DatabaseQueryTargetVariablePropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DatabaseQueryInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    DatabaseQuerySettingsStructure settings = new DatabaseQuerySettingsStructure();

    public DatabaseQueryInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)element, "error.database.connection", ConnectorRecord.ERROR_POINT));
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        NodeList nl = configuration.getElementsByTagName("settings");
        if (nl.getLength() > 0) {
            this.settings.read((Element)nl.item(0));
        }
    }

    public void writeConfiguration(Element configuration) {
        Element settingsElement = configuration.getOwnerDocument().createElement("settings");
        configuration.appendChild(settingsElement);
        this.settings.write(settingsElement);
    }

    public List getPropertiesPanels() {
        DatabaseQuerySettingsStructure copy = (DatabaseQuerySettingsStructure)this.settings.clone();
        ArrayList<PrimitivePropertiesPanel> ret = new ArrayList<PrimitivePropertiesPanel>();
        ret.add(new DatabaseQueryTargetVariablePropertiesPanel(this.getElement(), copy));
        ret.add(new DatabaseQuerySourceDatabasePropertiesPanel(this.getElement(), copy));
        ret.add(new DatabaseQueryDataMappingPropertiesPanel(this.getElement(), copy));
        ret.add(new DatabaseQuerySearchCriteriaPropertiesPanel(this.getElement(), copy));
        return ret;
    }

    public DatabaseQuerySettingsStructure getSettings() {
        return this.settings;
    }

    public void setSettings(DatabaseQuerySettingsStructure settings) {
        this.settings = settings;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (!this.settings.isTargetVariableExists()) {
            FieldType ft = FieldType.custom((String)this.settings.getTargetVariableType(), (this.isObject(this.settings.getTargetVariableType()) && this.settings.getTargetMultiplicity() != 1 ? 1 : 0) != 0, (this.settings.getTargetMultiplicity() == 1 ? 1 : 0) != 0, (int)0);
            Variable v = new Variable(this.settings.getTargetVariableName(), ft);
            this.buildObjectFields((ObjectDefinition)v);
            ret.add(v);
        }
        return ret;
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IVoiceToolsDesignProject)this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields((ObjectDefinition)def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public boolean hasConnectors() {
        return true;
    }
}

