/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.editors.core.elements.DialogGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.ExitInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.model.core.Component;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Model;
import org.eclipse.vtp.desktop.model.core.ModelListener;
import org.w3c.dom.Element;

public class DialogElement
extends org.eclipse.vtp.desktop.model.core.Element
implements ModelListener {
    private RenderedModel dialogModel;
    private List connectorRecords = new ArrayList();
    private String typeId;
    private boolean hasConnectors = false;
    private Map watchers = new HashMap();

    public DialogElement(String name) {
        super(name);
    }

    public DialogElement(String id, String name) {
        super(id, name);
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeid() {
        return this.typeId;
    }

    public void setDialogModel(RenderedModel dialogModel) {
        this.dialogModel = dialogModel;
        dialogModel.getUIModel().getModel().addListener((ModelListener)this);
        List elements = dialogModel.getUIModel().getModel().listElements();
        int i = 0;
        while (i < elements.size()) {
            ((org.eclipse.vtp.desktop.model.core.Element)elements.get(i)).setScope(this.getId());
            if (elements.get(i) instanceof PrimitiveElement) {
                PrimitiveElement primitiveElement = (PrimitiveElement)((Object)elements.get(i));
                System.out.println("primitive element in dialog: " + primitiveElement.getTypeId());
                if (primitiveElement.getTypeId().equals("org.eclipse.vtp.desktop.editors.core.exit")) {
                    String exitType = ((ExitInformationProvider)primitiveElement.getInformationProvider()).getExitType();
                    ConnectorRecord connectorRecord = new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)primitiveElement, primitiveElement.getName(), exitType.equals("Normal") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
                    this.connectorRecords.add(connectorRecord);
                    NameWatcher nameWatcher = new NameWatcher(connectorRecord);
                    primitiveElement.addPropertyListener(nameWatcher);
                    this.watchers.put(primitiveElement, nameWatcher);
                    this.hasConnectors = true;
                }
            }
            ++i;
        }
        dialogModel.getUIModel().getModel().putDataService("DialogElement", (Object)this);
    }

    public RenderedModel getDialogModel() {
        return this.dialogModel;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        System.out.println("Getting dialog connector records: " + this.connectorRecords.size());
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        if ((type & ConnectorRecord.EXIT_POINT) > 0) {
            return Collections.unmodifiableList(this.connectorRecords);
        }
        return new ArrayList();
    }

    public void readConfiguration(Element configuration) {
    }

    public void writeConfiguration(Element configuration) {
        Element elementElement = configuration.getOwnerDocument().createElement("dialog-element");
        configuration.appendChild(elementElement);
        elementElement.setAttribute("id", this.getId());
        elementElement.setAttribute("name", this.getName());
        List configurationManagers = this.listConfigurationManagers();
        for (ConfigurationManager manager : configurationManagers) {
            manager.writeConfiguration(elementElement);
        }
        Element customElement = elementElement.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config");
        elementElement.appendChild(customElement);
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return true;
    }

    public List getConfigurationPanels() {
        ArrayList<DialogGeneralPropertiesPanel> ret = new ArrayList<DialogGeneralPropertiesPanel>();
        ret.add(new DialogGeneralPropertiesPanel(this));
        return ret;
    }

    public String getTypeName() {
        return "Dialog";
    }

    public Image getIcon() {
        return null;
    }

    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public void componentAdded(Model model, Component component) {
        PrimitiveElement primitiveElement;
        if (component instanceof PrimitiveElement && (primitiveElement = (PrimitiveElement)component).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.exit")) {
            String exitType = ((ExitInformationProvider)primitiveElement.getInformationProvider()).getExitType();
            ConnectorRecord connectorRecord = new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)primitiveElement, primitiveElement.getName(), exitType.equals("Normal") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
            this.connectorRecords.add(connectorRecord);
            NameWatcher nameWatcher = new NameWatcher(connectorRecord);
            primitiveElement.addPropertyListener(nameWatcher);
            this.watchers.put(primitiveElement, nameWatcher);
            this.hasConnectors = true;
        }
    }

    public void componentRemoved(Model model, Component component) {
        PrimitiveElement primitiveElement;
        if (component instanceof PrimitiveElement && (primitiveElement = (PrimitiveElement)component).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.exit")) {
            NameWatcher nameWatcher = (NameWatcher)this.watchers.get((Object)primitiveElement);
            primitiveElement.removePropertyListener(nameWatcher);
            this.watchers.remove((Object)primitiveElement);
            this.connectorRecords.remove(nameWatcher.watched);
            if (nameWatcher.watched.getConnector() != null) {
                Connector connector = nameWatcher.watched.getConnector();
                connector.removeExitPoint(nameWatcher.watched);
                if (connector.getExitCodes().size() == 0) {
                    this.getModel().removeConnector(connector);
                }
            }
        }
    }

    public void getOutgoingVariables(String exitPoint, Map variables, Map visited) {
        super.getOutgoingVariables(exitPoint, variables, visited);
        List elements = this.dialogModel.getUIModel().getModel().listElements();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof PrimitiveElement) {
                PrimitiveElement primitiveElement = (PrimitiveElement)((Object)elements.get(i));
                System.out.println("primitive element in dialog: " + primitiveElement.getTypeId());
                if (primitiveElement.getTypeId().equals("org.eclipse.vtp.desktop.editors.core.exit")) {
                    System.err.println("exit found: " + primitiveElement.getName());
                    if (primitiveElement.getName().equals(exitPoint)) {
                        primitiveElement.getIncomingVariables(variables, visited);
                    }
                }
            }
            ++i;
        }
    }

    private class NameWatcher
    implements PropertyChangeListener {
        ConnectorRecord watched = null;

        public NameWatcher(ConnectorRecord watched) {
            this.watched = watched;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("model.element.name")) {
                this.watched.setName((String)evt.getNewValue());
            } else if (evt.getPropertyName().equals("PROP_EXIT_TYPE")) {
                String exitType = (String)evt.getNewValue();
                this.watched.setType(exitType.equals("Normal") ? ConnectorRecord.EXIT_POINT : ConnectorRecord.ERROR_POINT);
            }
        }
    }
}

