/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.Activator;
import org.osgi.framework.Bundle;

public class DialogElementManager {
    public static String dialogExtensionPointId = "org.eclipse.vtp.desktop.editors.core.dialogElement";
    private static DialogElementManager instance = new DialogElementManager();
    private Map dialogTypes = new HashMap();

    public static DialogElementManager getDefault() {
        return instance;
    }

    public DialogElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(dialogExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            DialogElementRecord der = new DialogElementRecord();
            der.id = primitiveExtensions[i].getAttribute("id");
            der.name = primitiveExtensions[i].getAttribute("name");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            der.resourceURL = contributor.getResource(primitiveExtensions[i].getAttribute("template"));
            this.dialogTypes.put(der.id, der);
            ++i;
        }
    }

    public String getName(String id) {
        DialogElementRecord der = (DialogElementRecord)this.dialogTypes.get(id);
        if (der != null) {
            return der.name;
        }
        Activator.LocalDialogRecord record = Activator.getDefault().getLocalDialog(id);
        if (record != null) {
            return record.getName();
        }
        return null;
    }

    public URL getTemplate(String id) {
        DialogElementRecord der = (DialogElementRecord)this.dialogTypes.get(id);
        if (der != null) {
            return der.resourceURL;
        }
        Activator.LocalDialogRecord record = Activator.getDefault().getLocalDialog(id);
        if (record != null) {
            return record.getTemplateURL();
        }
        return null;
    }

    private class DialogElementRecord {
        String id;
        String name;
        URL resourceURL;

        private DialogElementRecord() {
        }
    }
}

