/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ExitGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;

public class ExitInformationProvider
extends PrimitiveInformationProvider {
    public static final String PROP_EXIT_TYPE = "PROP_EXIT_TYPE";
    List connectorRecords = new ArrayList();
    String exitType = "Normal";

    public ExitInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.exitType = configuration.getAttribute("exit-type");
        if (!this.exitType.equals("Normal") && !this.exitType.equals("Error")) {
            this.exitType = "Normal";
        }
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("exit-type", this.exitType);
    }

    public List getPropertiesPanels() {
        ArrayList<ExitGeneralPropertiesPanel> ret = new ArrayList<ExitGeneralPropertiesPanel>();
        ret.add(new ExitGeneralPropertiesPanel(this.getElement()));
        return ret;
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String text) {
        String oldType = this.exitType;
        this.exitType = text;
        this.getElement().firePropertyChange(PROP_EXIT_TYPE, oldType, text);
    }

    public boolean hasConnectors() {
        return false;
    }
}

