/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.MenuChoice;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.CombinedMediaPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OptionSetInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    List menuChoices = new ArrayList();
    Map brandOrders = new HashMap();

    public OptionSetInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)element, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)element, "error.input.noinput", ConnectorRecord.ERROR_POINT));
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
        MenuChoice mc;
        try {
            Element[] choices = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)configuration, (String)"choices"));
            int ch = 0;
            while (ch < choices.length) {
                MenuChoice mc2 = new MenuChoice(choices[ch].getAttribute("name"), choices[ch].getAttribute("script"));
                this.menuChoices.add(mc2);
                this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)this.getElement(), mc2.getOptionName(), ConnectorRecord.EXIT_POINT));
                ++ch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList brandOrdersList = configuration.getElementsByTagName("brand-order");
        if (brandOrdersList.getLength() == 0) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            int i = 0;
            while (i < this.menuChoices.size()) {
                mc = (MenuChoice)this.menuChoices.get(i);
                defaultList.add(mc);
                ++i;
            }
            this.brandOrders.put("Default", defaultList);
        }
        int i = 0;
        while (i < brandOrdersList.getLength()) {
            ArrayList<MenuChoice> brandList = new ArrayList<MenuChoice>();
            Element brandOrderElement = (Element)brandOrdersList.item(i);
            String brandName = brandOrderElement.getAttribute("brand");
            NodeList entryList = brandOrderElement.getElementsByTagName("entry");
            int e = 0;
            while (e < entryList.getLength()) {
                Element entryElement = (Element)entryList.item(e);
                int x = 0;
                while (x < this.menuChoices.size()) {
                    MenuChoice mc3 = (MenuChoice)this.menuChoices.get(x);
                    if (mc3.getOptionName().equals(entryElement.getAttribute("name"))) {
                        brandList.add(mc3);
                        break;
                    }
                    ++x;
                }
                ++e;
            }
            this.brandOrders.put(brandName, brandList);
            ++i;
        }
        if (this.brandOrders.get("Default") == null) {
            ArrayList<MenuChoice> defaultList = new ArrayList<MenuChoice>();
            int i2 = 0;
            while (i2 < this.menuChoices.size()) {
                mc = (MenuChoice)this.menuChoices.get(i2);
                defaultList.add(mc);
                ++i2;
            }
            this.brandOrders.put("Default", defaultList);
        }
    }

    public void writeConfiguration(Element configuration) {
        Element choicesElement = configuration.getOwnerDocument().createElement("choices");
        configuration.appendChild(choicesElement);
        int i = 0;
        while (i < this.menuChoices.size()) {
            MenuChoice mc = (MenuChoice)this.menuChoices.get(i);
            Element choiceElement = configuration.getOwnerDocument().createElement("choice");
            choiceElement.setAttribute("name", mc.getOptionName());
            if (mc.getScirptText() != null) {
                choiceElement.setAttribute("script", mc.getScirptText());
            }
            choicesElement.appendChild(choiceElement);
            ++i;
        }
        for (Map.Entry entry : this.brandOrders.entrySet()) {
            Element orderElement = configuration.getOwnerDocument().createElement("brand-order");
            orderElement.setAttribute("brand", (String)entry.getKey());
            configuration.appendChild(orderElement);
            List options = (List)entry.getValue();
            int i2 = 0;
            while (i2 < options.size()) {
                MenuChoice mc = (MenuChoice)options.get(i2);
                Element orderEntryElement = configuration.getOwnerDocument().createElement("entry");
                orderEntryElement.setAttribute("name", mc.getOptionName());
                orderEntryElement.setAttribute("spot", Integer.toString(i2));
                orderElement.appendChild(orderEntryElement);
                ++i2;
            }
        }
    }

    public List getPropertiesPanels() {
        ArrayList<CombinedMediaPropertiesPanel> ret = new ArrayList<CombinedMediaPropertiesPanel>();
        ret.add(new CombinedMediaPropertiesPanel(this.getElement()));
        return ret;
    }

    public MenuChoice addChoice(String brand, MenuChoice choice) {
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        int i = 0;
        while (i < this.menuChoices.size()) {
            MenuChoice mc = (MenuChoice)this.menuChoices.get(i);
            if (mc.getOptionName().equals(choice.getOptionName())) {
                orderList.add(mc);
                return mc;
            }
            ++i;
        }
        this.menuChoices.add(choice);
        orderList.add(choice);
        this.connectorRecords.add(new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)this.getElement(), choice.getOptionName(), ConnectorRecord.EXIT_POINT));
        return choice;
    }

    public void moveChoiceUp(String brand, MenuChoice choice) {
        int index;
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        if ((index = orderList.indexOf(choice)) > 0) {
            orderList.remove(index);
            orderList.add(index - 1, choice);
        }
    }

    public void moveChoiceDown(String brand, MenuChoice choice) {
        System.out.println("brand: " + brand);
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            System.out.println("loading default list");
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        int index = orderList.indexOf(choice);
        System.out.println("index: " + index);
        if (index < orderList.size() - 1) {
            orderList.remove(index);
            orderList.add(index + 1, choice);
        }
    }

    public void removeChoice(String brand, MenuChoice choice) {
        ArrayList orderList = (ArrayList)this.brandOrders.get(brand);
        if (orderList == null) {
            orderList = new ArrayList();
            List defaultList = (List)this.brandOrders.get("Default");
            int i = 0;
            while (i < defaultList.size()) {
                orderList.add(defaultList.get(i));
                ++i;
            }
            this.brandOrders.put(brand, orderList);
        }
        orderList.remove(choice);
        Iterator iterator = this.brandOrders.entrySet().iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List mcList = (List)entry.getValue();
            if (!mcList.contains(choice)) continue;
            found = true;
        }
        if (!found) {
            this.menuChoices.remove(choice);
            int i = 0;
            while (i < this.connectorRecords.size()) {
                ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
                if (cr.getName().equals(choice.getOptionName())) {
                    if (cr.getConnector() != null) {
                        Connector connector = cr.getConnector();
                        connector.removeExitPoint(cr);
                        if (connector.getExitCodes().size() == 0) {
                            this.getElement().getModel().removeConnector(connector);
                        }
                    }
                    this.connectorRecords.remove(cr);
                    break;
                }
                ++i;
            }
        }
    }

    public void updateChoice(MenuChoice choice, String oldName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(oldName)) {
                cr.setName(choice.getOptionName());
                break;
            }
            ++i;
        }
    }

    public List getChoices() {
        return Collections.unmodifiableList(this.menuChoices);
    }

    public List getChoicesByBrand(String brand) {
        System.out.println("brand: " + brand);
        Object obj = this.brandOrders.get(brand);
        if (obj == null) {
            System.out.println("default list");
            obj = this.brandOrders.get("Default");
            if (obj == null) {
                System.out.println("empty menu");
                obj = new ArrayList();
                this.brandOrders.put("Default", obj);
            }
        }
        return Collections.unmodifiableList((List)obj);
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (!exitPoint.startsWith("error.")) {
            Variable v = new Variable("LastResult", FieldType.STRING);
            ret.add(v);
        }
        return ret;
    }

    public boolean hasConnectors() {
        return true;
    }
}

