/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.elements.PortalExitInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.actions.JumpToPortalExitAction;
import org.eclipse.vtp.desktop.editors.core.elements.properties.PortalEntryPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;

public class PortalEntryInformationProvider
extends PrimitiveInformationProvider
implements PropertyChangeListener {
    List connectorRecords = new ArrayList();
    String exitId = "";
    PrimitiveElement exitElement = null;

    public PortalEntryInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.exitId = configuration.getAttribute("exit-id");
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("exit-id", this.exitId);
    }

    public List getPropertiesPanels() {
        ArrayList<PortalEntryPropertiesPanel> ret = new ArrayList<PortalEntryPropertiesPanel>();
        ret.add(new PortalEntryPropertiesPanel("General", this.getElement()));
        return ret;
    }

    public String getExitId() {
        return this.exitId;
    }

    public void setExitId(String text) {
        this.exitId = text;
        this.resolve();
    }

    public void resolve() {
        if (this.exitElement != null) {
            this.exitElement.removePropertyListener(this);
        }
        List elements = this.getElement().getModel().listElements();
        for (Element element : elements) {
            PrimitiveElement primitiveElement;
            if (!(element instanceof PrimitiveElement) || !(primitiveElement = (PrimitiveElement)element).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.portalExit") || !primitiveElement.getId().equals(this.exitId)) continue;
            this.exitElement = primitiveElement;
            this.exitElement.addPropertyListener(this);
            ((PortalExitInformationProvider)this.exitElement.getInformationProvider()).addEntry(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model.element.name")) {
            this.getElement().setName((String)evt.getNewValue());
        }
    }

    public List getActions(CommandListener commandListener) {
        ArrayList<JumpToPortalExitAction> ret = new ArrayList<JumpToPortalExitAction>();
        ret.add(new JumpToPortalExitAction(this.getElement(), commandListener));
        return ret;
    }

    public boolean hasConnectors() {
        return false;
    }
}

