/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.elements.PortalEntryInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.PortalExitGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;

public class PortalExitInformationProvider
extends PrimitiveInformationProvider
implements PropertyChangeListener {
    List connectorRecords = new ArrayList();
    List entryProviders = new ArrayList();
    PrimitiveElement exitElement = null;

    public PortalExitInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
    }

    public boolean acceptConnector(Element origin) {
        return false;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
    }

    public List getPropertiesPanels() {
        ArrayList<PortalExitGeneralPropertiesPanel> ret = new ArrayList<PortalExitGeneralPropertiesPanel>();
        ret.add(new PortalExitGeneralPropertiesPanel("General", this.getElement()));
        return ret;
    }

    public void addEntry(PortalEntryInformationProvider entryProvider) {
        this.entryProviders.remove(entryProvider);
        this.entryProviders.add(entryProvider);
    }

    public void removeEntry(PortalEntryInformationProvider entryProvider) {
        this.entryProviders.remove(entryProvider);
    }

    public void resolve() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model.element.name")) {
            this.getElement().setName((String)evt.getNewValue());
        }
    }

    public List getActions(CommandListener commandListener) {
        ArrayList ret = new ArrayList();
        return ret;
    }

    public boolean hasPathToStart(Map path) {
        for (PortalEntryInformationProvider entry : this.entryProviders) {
            if (!entry.getElement().hasPathToStart(path)) continue;
            return true;
        }
        return super.hasPathToStart(path);
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList outgoing = new ArrayList();
        HashMap vars = new HashMap();
        for (PortalEntryInformationProvider entry : this.entryProviders) {
            System.out.println(entry);
            entry.getElement().getIncomingVariables(vars, visited);
            outgoing.addAll(vars.values());
        }
        return outgoing;
    }

    public boolean hasConnectors() {
        return true;
    }
}

