/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;

public class PrimitiveElement
extends Element {
    private String typeId;
    private String typeName;
    private PrimitiveInformationProvider info;

    public PrimitiveElement(String name) {
        super(name);
    }

    public PrimitiveElement(String id, String name) {
        super(id, name);
    }

    void setInformationProvider(PrimitiveInformationProvider info) {
        this.info = info;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        return this.info.getConnectorRecord(recordName);
    }

    public List getConnectorRecords() {
        return this.info.getConnectorRecords();
    }

    public List getConnectorRecords(int type) {
        return this.info.getConnectorRecords(type);
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.info.readConfiguration(configuration);
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        org.w3c.dom.Element elementElement = configuration.getOwnerDocument().createElement("primitive-element");
        configuration.appendChild(elementElement);
        elementElement.setAttribute("id", this.getId());
        elementElement.setAttribute("name", this.getName());
        elementElement.setAttribute("type", this.typeId);
        List configurationManagers = this.listConfigurationManagers();
        for (ConfigurationManager manager : configurationManagers) {
            manager.writeConfiguration(elementElement);
        }
        org.w3c.dom.Element customElement = elementElement.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/namespaces/config", "custom-config");
        elementElement.appendChild(customElement);
        this.info.writeConfiguration(customElement);
    }

    public boolean acceptConnector(Element origin) {
        return this.info.acceptConnector(origin);
    }

    public void showProperties() {
        System.out.println("Show primitive properties!");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List getConfigurationPanels() {
        return this.info.getPropertiesPanels();
    }

    public PrimitiveInformationProvider getInformationProvider() {
        return this.info;
    }

    public Image getIcon() {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        return imageRegistry.get(this.typeId);
    }

    public void getOutgoingVariables(String exitPoint, Map variables, Map visited) {
        System.out.println("getting info provider's variables");
        if (visited.get(String.valueOf(this.getId()) + ":" + exitPoint) == null) {
            List providedVariables = this.info.getOutgoingVariables(exitPoint, visited);
            for (ObjectDefinition objDef : providedVariables) {
                if (variables.containsKey(objDef.getName())) continue;
                variables.put(objDef.getName(), objDef);
            }
        }
        super.getOutgoingVariables(exitPoint, variables, visited);
    }

    public List getActions(CommandListener commandListener) {
        return this.info.getActions(commandListener);
    }

    public boolean canDelete() {
        return this.info.canDelete();
    }

    public void resolve() {
        this.info.resolve();
    }

    public boolean hasPathToStart(Map originPath) {
        if (originPath == null) {
            originPath = new HashMap();
        }
        return super.hasPathToStart((Map)originPath) || this.info.hasPathToStart(originPath);
    }

    public void fireChange() {
        super.fireChange();
    }

    public boolean hasConnectors() {
        return this.info.hasConnectors();
    }
}

