/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.ScriptedPrimitiveInformationProvider;
import org.osgi.framework.Bundle;

public class PrimitiveElementManager {
    public static String primitiveExtensionPointId = "org.eclipse.vtp.desktop.editors.core.primitiveElement";
    private static PrimitiveElementManager instance = new PrimitiveElementManager();
    private Map primitiveTypes = new HashMap();

    public static PrimitiveElementManager getDefault() {
        return instance;
    }

    public PrimitiveElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(primitiveExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            IConfigurationElement[] scriptElements;
            PrimitiveElementTemplate template = null;
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            String iconPath = primitiveExtensions[i].getAttribute("icon");
            String uniqueNameString = primitiveExtensions[i].getAttribute("unique-name");
            if (uniqueNameString != null) {
                Boolean.parseBoolean(uniqueNameString);
            }
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            if (iconPath != null) {
                Activator.getDefault().getImageRegistry().put(id, ImageDescriptor.createFromURL((URL)contributor.getEntry(iconPath)));
            }
            if ((scriptElements = primitiveExtensions[i].getChildren("information_script")).length < 1) {
                scriptElements = primitiveExtensions[i].getChildren("information_provider");
                if (scriptElements.length >= 1) {
                    String className = scriptElements[0].getAttribute("class");
                    try {
                        Class providerClass = contributor.loadClass(className);
                        template = new ImplementedClassTemplate(id, name, providerClass);
                        break block8;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                block8: {
                    template = new ScriptedTemplate(id, name, scriptElements[0]);
                }
                this.primitiveTypes.put(template.getId(), template);
            }
            ++i;
        }
    }

    public PrimitiveElement createElement(String typeId) {
        Object obj = this.primitiveTypes.get(typeId);
        if (obj == null) {
            return null;
        }
        PrimitiveElementTemplate template = (PrimitiveElementTemplate)obj;
        PrimitiveElement ret = new PrimitiveElement(template.getName());
        ret.setTypeId(template.getId());
        ret.setTypeName(template.getName());
        ret.setInformationProvider(template.getInformationProviderInstance(ret));
        return ret;
    }

    public PrimitiveElement createElement(String typeId, String id, String name) {
        Object obj = this.primitiveTypes.get(typeId);
        if (obj == null) {
            return null;
        }
        PrimitiveElementTemplate template = (PrimitiveElementTemplate)obj;
        PrimitiveElement ret = new PrimitiveElement(id, name);
        ret.setTypeId(template.getId());
        ret.setTypeName(template.getName());
        ret.setInformationProvider(template.getInformationProviderInstance(ret));
        return ret;
    }

    private class ImplementedClassTemplate
    extends PrimitiveElementTemplate {
        Class informationProviderClass;

        public ImplementedClassTemplate(String id, String name, Class informationProviderClass) {
            super(id, name);
            this.informationProviderClass = informationProviderClass;
        }

        public PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement element) {
            try {
                Constructor con = this.informationProviderClass.getConstructor(PrimitiveElement.class);
                return (PrimitiveInformationProvider)con.newInstance(new Object[]{element});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private abstract class PrimitiveElementTemplate {
        private String id;
        private String name;

        public PrimitiveElementTemplate(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public abstract PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement var1);
    }

    private class ScriptedTemplate
    extends PrimitiveElementTemplate {
        private IConfigurationElement scriptElement;

        public ScriptedTemplate(String id, String name, IConfigurationElement scriptElement) {
            super(id, name);
            this.scriptElement = scriptElement;
        }

        public PrimitiveInformationProvider getInformationProviderInstance(PrimitiveElement element) {
            ScriptedPrimitiveInformationProvider ret = new ScriptedPrimitiveInformationProvider(element);
            ret.init(this.scriptElement);
            return ret;
        }
    }
}

