/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenManager;
import org.eclipse.vtp.desktop.model.core.Element;

public class PrimitiveMediaPropertiesPanel
extends PrimitivePropertiesPanel {
    StackLayout stackLayout = null;
    Map screensByType;
    Composite comp = null;

    public PrimitiveMediaPropertiesPanel(PrimitiveElement element) {
        super("Media & Settings", element);
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(element.getTypeId(), (Element)element);
    }

    public PrimitiveMediaPropertiesPanel(String name, PrimitiveElement element) {
        super(name, element);
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(element.getTypeId(), (Element)element);
    }

    public void createControls(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setBackground(parent.getBackground());
        this.stackLayout = new StackLayout();
        this.comp.setLayout((Layout)this.stackLayout);
        Set s = this.screensByType.entrySet();
        for (Map.Entry entry : s) {
            MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
            mcs.createControls(this.comp);
            this.stackLayout.topControl = mcs.getControl();
        }
        this.setControl((Control)this.comp);
    }

    public void save() {
        Set s = this.screensByType.entrySet();
        for (Map.Entry entry : s) {
            MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
            mcs.save();
        }
    }

    public void cancel() {
        Set s = this.screensByType.entrySet();
        for (Map.Entry entry : s) {
            MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
            mcs.cancel();
        }
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
        MediaConfigurationScreen mcs = (MediaConfigurationScreen)this.screensByType.get(interactionType);
        if (mcs != null) {
            mcs.setBrand(brand);
            mcs.setLanguage(language);
            this.stackLayout.topControl = mcs.getControl();
            this.comp.layout(true, true);
        }
    }
}

