/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElementFactory;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElementManager;
import org.eclipse.vtp.desktop.model.core.ElementFactory;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.osgi.framework.Bundle;

public class PrimitivePalletProvider
implements PalletItemProvider {
    List primitiveItems = new ArrayList();

    public PrimitivePalletProvider() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PrimitiveElementManager.primitiveExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            PalletItem palletItem;
            Class providerClass;
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            boolean popOnDrop = false;
            String popOnDropString = primitiveExtensions[i].getAttribute("pop-on-drop");
            if (popOnDropString != null) {
                popOnDrop = Boolean.parseBoolean(popOnDropString);
            }
            System.out.println("Primitive Item: " + name + " pop=" + popOnDrop);
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            String className = primitiveExtensions[i].getAttribute("container-type");
            String exclassName = primitiveExtensions[i].getAttribute("non-container-type");
            if (className != null) {
                try {
                    providerClass = contributor.loadClass(className);
                    palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), new PrimitiveElementFactory(), id){

                        public boolean canBeContainedBy(IAdaptable container) {
                            return container.getAdapter(providerClass) != null;
                        }
                    };
                    palletItem.setPopOnDrop(popOnDrop);
                    this.primitiveItems.add(palletItem);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (exclassName != null) {
                try {
                    providerClass = contributor.loadClass(exclassName);
                    palletItem = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), new PrimitiveElementFactory(), id){

                        public boolean canBeContainedBy(IAdaptable container) {
                            return container.getAdapter(providerClass) == null;
                        }
                    };
                    palletItem.setPopOnDrop(popOnDrop);
                    this.primitiveItems.add(palletItem);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                PalletItem palletItem2 = new PalletItem(name, Activator.getDefault().getImageRegistry().get(id), (ElementFactory)new PrimitiveElementFactory(), (Object)id);
                palletItem2.setPopOnDrop(popOnDrop);
                this.primitiveItems.add(palletItem2);
            }
            ++i;
        }
    }

    public String getName() {
        return "Common";
    }

    public List getPalletItems() {
        return this.primitiveItems;
    }

    public int getRanking() {
        return 10;
    }

    public void createMenu(IAdaptable container, IMenuManager manager, PalletItem[] selectedItems) {
    }

    public void addPalletItemObserver(PalletItemObserver observer) {
    }

    public void removePalletItemObserver(PalletItemObserver observer) {
    }
}

