/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.QuestionCombinedMediaPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;

public class QuestionInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    String variableName = "";

    public QuestionInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.input.noinput", ConnectorRecord.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.variableName = configuration.getAttribute("variable-name");
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("variable-name", this.variableName);
    }

    public List getPropertiesPanels() {
        ArrayList<QuestionCombinedMediaPropertiesPanel> ret = new ArrayList<QuestionCombinedMediaPropertiesPanel>();
        ret.add(new QuestionCombinedMediaPropertiesPanel(this.getElement()));
        return ret;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String text) {
        this.variableName = text;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        ArrayList<Variable> ret = new ArrayList<Variable>();
        if (exitPoint.equals("Continue")) {
            Variable var = new Variable(this.variableName, FieldType.STRING);
            ret.add(var);
            Variable v = new Variable("LastResult", FieldType.STRING);
            ret.add(v);
        }
        return ret;
    }

    public boolean hasConnectors() {
        return true;
    }
}

