/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.RecordCombinedMediaPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.eclipse.vtp.framework.util.XMLUtilities;

public class RecordInformationProvider
extends PrimitiveInformationProvider {
    List incomingConnectors;
    List connectorRecords = new ArrayList();
    private List listeners = new ArrayList();
    private List inputs = new ArrayList();
    private List outputs = new ArrayList();
    private String varName = "";

    public RecordInformationProvider(PrimitiveElement element) {
        super(element);
        this.incomingConnectors = new ArrayList();
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.input.nomatch", ConnectorRecord.ERROR_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.input.noinput", ConnectorRecord.ERROR_POINT));
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public String getVariableName() {
        return this.varName;
    }

    public void setVariableName(String varName) {
        this.varName = varName;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.varName = configuration.getAttribute("var-name");
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("var-name", XMLUtilities.encodeAttribute((String)this.varName));
    }

    public List getPropertiesPanels() {
        ArrayList<RecordCombinedMediaPropertiesPanel> ret = new ArrayList<RecordCombinedMediaPropertiesPanel>();
        ret.add(new RecordCombinedMediaPropertiesPanel(this.getElement()));
        return ret;
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        if (exitPoint.equals("Continue")) {
            ArrayList<Variable> ret = new ArrayList<Variable>();
            if (this.varName != null && !this.varName.equals("")) {
                FieldType ft = FieldType.STRING;
                Variable v = new Variable(this.varName, ft);
                this.buildObjectFields((ObjectDefinition)v);
                ret.add(v);
            }
            return ret;
        }
        return super.getOutgoingVariables(exitPoint, visited);
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields((ObjectDefinition)def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public boolean hasConnectors() {
        return true;
    }
}

