/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ReturnGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ReturnVariablesPropertyPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.w3c.dom.NodeList;

public class ReturnInformationProvider
extends PrimitiveInformationProvider {
    public static final String PROP_EXIT_TYPE = "PROP_EXIT_TYPE";
    List connectorRecords = new ArrayList();
    String exitType = "Normal";
    List exportedVars = new ArrayList();

    public ReturnInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        this.exitType = configuration.getAttribute("exit-type");
        if (!this.exitType.equals("Normal") && !this.exitType.equals("Error")) {
            this.exitType = "Normal";
        }
        NodeList exportList = configuration.getElementsByTagName("export");
        int i = 0;
        while (i < exportList.getLength()) {
            this.exportedVars.add(((org.w3c.dom.Element)exportList.item(i)).getAttribute("name"));
            ++i;
        }
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("exit-type", this.exitType);
        int i = 0;
        while (i < this.exportedVars.size()) {
            String name = (String)this.exportedVars.get(i);
            org.w3c.dom.Element el = configuration.getOwnerDocument().createElement("export");
            configuration.appendChild(el);
            el.setAttribute("name", name);
            ++i;
        }
    }

    public List getExports() {
        return this.exportedVars;
    }

    public void setExports(List exports) {
        this.exportedVars = exports;
    }

    public List getPropertiesPanels() {
        ArrayList<PrimitivePropertiesPanel> ret = new ArrayList<PrimitivePropertiesPanel>();
        ret.add(new ReturnGeneralPropertiesPanel(this.getElement()));
        ret.add(new ReturnVariablesPropertyPanel("Exported Variables", this.getElement()));
        return ret;
    }

    public List getOutgoingVariables(String exitPoint, Map visited) {
        return super.getOutgoingVariables(exitPoint, visited);
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String text) {
        String oldType = this.exitType;
        this.exitType = text;
        this.getElement().firePropertyChange(PROP_EXIT_TYPE, oldType, text);
    }

    public boolean hasConnectors() {
        return false;
    }
}

