/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.ScriptPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.NodeList;

public class ScriptInformationProvider
extends PrimitiveInformationProvider {
    List connectorRecords = new ArrayList();
    String scriptText = "";

    public ScriptInformationProvider(PrimitiveElement element) {
        super(element);
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.script", ConnectorRecord.ERROR_POINT));
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        NodeList nl = configuration.getElementsByTagName("script");
        if (nl.getLength() > 0) {
            org.w3c.dom.Element scriptElement = (org.w3c.dom.Element)nl.item(0);
            try {
                this.scriptText = XMLUtilities.getElementTextData((org.w3c.dom.Element)scriptElement, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        org.w3c.dom.Element scriptElement = configuration.getOwnerDocument().createElement("script");
        configuration.appendChild(scriptElement);
        scriptElement.setTextContent(this.scriptText);
    }

    public List getPropertiesPanels() {
        ArrayList<ScriptPropertiesPanel> ret = new ArrayList<ScriptPropertiesPanel>();
        ret.add(new ScriptPropertiesPanel("Properties", this.getElement()));
        return ret;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String text) {
        this.scriptText = text;
    }

    public boolean hasConnectors() {
        return true;
    }
}

