/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationElement;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.CustomIntegrationPropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class ScriptedCustomIntegrationInformationProvider
extends CustomIntegrationInformationProvider {
    String typeId;
    String typeName;
    boolean acceptsConnectors = false;
    List connectorRecords = new ArrayList();
    List panelRecords = new ArrayList();
    List actionClasses = new ArrayList();
    List variables = new ArrayList();
    boolean canDelete = true;
    boolean hasConnectors = false;

    public ScriptedCustomIntegrationInformationProvider(CustomIntegrationElement element) {
        super(element);
    }

    public void init(IConfigurationElement configurationElement) {
        this.acceptsConnectors = Boolean.parseBoolean(configurationElement.getAttribute("acceptsConnectors"));
        if (configurationElement.getAttribute("canDelete") != null) {
            this.canDelete = Boolean.parseBoolean(configurationElement.getAttribute("canDelete"));
        }
        this.typeId = configurationElement.getAttribute("typeid");
        this.typeName = configurationElement.getAttribute("typename");
        IConfigurationElement exitPointsElement = configurationElement.getChildren("exit_points")[0];
        IConfigurationElement[] exitPointElements = exitPointsElement.getChildren("exit_point");
        int i = 0;
        while (i < exitPointElements.length) {
            ConnectorRecord cr = new ConnectorRecord((org.eclipse.vtp.desktop.model.core.Element)this.getElement(), exitPointElements[i].getAttribute("name"), Integer.parseInt(exitPointElements[i].getAttribute("type")));
            this.connectorRecords.add(cr);
            this.hasConnectors = true;
            ++i;
        }
        IConfigurationElement propertyPanelsElement = configurationElement.getChildren("property-panels")[0];
        IConfigurationElement[] propertyPanelElements = propertyPanelsElement.getChildren("property-panel");
        int i2 = 0;
        while (i2 < propertyPanelElements.length) {
            String panelName = propertyPanelElements[i2].getAttribute("name");
            String panelClassName = propertyPanelElements[i2].getAttribute("class");
            try {
                Bundle contributor = Platform.getBundle((String)propertyPanelElements[i2].getContributor().getName());
                Class panelClass = contributor.loadClass(panelClassName);
                this.addPropertiesPanel(panelName, panelClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        IConfigurationElement actionsElement = configurationElement.getChildren("variables")[0];
        IConfigurationElement[] actionElements = actionsElement.getChildren("variable");
        int i3 = 0;
        while (i3 < actionElements.length) {
            String variableName = actionElements[i3].getAttribute("name");
            String variableType = actionElements[i3].getAttribute("type");
            boolean variableIsArray = "true".equalsIgnoreCase(actionElements[i3].getAttribute("array"));
            this.addVariable(variableName, variableType, variableIsArray);
            ++i3;
        }
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return this.connectorRecords;
    }

    public List getConnectorRecords(int type) {
        if ((type & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Connector type must be one of those defined in the class ConnectorRecord.");
        }
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) != 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(Element configuration) {
    }

    public void writeConfiguration(Element configuration) {
    }

    public boolean acceptConnector(org.eclipse.vtp.desktop.model.core.Element origin) {
        return this.acceptsConnectors;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void addPropertiesPanel(String name, Class panelClass) {
        PanelRecord pr = new PanelRecord(name, panelClass);
        this.panelRecords.add(pr);
    }

    public List getPropertiesPanels() {
        ArrayList<CustomIntegrationPropertiesPanel> ret = new ArrayList<CustomIntegrationPropertiesPanel>();
        Iterator i = this.panelRecords.iterator();
        while (i.hasNext()) {
            try {
                PanelRecord pr = (PanelRecord)i.next();
                Constructor con = pr.panelClass.getConstructor(String.class, CustomIntegrationElement.class);
                CustomIntegrationPropertiesPanel ppp = (CustomIntegrationPropertiesPanel)((Object)con.newInstance(new Object[]{pr.panelName, this.getElement()}));
                ret.add(ppp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List getActions(CommandListener commandListener) {
        ArrayList ret = new ArrayList();
        for (Class actionClass : this.actionClasses) {
            try {
                Constructor con = actionClass.getConstructor(PrimitiveElement.class, CommandListener.class);
                ret.add(con.newInstance(new Object[]{this.getElement(), commandListener}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public void addVariable(String name, String type, boolean array) {
        this.variables.add(new ExportedVariable(name, type, array));
    }

    public List getOutgoingVariables(String exitPoint) {
        ArrayList<Variable> exports = new ArrayList<Variable>();
        int i = 0;
        while (i < this.variables.size()) {
            ExportedVariable vd = (ExportedVariable)this.variables.get(i);
            FieldType ft = FieldType.custom((String)vd.type, (this.isObject(vd.type) && !vd.array ? 1 : 0) != 0, (boolean)vd.array, (int)0);
            Variable v = new Variable(vd.name, ft);
            this.buildObjectFields((ObjectDefinition)v);
            exports.add(v);
            ++i;
        }
        return exports;
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IVoiceToolsDesignProject)this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields((ObjectDefinition)def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    private class ExportedVariable {
        String name;
        String type;
        boolean array = false;

        public ExportedVariable(String name, String type, boolean array) {
            this.name = name;
            this.type = type;
            this.array = array;
        }
    }

    public class PanelRecord {
        Class panelClass;
        String panelName;

        public PanelRecord(String name, Class panelClass) {
            this.panelName = name;
            this.panelClass = panelClass;
        }
    }
}

