/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.osgi.framework.Bundle;

public class ScriptedPrimitiveInformationProvider
extends PrimitiveInformationProvider {
    String typeId;
    String typeName;
    boolean acceptsConnectors = false;
    List connectorRecords = new ArrayList();
    List panelRecords = new ArrayList();
    List actionClasses = new ArrayList();
    boolean canDelete = true;
    boolean hasConnectors = false;

    public ScriptedPrimitiveInformationProvider(PrimitiveElement element) {
        super(element);
    }

    public void init(IConfigurationElement configurationElement) {
        this.acceptsConnectors = Boolean.parseBoolean(configurationElement.getAttribute("acceptsConnectors"));
        if (configurationElement.getAttribute("canDelete") != null) {
            this.canDelete = Boolean.parseBoolean(configurationElement.getAttribute("canDelete"));
        }
        this.typeId = configurationElement.getAttribute("typeid");
        this.typeName = configurationElement.getAttribute("typename");
        IConfigurationElement exitPointsElement = configurationElement.getChildren("exit_points")[0];
        IConfigurationElement[] exitPointElements = exitPointsElement.getChildren("exit_point");
        int i = 0;
        while (i < exitPointElements.length) {
            ConnectorRecord cr = new ConnectorRecord((Element)this.getElement(), exitPointElements[i].getAttribute("name"), Integer.parseInt(exitPointElements[i].getAttribute("type")));
            this.connectorRecords.add(cr);
            this.hasConnectors = true;
            ++i;
        }
        IConfigurationElement propertyPanelsElement = configurationElement.getChildren("property-panels")[0];
        IConfigurationElement[] propertyPanelElements = propertyPanelsElement.getChildren("property-panel");
        int i2 = 0;
        while (i2 < propertyPanelElements.length) {
            String panelName = propertyPanelElements[i2].getAttribute("name");
            String panelClassName = propertyPanelElements[i2].getAttribute("class");
            try {
                Bundle contributor = Platform.getBundle((String)propertyPanelElements[i2].getContributor().getName());
                Class panelClass = contributor.loadClass(panelClassName);
                this.addPropertiesPanel(panelName, panelClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        IConfigurationElement actionsElement = configurationElement.getChildren("actions")[0];
        IConfigurationElement[] actionElements = actionsElement.getChildren("action");
        int i3 = 0;
        while (i3 < actionElements.length) {
            String panelClassName = actionElements[i3].getAttribute("class");
            try {
                Bundle contributor = Platform.getBundle((String)actionElements[i3].getContributor().getName());
                Class panelClass = contributor.loadClass(panelClassName);
                this.actionClasses.add(panelClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i3;
        }
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return this.connectorRecords;
    }

    public List getConnectorRecords(int type) {
        if ((type & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Connector type must be one of those defined in the class ConnectorRecord.");
        }
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) != 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
    }

    public boolean acceptConnector(Element origin) {
        return this.acceptsConnectors;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void addPropertiesPanel(String name, Class panelClass) {
        PanelRecord pr = new PanelRecord(name, panelClass);
        this.panelRecords.add(pr);
    }

    public List getPropertiesPanels() {
        ArrayList<PrimitivePropertiesPanel> ret = new ArrayList<PrimitivePropertiesPanel>();
        Iterator i = this.panelRecords.iterator();
        while (i.hasNext()) {
            try {
                PanelRecord pr = (PanelRecord)i.next();
                Constructor con = pr.panelClass.getConstructor(String.class, PrimitiveElement.class);
                PrimitivePropertiesPanel ppp = (PrimitivePropertiesPanel)((Object)con.newInstance(new Object[]{pr.panelName, this.getElement()}));
                ret.add(ppp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List getActions(CommandListener commandListener) {
        ArrayList ret = new ArrayList();
        for (Class actionClass : this.actionClasses) {
            try {
                Constructor con = actionClass.getConstructor(PrimitiveElement.class, CommandListener.class);
                ret.add(con.newInstance(new Object[]{this.getElement(), commandListener}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public boolean hasConnectors() {
        return this.hasConnectors;
    }

    public class PanelRecord {
        Class panelClass;
        String panelName;

        public PanelRecord(String name, Class panelClass) {
            this.panelName = name;
            this.panelClass = panelClass;
        }
    }
}

