/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.SubdialogPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.NodeList;

public class SubdialogInformationProvider
extends PrimitiveInformationProvider {
    List incomingConnectors;
    List connectorRecords = new ArrayList();
    private List listeners = new ArrayList();
    private List inputs = new ArrayList();
    private List outputs = new ArrayList();
    private String url = "";

    public SubdialogInformationProvider(PrimitiveElement element) {
        super(element);
        this.incomingConnectors = new ArrayList();
        this.connectorRecords.add(new ConnectorRecord((Element)element, "Continue", ConnectorRecord.EXIT_POINT));
        this.connectorRecords.add(new ConnectorRecord((Element)element, "error.subdialog", ConnectorRecord.ERROR_POINT));
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
    }

    public ConnectorRecord getConnectorRecord(String recordName) {
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if (cr.getName().equals(recordName)) {
                return cr;
            }
            ++i;
        }
        return null;
    }

    public List getConnectorRecords() {
        return Collections.unmodifiableList(this.connectorRecords);
    }

    public List getConnectorRecords(int type) {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        int i = 0;
        while (i < this.connectorRecords.size()) {
            ConnectorRecord cr = (ConnectorRecord)this.connectorRecords.get(i);
            if ((cr.getType() & type) > 0) {
                ret.add(cr);
            }
            ++i;
        }
        return ret;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        configuration.setAttribute("url", XMLUtilities.encodeAttribute((String)this.url));
        org.w3c.dom.Element inputsElement = configuration.getOwnerDocument().createElement("inputs");
        configuration.appendChild(inputsElement);
        int i = 0;
        while (i < this.inputs.size()) {
            SubdialogInput si = (SubdialogInput)this.inputs.get(i);
            org.w3c.dom.Element inputElement = configuration.getOwnerDocument().createElement("input");
            inputsElement.appendChild(inputElement);
            inputElement.setAttribute("name", si.name);
            inputElement.setAttribute("type", Integer.toString(si.type));
            inputElement.setAttribute("value", si.value);
            ++i;
        }
        org.w3c.dom.Element outputsElement = configuration.getOwnerDocument().createElement("outputs");
        configuration.appendChild(outputsElement);
        int i2 = 0;
        while (i2 < this.outputs.size()) {
            SubdialogOutput so = (SubdialogOutput)this.outputs.get(i2);
            org.w3c.dom.Element outputElement = configuration.getOwnerDocument().createElement("output");
            outputsElement.appendChild(outputElement);
            outputElement.setAttribute("name", so.varName);
            outputElement.setAttribute("value", so.valueName);
            ++i2;
        }
    }

    public void readConfiguration(org.w3c.dom.Element configuration) {
        int i;
        this.url = configuration.getAttribute("url");
        NodeList nl = configuration.getElementsByTagName("inputs");
        if (nl.getLength() > 0) {
            org.w3c.dom.Element inputsElement = (org.w3c.dom.Element)nl.item(0);
            nl = inputsElement.getElementsByTagName("input");
            i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Element inputElement = (org.w3c.dom.Element)nl.item(i);
                String inputName = inputElement.getAttribute("name");
                int inputType = Integer.parseInt(inputElement.getAttribute("type"));
                String inputValue = inputElement.getAttribute("value");
                this.inputs.add(new SubdialogInput(inputName, inputType, inputValue));
                ++i;
            }
        }
        if ((nl = configuration.getElementsByTagName("outputs")).getLength() > 0) {
            org.w3c.dom.Element outputsElement = (org.w3c.dom.Element)nl.item(0);
            nl = outputsElement.getElementsByTagName("output");
            i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Element outputElement = (org.w3c.dom.Element)nl.item(i);
                String varName = outputElement.getAttribute("name");
                String valueName = outputElement.getAttribute("value");
                this.outputs.add(new SubdialogOutput(varName, valueName));
                ++i;
            }
        }
    }

    public List getInputs() {
        return this.inputs;
    }

    public void setInputs(List inputs) {
        this.inputs = inputs;
    }

    public List getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List outputs) {
        this.outputs = outputs;
    }

    public List getPropertiesPanels() {
        ArrayList<SubdialogPropertiesPanel> ret = new ArrayList<SubdialogPropertiesPanel>();
        ret.add(new SubdialogPropertiesPanel("General", this.getElement()));
        return ret;
    }

    public boolean acceptConnector(Element origin) {
        return true;
    }

    public boolean hasConnectors() {
        return true;
    }

    public class SubdialogInput {
        public String name = "";
        public int type = 0;
        public String value = "";

        public SubdialogInput(String name, int type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }
    }

    public class SubdialogOutput {
        public String varName = "";
        public String valueName = "";

        public SubdialogOutput(String varName, String valueName) {
            this.varName = varName;
            this.valueName = valueName;
        }
    }
}

