/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.VariableAssignmentInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.VariableDeclaration;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;

public class AssignmentVariablesPropertyPanel
extends PrimitivePropertiesPanel {
    List declarations;
    List variables;
    TableViewer variableViewer;
    Button addButton;
    Button removeButton;
    TextCellEditor valueEditor;
    FormToolkit toolkit = null;
    Text nameField = null;

    public AssignmentVariablesPropertyPanel(String name, PrimitiveElement element) {
        super(name, element);
        this.declarations = ((VariableAssignmentInformationProvider)element.getInformationProvider()).getDeclarations();
        this.variables = new ArrayList(this.getElement().getOutgoingVariables("Continue"));
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.toolkit = new FormToolkit(parent.getDisplay());
        Section generalSection = this.toolkit.createSection(parent, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        generalSection.setLayoutData((Object)gridData);
        generalSection.setText("General");
        System.out.println("General section expanded: " + generalSection.isExpanded());
        Composite generalComp = new Composite((Composite)generalSection, 0);
        generalComp.setBackground(parent.getBackground());
        generalComp.setLayout((Layout)new GridLayout(2, false));
        generalSection.setClient((Control)generalComp);
        Label nameLabel = new Label(generalComp, 0);
        nameLabel.setText("Name: ");
        nameLabel.setBackground(generalComp.getBackground());
        nameLabel.setLayoutData((Object)new GridData(4));
        this.nameField = new Text(generalComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(772));
        Section contentSection = this.toolkit.createSection(parent, 256);
        gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("Variable Assignments");
        Table variableTable = new Table(parent, 67588);
        variableTable.setHeaderVisible(true);
        TableColumn newColumn = new TableColumn(variableTable, 0);
        newColumn.setText("New");
        newColumn.setWidth(15);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(variableTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        GridData gd = new GridData(1040);
        gd.verticalSpan = 2;
        gd.widthHint = 520;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.valueEditor = new TextCellEditor((Composite)variableTable);
        this.variableViewer = new TableViewer(variableTable);
        this.variableViewer.setColumnProperties(new String[]{"New", "Name", "Type", "Value"});
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[3] = this.valueEditor;
        this.variableViewer.setCellEditors(cellEditorArray);
        this.variableViewer.setCellModifier((ICellModifier)new ValueCellModifier());
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        this.variableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Variable v1 = (Variable)e1;
                Variable v2 = (Variable)e2;
                return v1.getName().compareTo(v2.getName());
            }
        });
        this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AssignmentVariablesPropertyPanel.this.variableViewer.getSelection().isEmpty()) {
                    AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(false);
                    return;
                }
                HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    vdm.put(vd.getName(), vd);
                    ++i;
                }
                Variable v = (Variable)((IStructuredSelection)AssignmentVariablesPropertyPanel.this.variableViewer.getSelection()).getFirstElement();
                AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(vdm.get(v.getName()) != null);
            }
        });
        this.addButton = new Button(parent, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(770));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    NewVariableDialog nvd = new NewVariableDialog(AssignmentVariablesPropertyPanel.this.addButton.getShell());
                    if (nvd.open() == 32) {
                        AssignmentVariablesPropertyPanel.this.declarations.add(new VariableDeclaration(nvd.name, nvd.multiplicity, nvd.type, 0, null));
                        FieldType ft = FieldType.custom((String)nvd.type, (((VariableAssignmentInformationProvider)AssignmentVariablesPropertyPanel.this.getElement().getInformationProvider()).isObject(nvd.type) && nvd.multiplicity != 1 ? 1 : 0) != 0, (nvd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                        Variable v = new Variable(nvd.name, ft);
                        ((VariableAssignmentInformationProvider)AssignmentVariablesPropertyPanel.this.getElement().getInformationProvider()).buildObjectFields((ObjectDefinition)v);
                        AssignmentVariablesPropertyPanel.this.variables.add(v);
                        AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("Clear");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(2));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Variable v = (Variable)((IStructuredSelection)AssignmentVariablesPropertyPanel.this.variableViewer.getSelection()).getFirstElement();
                VariableDeclaration vd = null;
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    if (vd.getName().equals(v.getName())) break;
                    vd = null;
                    ++i;
                }
                if (vd != null) {
                    AssignmentVariablesPropertyPanel.this.declarations.remove(vd);
                    AssignmentVariablesPropertyPanel.this.variables = new ArrayList(AssignmentVariablesPropertyPanel.this.getElement().getOutgoingVariables("Continue"));
                    HashMap<String, Variable> vdm = new HashMap<String, Variable>();
                    int i2 = 0;
                    while (i2 < AssignmentVariablesPropertyPanel.this.variables.size()) {
                        Variable va = (Variable)AssignmentVariablesPropertyPanel.this.variables.get(i2);
                        vdm.put(va.getName(), va);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                        VariableDeclaration nvd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i2);
                        if (vdm.get(nvd.getName()) == null) {
                            FieldType ft = FieldType.custom((String)nvd.getType(), (((VariableAssignmentInformationProvider)AssignmentVariablesPropertyPanel.this.getElement().getInformationProvider()).isObject(nvd.getType()) && nvd.getMultiplicity() != 1 ? 1 : 0) != 0, (nvd.getMultiplicity() == 1 ? 1 : 0) != 0, (int)0);
                            Variable vx = new Variable(nvd.getName(), ft);
                            ((VariableAssignmentInformationProvider)AssignmentVariablesPropertyPanel.this.getElement().getInformationProvider()).buildObjectFields((ObjectDefinition)vx);
                            AssignmentVariablesPropertyPanel.this.variables.add(vx);
                        }
                        ++i2;
                    }
                }
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        ((VariableAssignmentInformationProvider)this.getElement().getInformationProvider()).setDeclarations(this.declarations);
    }

    public void cancel() {
    }

    public class NewVariableDialog
    extends FramedDialog {
        Color darkBlue;
        Color lightBlue;
        Text nameField;
        Combo multiplicityCombo;
        Combo typeCombo;
        String name;
        int multiplicity;
        String type;

        public NewVariableDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("New Variable");
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 0x800000);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    NewVariableDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 0x800000);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    NewVariableDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void okPressed() {
            this.name = this.nameField.getText();
            this.multiplicity = this.multiplicityCombo.getSelectionIndex();
            this.type = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    NewVariableDialog.this.darkBlue.dispose();
                    NewVariableDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Name");
            nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            nameLabel.setLayoutData((Object)gd);
            this.nameField = new Text(parent, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.nameField.setLayoutData((Object)gd);
            this.nameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            Label typeLabel = new Label(parent, 0);
            typeLabel.setText("Type");
            typeLabel.setBackground(parent.getBackground());
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            typeLabel.setLayoutData((Object)gd);
            this.multiplicityCombo = new Combo(parent, 2060);
            this.multiplicityCombo.add("One Of");
            this.multiplicityCombo.add("Array Of");
            this.multiplicityCombo.select(0);
            this.multiplicityCombo.setLayoutData((Object)new GridData());
            this.typeCombo = new Combo(parent, 2060);
            this.typeCombo.add("String");
            this.typeCombo.add("Number");
            this.typeCombo.add("Decimal");
            this.typeCombo.add("Boolean");
            this.typeCombo.add("DateTime");
            ArrayList businessObjects = AssignmentVariablesPropertyPanel.this.getElement().getModel().getDataService("IApplicationProject") == null ? new ArrayList() : ((IVoiceToolsDesignProject)AssignmentVariablesPropertyPanel.this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < businessObjects.size()) {
                IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                this.typeCombo.add(ibo.getName());
                ++i;
            }
            this.typeCombo.select(0);
            this.typeCombo.setLayoutData((Object)new GridData(768));
        }
    }

    public class ValueCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            Variable vd;
            return property.equals("Value") && !(vd = (Variable)element).getType().isArray() && (vd.getType().getTypeName().equals("String") || vd.getType().getTypeName().equals("Number") || vd.getType().getTypeName().equals("Decimal") || vd.getType().getTypeName().equals("Boolean") || vd.getType().getTypeName().equals("DataTime"));
        }

        public Object getValue(Object element, String property) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.getName(), vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (property.equals("Value")) {
                return vdm.get(vd.getName()) == null ? "" : (((VariableDeclaration)vdm.get(vd.getName())).getValue() == null ? "" : ((VariableDeclaration)vdm.get(vd.getName())).getValue());
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object vd;
            HashMap<String, Object> vdm = new HashMap<String, Object>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(((VariableDeclaration)vd).getName(), vd);
                ++i;
            }
            TableItem ti = (TableItem)element;
            vd = (Variable)ti.getData();
            VariableDeclaration varDec = (VariableDeclaration)vdm.get(vd.getName());
            if (varDec == null) {
                varDec = new VariableDeclaration(vd.getName(), vd.getType().isArray() ? 1 : 0, vd.getType().getTypeName(), 0, null);
                AssignmentVariablesPropertyPanel.this.declarations.add(varDec);
            }
            if (property.equals("Value")) {
                varDec.setValueType(0);
                varDec.setValue((String)value);
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh(true);
            }
        }
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return AssignmentVariablesPropertyPanel.this.variables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.getName(), vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (columnIndex == 0) {
                if (vdm.get(vd.getName()) != null) {
                    return "*";
                }
                return "";
            }
            if (columnIndex == 1) {
                return vd.getName();
            }
            if (columnIndex == 2) {
                String ret = "";
                if (vd.getType().isArray()) {
                    ret = "Array Of ";
                }
                ret = String.valueOf(ret) + vd.getType().getTypeName();
                return ret;
            }
            if (columnIndex == 3) {
                System.out.println("3rd column");
                System.out.println(vd.getType().isArray());
                System.out.println(vd.getType().getTypeName());
                System.out.println(vdm.get(vd.getName()));
                if (!vd.getType().isArray() && (vd.getType().getTypeName().equals("String") || vd.getType().getTypeName().equals("Number") || vd.getType().getTypeName().equals("Decimal") || vd.getType().getTypeName().equals("Boolean") || vd.getType().getTypeName().equals("DataTime")) && vdm.get(vd.getName()) != null) {
                    return ((VariableDeclaration)vdm.get(vd.getName())).getValue();
                }
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

