/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.attacheddata.AttachedDataBinding;
import org.eclipse.vtp.desktop.core.configuration.attacheddata.AttachedDataBindingItem;
import org.eclipse.vtp.desktop.core.configuration.attacheddata.AttachedDataItemEntry;
import org.eclipse.vtp.desktop.core.configuration.attacheddata.AttachedDataManager;
import org.eclipse.vtp.desktop.editors.core.dialogs.AttachedDataEntryDialog;
import org.eclipse.vtp.desktop.editors.core.impl.ConnectorPropertiesListener;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;

public class AttachedDataPropertiesPanel
extends ComponentPropertiesPanel
implements ConnectorPropertiesListener {
    private Connector connector = null;
    private TreeViewer dataViewer = null;
    private Button addDataButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private AttachedDataManager attachedDataManager = null;
    private Brand currentBrand = null;
    private String interactionType = null;
    private String currentLanguage = null;
    private List currentExits = new ArrayList();

    public AttachedDataPropertiesPanel(Connector connector) {
        super("Attached Data");
        this.connector = connector;
        Element origin = connector.getOrigin();
        this.attachedDataManager = (AttachedDataManager)origin.getConfigurationManager("org.eclipse.vtp.configuration.attacheddata");
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(1, false));
        Tree dataTree = new Tree(comp, 68100);
        dataTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(dataTree, 0);
        nameColumn.setText("Name");
        nameColumn.setWidth(150);
        TreeColumn valueColumn = new TreeColumn(dataTree, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(150);
        this.dataViewer = new TreeViewer(dataTree);
        this.dataViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.dataViewer.setContentProvider((IContentProvider)new AttachedDataContentProvider());
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new AttachedDataLabelProvider());
        this.dataViewer.setInput((Object)this);
        this.setControl((Control)comp);
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AttachedDataPropertiesPanel.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
    }

    private void hookDoubleClickAction() {
        this.dataViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AttachedDataPropertiesPanel.this.dataViewer.getSelection();
                if (sel.getFirstElement() instanceof EntryRecord) {
                    EntryRecord entryRecord = (EntryRecord)sel.getFirstElement();
                    try {
                        Shell workbenchShell = Display.getCurrent().getActiveShell();
                        AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                        aded.setConnector(AttachedDataPropertiesPanel.this.connector, entryRecord.connectorRecord.getName());
                        aded.setEntry(entryRecord.entry);
                        if (aded.open() == 0) {
                            AttachedDataPropertiesPanel.this.dataViewer.refresh();
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        if (!this.dataViewer.getSelection().isEmpty()) {
            final IStructuredSelection sel = (IStructuredSelection)this.dataViewer.getSelection();
            if (sel.getFirstElement() instanceof ConnectorRecord) {
                manager.add((IAction)new Action("Add Attached Data"){

                    public void run() {
                        try {
                            ConnectorRecord cr = (ConnectorRecord)sel.getFirstElement();
                            Shell workbenchShell = Display.getCurrent().getActiveShell();
                            AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                            aded.setConnector(AttachedDataPropertiesPanel.this.connector, cr.getName());
                            if (aded.open() == 0) {
                                AttachedDataBinding dataBinding = AttachedDataPropertiesPanel.this.attachedDataManager.getAttachedDataBinding(cr.getName());
                                AttachedDataBindingItem item = dataBinding.getAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage);
                                item.addEntry(aded.getEntry());
                                dataBinding.putAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage, item);
                                AttachedDataPropertiesPanel.this.dataViewer.refresh();
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                final EntryRecord entryRecord = (EntryRecord)sel.getFirstElement();
                manager.add((IAction)new Action("Edit This"){

                    public void run() {
                        try {
                            Shell workbenchShell = Display.getCurrent().getActiveShell();
                            AttachedDataEntryDialog aded = new AttachedDataEntryDialog(workbenchShell);
                            aded.setConnector(AttachedDataPropertiesPanel.this.connector, entryRecord.connectorRecord.getName());
                            aded.setEntry(entryRecord.entry);
                            if (aded.open() == 0) {
                                AttachedDataPropertiesPanel.this.dataViewer.refresh();
                            }
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                });
                manager.add((IAction)new Action("Remove This"){

                    public void run() {
                        ConnectorRecord cr = entryRecord.connectorRecord;
                        AttachedDataBinding dataBinding = AttachedDataPropertiesPanel.this.attachedDataManager.getAttachedDataBinding(cr.getName());
                        AttachedDataBindingItem item = dataBinding.getAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage);
                        item.removeEntry(entryRecord.entry);
                        AttachedDataPropertiesPanel.this.dataViewer.refresh();
                    }
                });
            }
        }
    }

    public void save() {
        this.connector.getOrigin().commitConfigurationChanges((ConfigurationManager)this.attachedDataManager);
    }

    public void cancel() {
        this.connector.getOrigin().rollbackConfigurationChanges((ConfigurationManager)this.attachedDataManager);
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
        this.currentBrand = brand;
        this.interactionType = interactionType;
        this.currentLanguage = language;
        this.dataViewer.refresh();
    }

    public void exitPointSelectionChanged(List selection) {
        System.out.println("selection changed!!!!!!!!!!!!");
        this.currentExits = selection;
        if (this.dataViewer != null) {
            this.dataViewer.getTree().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AttachedDataPropertiesPanel.this.dataViewer.refresh();
                }
            });
        }
    }

    private class AttachedDataContentProvider
    implements ITreeContentProvider {
        private AttachedDataContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ConnectorRecord) {
                ConnectorRecord cr = (ConnectorRecord)parentElement;
                AttachedDataBinding dataBinding = AttachedDataPropertiesPanel.this.attachedDataManager.getAttachedDataBinding(cr.getName());
                AttachedDataBindingItem item = dataBinding.getAttachedDataItem(AttachedDataPropertiesPanel.this.currentBrand.getName(), AttachedDataPropertiesPanel.this.interactionType, AttachedDataPropertiesPanel.this.currentLanguage);
                List copy = item.getEntries();
                ArrayList<EntryRecord> ret = new ArrayList<EntryRecord>();
                ret.addAll(copy);
                System.out.println("# of entries: " + ret.size());
                int i = 0;
                while (i < ret.size()) {
                    AttachedDataItemEntry entry = (AttachedDataItemEntry)ret.get(i);
                    ret.set(i, new EntryRecord(cr, entry));
                    ++i;
                }
                return ret.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof EntryRecord) {
                return ((EntryRecord)element).connectorRecord;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ConnectorRecord;
        }

        public Object[] getElements(Object inputElement) {
            return AttachedDataPropertiesPanel.this.currentExits.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AttachedDataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AttachedDataLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof ConnectorRecord) {
                    return ((ConnectorRecord)element).getName();
                }
                return ((EntryRecord)element).entry.getName();
            }
            if (columnIndex == 1 && element instanceof EntryRecord) {
                return ((EntryRecord)element).entry.getValue();
            }
            return null;
        }
    }

    private class EntryRecord {
        ConnectorRecord connectorRecord;
        AttachedDataItemEntry entry;

        public EntryRecord(ConnectorRecord connectorRecord, AttachedDataItemEntry entry) {
            this.connectorRecord = connectorRecord;
            this.entry = entry;
        }
    }
}

