/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.ReturnInformationProvider;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentOutputMappingPanel
extends ComponentPropertiesPanel {
    private ApplicationFragmentElement element = null;
    private List<PrimitiveElement> returnElements = null;
    private Map<String, List<ApplicationFragmentElement.OutputMapping>> mappings = null;
    private TableViewer mappingViewer = null;
    private Combo exitCombo = null;
    private String[] vars = null;

    public FragmentOutputMappingPanel(ApplicationFragmentElement element, List<PrimitiveElement> returnElements, Map<String, List<ApplicationFragmentElement.OutputMapping>> mappings) {
        super("Output Mapping");
        this.element = element;
        this.returnElements = returnElements;
        this.mappings = new HashMap<String, List<ApplicationFragmentElement.OutputMapping>>();
        for (Map.Entry<String, List<ApplicationFragmentElement.OutputMapping>> entry : mappings.entrySet()) {
            ArrayList<ApplicationFragmentElement.OutputMapping> copy = new ArrayList<ApplicationFragmentElement.OutputMapping>();
            for (ApplicationFragmentElement.OutputMapping mapping : entry.getValue()) {
                ApplicationFragmentElement applicationFragmentElement = element;
                ((Object)((Object)applicationFragmentElement)).getClass();
                copy.add(applicationFragmentElement.new ApplicationFragmentElement.OutputMapping(mapping.getOutputName(), mapping.getTargetName()));
            }
            this.mappings.put(entry.getKey(), copy);
        }
        List inc = element.getIncomingVariables();
        ArrayList<String> varTemp = new ArrayList<String>();
        varTemp.add("Not Used");
        int i = 0;
        while (i < inc.size()) {
            Variable var = (Variable)inc.get(i);
            if (!var.getType().isArray() && !var.getType().isObject()) {
                varTemp.add(var.getName());
            }
            ++i;
        }
        this.vars = varTemp.toArray(new String[varTemp.size()]);
    }

    public void cancel() {
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label exitLabel = new Label(comp, 0);
        exitLabel.setText("Exit Point:");
        exitLabel.setLayoutData((Object)new GridData());
        this.exitCombo = new Combo(comp, 12);
        for (PrimitiveElement pe : this.returnElements) {
            this.exitCombo.add(pe.getName());
        }
        this.exitCombo.select(0);
        this.exitCombo.setLayoutData((Object)new GridData(768));
        Table mappingTable = new Table(comp, 2052);
        TableColumn outputColumn = new TableColumn(mappingTable, 0);
        outputColumn.setText("Fragment Variable");
        outputColumn.setWidth(150);
        TableColumn targetColumn = new TableColumn(mappingTable, 0);
        targetColumn.setText("Put into the variable");
        targetColumn.setWidth(200);
        mappingTable.setHeaderVisible(true);
        this.mappingViewer = new TableViewer(mappingTable);
        this.mappingViewer.setColumnProperties(new String[]{"Field", "Value"});
        this.mappingViewer.setCellModifier((ICellModifier)new MappingCellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new ComboBoxCellEditor((Composite)mappingTable, this.vars);
        this.mappingViewer.setCellEditors(cellEditorArray);
        this.mappingViewer.setContentProvider((IContentProvider)new MappingContentProvider());
        this.mappingViewer.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        this.mappingViewer.setInput((Object)this);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.mappingViewer.getTable().setLayoutData((Object)gd);
        this.exitCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FragmentOutputMappingPanel.this.mappingViewer.refresh();
            }
        });
    }

    public void save() {
        this.element.setOutputMappings(this.mappings);
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
    }

    public class MappingCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String colVal = "Not Used";
            String item = FragmentOutputMappingPanel.this.exitCombo.getItem(FragmentOutputMappingPanel.this.exitCombo.getSelectionIndex());
            List maps = (List)FragmentOutputMappingPanel.this.mappings.get(item);
            if (maps != null) {
                ApplicationFragmentElement.OutputMapping mapping = null;
                int i = 0;
                while (i < maps.size()) {
                    if (((ApplicationFragmentElement.OutputMapping)maps.get(i)).getOutputName().equals(element)) {
                        mapping = (ApplicationFragmentElement.OutputMapping)maps.get(i);
                        break;
                    }
                    ++i;
                }
                if (mapping != null) {
                    colVal = mapping.getTargetName();
                }
            }
            int i = 0;
            while (i < FragmentOutputMappingPanel.this.vars.length) {
                if (FragmentOutputMappingPanel.this.vars[i].equals(colVal)) {
                    return new Integer(i);
                }
                ++i;
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            String item = FragmentOutputMappingPanel.this.exitCombo.getItem(FragmentOutputMappingPanel.this.exitCombo.getSelectionIndex());
            ArrayList<ApplicationFragmentElement.OutputMapping> maps = (ArrayList<ApplicationFragmentElement.OutputMapping>)FragmentOutputMappingPanel.this.mappings.get(item);
            if (maps == null) {
                maps = new ArrayList<ApplicationFragmentElement.OutputMapping>();
                FragmentOutputMappingPanel.this.mappings.put(item, maps);
            }
            ApplicationFragmentElement.OutputMapping mapping = null;
            int i = 0;
            while (i < maps.size()) {
                if (((ApplicationFragmentElement.OutputMapping)maps.get(i)).getOutputName().equals(((TableItem)element).getData())) {
                    mapping = (ApplicationFragmentElement.OutputMapping)maps.get(i);
                    break;
                }
                ++i;
            }
            if (mapping == null) {
                ApplicationFragmentElement applicationFragmentElement = FragmentOutputMappingPanel.this.element;
                ((Object)((Object)applicationFragmentElement)).getClass();
                mapping = applicationFragmentElement.new ApplicationFragmentElement.OutputMapping((String)((TableItem)element).getData(), null);
                maps.add(mapping);
            }
            mapping.setTargetName(FragmentOutputMappingPanel.this.vars[(Integer)value]);
            FragmentOutputMappingPanel.this.mappingViewer.refresh();
        }
    }

    public class MappingContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            PrimitiveElement retElement = (PrimitiveElement)((Object)FragmentOutputMappingPanel.this.returnElements.get(FragmentOutputMappingPanel.this.exitCombo.getSelectionIndex()));
            List exports = ((ReturnInformationProvider)retElement.getInformationProvider()).getExports();
            return exports.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class MappingLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return (String)element;
            }
            if (columnIndex == 1) {
                String item = FragmentOutputMappingPanel.this.exitCombo.getItem(FragmentOutputMappingPanel.this.exitCombo.getSelectionIndex());
                List maps = (List)FragmentOutputMappingPanel.this.mappings.get(item);
                if (maps == null) {
                    return "Not Used";
                }
                ApplicationFragmentElement.OutputMapping mapping = null;
                int i = 0;
                while (i < maps.size()) {
                    if (((ApplicationFragmentElement.OutputMapping)maps.get(i)).getOutputName().equals(element)) {
                        mapping = (ApplicationFragmentElement.OutputMapping)maps.get(i);
                        break;
                    }
                    ++i;
                }
                return mapping == null ? "Not Used" : (mapping.getTargetName() == null ? "Not Used" : mapping.getTargetName());
            }
            return "Unknown";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

