/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentElement;
import org.eclipse.vtp.desktop.editors.core.elements.ApplicationFragmentVariableMapping;
import org.eclipse.vtp.desktop.editors.core.elements.BeginFragmentInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.VariableDeclaration;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;

public class FragmentVariableMappingPanel
extends ComponentPropertiesPanel {
    private ApplicationFragmentElement element;
    private TableViewer expectedVariableViewer = null;
    private Button noChangeButton = null;
    private Button staticButton = null;
    private Text staticText = null;
    private Button expressionButton = null;
    private Text expressionText = null;
    private Button appVariableButton = null;
    private TableViewer appVariableViewer = null;
    private Map mappingsByVariableName = new HashMap();
    List expectedVariables = null;
    List applicationVariables = null;

    public FragmentVariableMappingPanel(ApplicationFragmentElement element) {
        super("Variables");
        this.element = element;
        List fragElements = element.getFragmentModel().getUIModel().getModel().listElements();
        for (Element fragElement : fragElements) {
            PrimitiveElement primitive;
            if (!(fragElement instanceof PrimitiveElement) || !(primitive = (PrimitiveElement)fragElement).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.beginFragment")) continue;
            BeginFragmentInformationProvider bfip = (BeginFragmentInformationProvider)primitive.getInformationProvider();
            this.expectedVariables = bfip.getDeclarations();
            break;
        }
        HashMap<String, VariableDeclaration> variablesByName = new HashMap<String, VariableDeclaration>();
        for (VariableDeclaration vd : this.expectedVariables) {
            variablesByName.put(vd.getName(), vd);
        }
        List mappings = element.getVariableMappings();
        for (ApplicationFragmentVariableMapping mapping : mappings) {
            if (variablesByName.get(mapping.getFragmentVariableName()) == null) continue;
            this.mappingsByVariableName.put(mapping.getFragmentVariableName(), mapping);
        }
        this.applicationVariables = element.getIncomingVariables();
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(2, false));
        Table expectedVariableTable = new Table(comp, 68100);
        expectedVariableTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(expectedVariableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(expectedVariableTable, 0);
        typeColumn.setText("Variable Type");
        typeColumn.setWidth(150);
        this.expectedVariableViewer = new TableViewer(expectedVariableTable);
        this.expectedVariableViewer.setContentProvider((IContentProvider)new ExpectedVariableContentProvider());
        this.expectedVariableViewer.setLabelProvider((IBaseLabelProvider)new ExpectedVariableLabelProvider());
        this.expectedVariableViewer.setInput((Object)this);
        GridData gd = new GridData(1040);
        expectedVariableTable.setLayoutData((Object)gd);
        this.expectedVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                block10: {
                    try {
                        StructuredSelection selection = (StructuredSelection)event.getSelection();
                        if (selection.isEmpty()) break block10;
                        VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                        ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                        if (mapping == null) {
                            mapping = new ApplicationFragmentVariableMapping(vd.getName(), 0, "");
                            FragmentVariableMappingPanel.this.mappingsByVariableName.put(vd.getName(), mapping);
                        }
                        System.out.println("mapping: name=" + mapping.getFragmentVariableName() + " type=" + mapping.getMappingType() + " value=" + mapping.getMappingValue());
                        FragmentVariableMappingPanel.this.noChangeButton.setSelection(false);
                        FragmentVariableMappingPanel.this.staticButton.setSelection(false);
                        FragmentVariableMappingPanel.this.expressionButton.setSelection(false);
                        FragmentVariableMappingPanel.this.appVariableButton.setSelection(false);
                        switch (mapping.getMappingType()) {
                            case 0: {
                                FragmentVariableMappingPanel.this.noChangeButton.setSelection(true);
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                break;
                            }
                            case 1: {
                                FragmentVariableMappingPanel.this.staticButton.setSelection(true);
                                FragmentVariableMappingPanel.this.staticText.setText(mapping.getMappingValue());
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                break;
                            }
                            case 2: {
                                FragmentVariableMappingPanel.this.expressionButton.setSelection(true);
                                FragmentVariableMappingPanel.this.expressionText.setText(mapping.getMappingValue());
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                                break;
                            }
                            case 3: {
                                FragmentVariableMappingPanel.this.appVariableButton.setSelection(true);
                                for (Variable v : FragmentVariableMappingPanel.this.applicationVariables) {
                                    if (!v.getName().equals(mapping.getMappingValue())) continue;
                                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                                }
                                FragmentVariableMappingPanel.this.staticText.setText("");
                                FragmentVariableMappingPanel.this.expressionText.setText("");
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown mapping type found.");
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        Composite mappingComposite = new Composite(comp, 0);
        gd = new GridData(1040);
        mappingComposite.setLayoutData((Object)gd);
        mappingComposite.setBackground(comp.getBackground());
        mappingComposite.setLayout((Layout)new GridLayout(1, false));
        this.noChangeButton = new Button(mappingComposite, 16);
        this.noChangeButton.setBackground(mappingComposite.getBackground());
        this.noChangeButton.setText("Do not change this variable");
        gd = new GridData(768);
        this.noChangeButton.setLayoutData((Object)gd);
        this.noChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                System.out.println("no change button selected");
                if (FragmentVariableMappingPanel.this.noChangeButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    mapping.setMappingType(0);
                    mapping.setMappingValue("");
                }
            }
        });
        this.staticButton = new Button(mappingComposite, 16);
        this.staticButton.setBackground(mappingComposite.getBackground());
        this.staticButton.setText("Use this value");
        gd = new GridData(768);
        this.staticButton.setLayoutData((Object)gd);
        this.staticButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.staticButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    mapping.setMappingType(1);
                    mapping.setMappingValue("");
                }
            }
        });
        this.staticText = new Text(mappingComposite, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.staticText.setLayoutData((Object)gd);
        this.staticText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    if (mapping.getMappingType() == 1) {
                        mapping.setMappingValue(FragmentVariableMappingPanel.this.staticText.getText());
                    }
                }
            }
        });
        this.expressionButton = new Button(mappingComposite, 16);
        this.expressionButton.setBackground(mappingComposite.getBackground());
        this.expressionButton.setText("Use this Javascript expression");
        gd = new GridData(768);
        this.expressionButton.setLayoutData((Object)gd);
        this.expressionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.expressionButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    mapping.setMappingType(2);
                    mapping.setMappingValue("");
                }
            }
        });
        this.expressionText = new Text(mappingComposite, 2052);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    if (mapping.getMappingType() == 2) {
                        mapping.setMappingValue(FragmentVariableMappingPanel.this.expressionText.getText());
                    }
                }
            }
        });
        this.appVariableButton = new Button(mappingComposite, 16);
        this.appVariableButton.setBackground(mappingComposite.getBackground());
        this.appVariableButton.setText("Use this application variable");
        gd = new GridData(768);
        this.appVariableButton.setLayoutData((Object)gd);
        this.appVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection;
                if (FragmentVariableMappingPanel.this.appVariableButton.getSelection() && !(selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection()).isEmpty()) {
                    FragmentVariableMappingPanel.this.staticText.setText("");
                    FragmentVariableMappingPanel.this.expressionText.setText("");
                    FragmentVariableMappingPanel.this.appVariableViewer.setSelection(null);
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    mapping.setMappingType(3);
                    mapping.setMappingValue("");
                }
            }
        });
        Table appVariableTable = new Table(mappingComposite, 68100);
        appVariableTable.setHeaderVisible(true);
        TableColumn appVariableNameColumn = new TableColumn(appVariableTable, 0);
        appVariableNameColumn.setText("Variable Name");
        appVariableNameColumn.setWidth(150);
        TableColumn appVariableTypeColumn = new TableColumn(appVariableTable, 0);
        appVariableTypeColumn.setText("Variable Type");
        appVariableTypeColumn.setWidth(150);
        this.appVariableViewer = new TableViewer(appVariableTable);
        this.appVariableViewer.setContentProvider((IContentProvider)new ApplicationVariableContentProvider());
        this.appVariableViewer.setLabelProvider((IBaseLabelProvider)new ApplicationVariableLabelProvider());
        this.appVariableViewer.setInput((Object)this);
        gd = new GridData(768);
        gd.horizontalIndent = 15;
        this.appVariableViewer.getControl().setLayoutData((Object)gd);
        this.appVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)FragmentVariableMappingPanel.this.expectedVariableViewer.getSelection();
                if (!selection.isEmpty()) {
                    VariableDeclaration vd = (VariableDeclaration)selection.getFirstElement();
                    ApplicationFragmentVariableMapping mapping = (ApplicationFragmentVariableMapping)FragmentVariableMappingPanel.this.mappingsByVariableName.get(vd.getName());
                    if (mapping.getMappingType() == 3) {
                        StructuredSelection appSel = (StructuredSelection)event.getSelection();
                        if (appSel.isEmpty()) {
                            mapping.setMappingValue("");
                        } else {
                            mapping.setMappingValue(((Variable)appSel.getFirstElement()).getName());
                        }
                    }
                }
            }
        });
        this.setControl((Control)comp);
        this.expectedVariableViewer.setSelection((ISelection)(this.expectedVariables.size() < 1 ? StructuredSelection.EMPTY : new StructuredSelection(this.expectedVariables.get(0))));
    }

    public void save() {
        ArrayList<ApplicationFragmentVariableMapping> mappings = new ArrayList<ApplicationFragmentVariableMapping>(this.mappingsByVariableName.size());
        for (ApplicationFragmentVariableMapping mapping : this.mappingsByVariableName.values()) {
            mappings.add(mapping);
        }
        this.element.setVariableMappings(mappings);
    }

    public void cancel() {
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
    }

    private class ApplicationVariableContentProvider
    implements IStructuredContentProvider {
        private ApplicationVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FragmentVariableMappingPanel.this.applicationVariables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ApplicationVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ApplicationVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Variable v = (Variable)element;
            if (columnIndex == 0) {
                return v.getName();
            }
            if (columnIndex == 1) {
                StringBuffer buf = new StringBuffer();
                if (v.getType().isArray()) {
                    buf.append("Array of ");
                }
                buf.append(v.getType().getTypeName());
                return buf.toString();
            }
            return "Unknown Column";
        }
    }

    private class ExpectedVariableContentProvider
    implements IStructuredContentProvider {
        private ExpectedVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FragmentVariableMappingPanel.this.expectedVariables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ExpectedVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ExpectedVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            VariableDeclaration vd = (VariableDeclaration)element;
            if (columnIndex == 0) {
                return vd.getName();
            }
            if (columnIndex == 1) {
                StringBuffer buf = new StringBuffer();
                if (vd.getMultiplicity() == 1) {
                    buf.append("Array of ");
                }
                buf.append(vd.getType());
                return buf.toString();
            }
            return "Unknown Column";
        }
    }
}

