/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBindingManager;
import org.eclipse.vtp.desktop.editors.core.elements.PortalEntryInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.model.core.Element;

public class PortalEntryPropertiesPanel
extends PrimitivePropertiesPanel {
    Combo exitCombo = null;
    MediaBindingManager bindingManager = null;
    List exits = new ArrayList();
    PortalEntryInformationProvider info;

    public PortalEntryPropertiesPanel(String name, PrimitiveElement element) {
        super(name, element);
        this.bindingManager = (MediaBindingManager)element.getConfigurationManager("org.eclipse.vtp.configuration.media");
        this.info = (PortalEntryInformationProvider)element.getInformationProvider();
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout();
        comp.setLayout((Layout)gridLayout);
        Label exitLabel = new Label(comp, 0);
        exitLabel.setText("Please select the Portal exit for this entry element.");
        exitLabel.setBackground(comp.getBackground());
        exitLabel.setLayoutData((Object)new GridData());
        this.exitCombo = new Combo(comp, 12);
        List elements = this.getElement().getModel().listElements();
        for (Element element : elements) {
            PrimitiveElement primitiveElement;
            if (!(element instanceof PrimitiveElement) || !(primitiveElement = (PrimitiveElement)element).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.portalExit")) continue;
            this.exits.add(primitiveElement);
            this.exitCombo.add(primitiveElement.getName());
        }
        if (this.info.getExitId() != null) {
            int i = 0;
            while (i < this.exits.size()) {
                Element element;
                element = (PrimitiveElement)((Object)this.exits.get(i));
                if (element.getId().equals(this.info.getExitId())) {
                    this.exitCombo.select(i);
                }
                ++i;
            }
        } else {
            this.exitCombo.select(0);
        }
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        this.exitCombo.setLayoutData((Object)gridData);
    }

    public void save() {
        PrimitiveElement primitiveElement = (PrimitiveElement)((Object)this.exits.get(this.exitCombo.getSelectionIndex()));
        this.info.setExitId(primitiveElement.getId());
        this.getElement().setName(primitiveElement.getName());
        this.getElement().commitConfigurationChanges((ConfigurationManager)this.bindingManager);
    }

    public void cancel() {
        this.getElement().rollbackConfigurationChanges((ConfigurationManager)this.bindingManager);
    }
}

