/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.RecordInformationProvider;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreenManager;
import org.eclipse.vtp.desktop.model.core.Element;

public class RecordCombinedMediaPropertiesPanel
extends PrimitivePropertiesPanel {
    StackLayout stackLayout = null;
    Map screensByType;
    Composite comp = null;
    FormToolkit toolkit = null;
    Text nameField = null;
    Text variableField = null;

    public RecordCombinedMediaPropertiesPanel(PrimitiveElement element) {
        super("Media & Settings", element);
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(element.getTypeId(), (Element)element);
    }

    public RecordCombinedMediaPropertiesPanel(String name, PrimitiveElement element) {
        super(name, element);
        this.screensByType = MediaConfigurationScreenManager.getInstance().getIndexedMediaConfigurationScreens(element.getTypeId(), (Element)element);
    }

    public void createControls(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setBackground(parent.getBackground());
        mainComp.setLayout((Layout)new GridLayout(2, false));
        this.toolkit = new FormToolkit(parent.getDisplay());
        Section contentSection = this.toolkit.createSection(mainComp, 256);
        GridData gridData = new GridData(770);
        gridData.horizontalSpan = 2;
        contentSection.setLayoutData((Object)gridData);
        contentSection.setText("General");
        Label nameLabel = new Label(mainComp, 0);
        nameLabel.setBackground(mainComp.getBackground());
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(mainComp, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        Label exitTypeLabel = new Label(mainComp, 0);
        exitTypeLabel.setBackground(mainComp.getBackground());
        exitTypeLabel.setText("Variable Name:");
        exitTypeLabel.setLayoutData((Object)new GridData());
        this.variableField = new Text(mainComp, 2052);
        this.variableField.setText(((RecordInformationProvider)this.getElement().getInformationProvider()).getVariableName());
        this.variableField.setLayoutData((Object)new GridData(768));
        this.comp = new Composite(mainComp, 0);
        this.comp.setBackground(parent.getBackground());
        gridData = new GridData(1808);
        gridData.verticalIndent = 20;
        gridData.horizontalSpan = 2;
        this.comp.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.comp.setLayout((Layout)this.stackLayout);
        Set s = this.screensByType.entrySet();
        for (Map.Entry entry : s) {
            MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
            mcs.createControls(this.comp);
            this.stackLayout.topControl = mcs.getControl();
        }
        this.setControl((Control)mainComp);
    }

    public void save() {
        try {
            this.getElement().setName(this.nameField.getText());
            ((RecordInformationProvider)this.getElement().getInformationProvider()).setVariableName(this.variableField.getText());
            Set s = this.screensByType.entrySet();
            for (Map.Entry entry : s) {
                MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
                mcs.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void cancel() {
        Set s = this.screensByType.entrySet();
        for (Map.Entry entry : s) {
            MediaConfigurationScreen mcs = (MediaConfigurationScreen)entry.getValue();
            mcs.cancel();
        }
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
        System.out.println("setting configuration" + brand.getName() + " " + interactionType + " " + language);
        MediaConfigurationScreen mcs = (MediaConfigurationScreen)this.screensByType.get(interactionType);
        if (mcs != null) {
            mcs.setBrand(brand);
            mcs.setLanguage(language);
            this.stackLayout.topControl = mcs.getControl();
            this.comp.layout(true, true);
        }
    }
}

