/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.ReturnInformationProvider;
import org.eclipse.vtp.desktop.model.core.Variable;

public class ReturnVariablesPropertyPanel
extends PrimitivePropertiesPanel {
    List exportedVars;
    CheckboxTableViewer variableViewer;

    public ReturnVariablesPropertyPanel(String name, PrimitiveElement element) {
        super(name, element);
        this.exportedVars = new ArrayList(((ReturnInformationProvider)element.getInformationProvider()).getExports());
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Table variableTable = new Table(parent, 67620);
        variableTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        GridData gd = new GridData(1040);
        gd.verticalSpan = 2;
        gd.widthHint = 505;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.variableViewer = new CheckboxTableViewer(variableTable);
        this.variableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                System.out.println("checkbox changed for: " + event.getElement());
                ReturnVariablesPropertyPanel.this.exportedVars.remove(((Variable)event.getElement()).getName());
                if (event.getChecked()) {
                    ReturnVariablesPropertyPanel.this.exportedVars.add(((Variable)event.getElement()).getName());
                }
            }
        });
        this.variableViewer.setColumnProperties(new String[]{"Name", "Type", "Value"});
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        for (Object obj : this.getElement().getIncomingVariables()) {
            Variable vd = (Variable)obj;
            System.out.println("setting checked for: " + vd + ", " + this.exportedVars.contains(vd.getName()));
            this.variableViewer.setChecked((Object)vd, this.exportedVars.contains(vd.getName()));
        }
    }

    public void save() {
        ((ReturnInformationProvider)this.getElement().getInformationProvider()).setExports(this.exportedVars);
    }

    public void cancel() {
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            ArrayList ret = new ArrayList();
            List incomingVariables = ReturnVariablesPropertyPanel.this.getElement().getIncomingVariables();
            int i = 0;
            while (i < incomingVariables.size()) {
                if (!((Variable)incomingVariables.get(i)).getType().isObject()) {
                    ret.add(incomingVariables.get(i));
                }
                ++i;
            }
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Variable vd = (Variable)element;
            if (columnIndex == 0) {
                return vd.getName();
            }
            if (columnIndex == 1) {
                String ret = "";
                if (vd.getType().isArray()) {
                    ret = "Array Of ";
                }
                ret = String.valueOf(ret) + vd.getType().getTypeName();
                return ret;
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

