/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.SubdialogInformationProvider;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;

public class SubdialogPropertiesPanel
extends PrimitivePropertiesPanel {
    List inputs = null;
    List outputs = null;
    Text nameField = null;
    Text urlField = null;
    TableViewer inputTable = null;
    TableViewer outputTable = null;

    public SubdialogPropertiesPanel(String name, PrimitiveElement subdialogElement) {
        super(name, subdialogElement);
        this.inputs = ((SubdialogInformationProvider)subdialogElement.getInformationProvider()).getInputs();
        this.outputs = ((SubdialogInformationProvider)subdialogElement.getInformationProvider()).getOutputs();
    }

    public void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name");
        nameLabel.setBackground(container.getBackground());
        nameLabel.setLayoutData((Object)new GridData());
        this.nameField = new Text(container, 2052);
        this.nameField.setText(this.getElement().getName());
        this.nameField.setLayoutData((Object)new GridData(768));
        Label urlLabel = new Label(container, 0);
        urlLabel.setText("URL");
        urlLabel.setBackground(container.getBackground());
        urlLabel.setLayoutData((Object)new GridData());
        this.urlField = new Text(container, 2052);
        this.urlField.setText(((SubdialogInformationProvider)this.getElement().getInformationProvider()).getURL());
        this.urlField.setLayoutData((Object)new GridData(768));
        Group inputsGroup = new Group(container, 0);
        inputsGroup.setBackground(container.getBackground());
        inputsGroup.setText("Inputs");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        inputsGroup.setLayoutData((Object)gd);
        inputsGroup.setLayout((Layout)new GridLayout(2, true));
        this.inputTable = new TableViewer((Composite)inputsGroup, 68100);
        this.inputTable.getTable().setHeaderVisible(true);
        this.inputTable.getTable().setLinesVisible(true);
        TableColumn inputNameColumn = new TableColumn(this.inputTable.getTable(), 0);
        inputNameColumn.setText("Name");
        inputNameColumn.setWidth(150);
        TableColumn inputValueColumn = new TableColumn(this.inputTable.getTable(), 0);
        inputValueColumn.setText("Value");
        inputValueColumn.setWidth(150);
        this.inputTable.setContentProvider((IContentProvider)new InputTableContentProvider());
        this.inputTable.setLabelProvider((IBaseLabelProvider)new InputTableLabelProvider());
        this.inputTable.setInput((Object)this);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 90;
        gd.widthHint = 300;
        this.inputTable.getTable().setLayoutData((Object)gd);
        this.inputTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SubdialogPropertiesPanel.this.inputTable.getSelection().isEmpty()) {
                    InputValueDialog vd = new InputValueDialog(Display.getCurrent().getActiveShell());
                    SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)((IStructuredSelection)SubdialogPropertiesPanel.this.inputTable.getSelection()).getFirstElement();
                    vd.setValue(si);
                    if (vd.open() == 32) {
                        SubdialogPropertiesPanel.this.inputTable.refresh();
                    }
                }
            }
        });
        Button addButton = new Button((Composite)inputsGroup, 0x800008);
        addButton.setText("Add Input");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Opening Value Dialog");
                System.out.println("# of inputs: " + SubdialogPropertiesPanel.this.inputs.size());
                InputValueDialog vd = new InputValueDialog(Display.getCurrent().getActiveShell());
                SubdialogInformationProvider subdialogInformationProvider = (SubdialogInformationProvider)SubdialogPropertiesPanel.this.getElement().getInformationProvider();
                subdialogInformationProvider.getClass();
                SubdialogInformationProvider.SubdialogInput si = subdialogInformationProvider.new SubdialogInformationProvider.SubdialogInput("", 0, "");
                vd.setValue(si);
                if (vd.open() == 32) {
                    SubdialogPropertiesPanel.this.inputs.add(si);
                    SubdialogPropertiesPanel.this.inputTable.refresh();
                }
            }
        });
        Button deleteButton = new Button((Composite)inputsGroup, 0x800008);
        deleteButton.setText("Delete Input");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!SubdialogPropertiesPanel.this.inputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)((IStructuredSelection)SubdialogPropertiesPanel.this.inputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.inputs.remove(si);
                    SubdialogPropertiesPanel.this.inputTable.refresh();
                }
            }
        });
        gd = new GridData();
        deleteButton.setLayoutData((Object)gd);
        Group outputsGroup = new Group(container, 0);
        outputsGroup.setBackground(container.getBackground());
        outputsGroup.setText("Outputs");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        outputsGroup.setLayoutData((Object)gd);
        outputsGroup.setLayout((Layout)new GridLayout(2, true));
        this.outputTable = new TableViewer((Composite)outputsGroup, 68100);
        this.outputTable.getTable().setHeaderVisible(true);
        this.outputTable.getTable().setLinesVisible(true);
        TableColumn outputNameColumn = new TableColumn(this.outputTable.getTable(), 0);
        outputNameColumn.setText("Name");
        outputNameColumn.setWidth(150);
        TableColumn outputValueColumn = new TableColumn(this.outputTable.getTable(), 0);
        outputValueColumn.setText("Value");
        outputValueColumn.setWidth(150);
        this.outputTable.setContentProvider((IContentProvider)new OutputTableContentProvider());
        this.outputTable.setLabelProvider((IBaseLabelProvider)new OutputTableLabelProvider());
        this.outputTable.setInput((Object)this);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 90;
        gd.widthHint = 300;
        this.outputTable.getTable().setLayoutData((Object)gd);
        this.outputTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!SubdialogPropertiesPanel.this.outputTable.getSelection().isEmpty()) {
                    OutputValueDialog vd = new OutputValueDialog(Display.getCurrent().getActiveShell());
                    SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)((IStructuredSelection)SubdialogPropertiesPanel.this.outputTable.getSelection()).getFirstElement();
                    vd.setValue(so);
                    if (vd.open() == 32) {
                        SubdialogPropertiesPanel.this.outputTable.refresh();
                    }
                }
            }
        });
        addButton = new Button((Composite)outputsGroup, 0x800008);
        addButton.setText("Add Ouput");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Opening Value Dialog");
                System.out.println("# of outputs: " + SubdialogPropertiesPanel.this.outputs.size());
                OutputValueDialog vd = new OutputValueDialog(Display.getCurrent().getActiveShell());
                SubdialogInformationProvider subdialogInformationProvider = (SubdialogInformationProvider)SubdialogPropertiesPanel.this.getElement().getInformationProvider();
                subdialogInformationProvider.getClass();
                SubdialogInformationProvider.SubdialogOutput so = subdialogInformationProvider.new SubdialogInformationProvider.SubdialogOutput("", "");
                vd.setValue(so);
                if (vd.open() == 32) {
                    SubdialogPropertiesPanel.this.outputs.add(so);
                    SubdialogPropertiesPanel.this.outputTable.refresh();
                }
            }
        });
        deleteButton = new Button((Composite)outputsGroup, 0x800008);
        deleteButton.setText("Delete Output");
        gd = new GridData();
        deleteButton.setLayoutData((Object)gd);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!SubdialogPropertiesPanel.this.outputTable.getSelection().isEmpty()) {
                    SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)((IStructuredSelection)SubdialogPropertiesPanel.this.outputTable.getSelection()).getFirstElement();
                    SubdialogPropertiesPanel.this.outputs.remove(so);
                    SubdialogPropertiesPanel.this.outputTable.refresh();
                }
            }
        });
    }

    public void save() {
        this.getElement().setName(this.nameField.getText());
        ((SubdialogInformationProvider)this.getElement().getInformationProvider()).setURL(this.urlField.getText());
        ((SubdialogInformationProvider)this.getElement().getInformationProvider()).setInputs(this.inputs);
        ((SubdialogInformationProvider)this.getElement().getInformationProvider()).setOutputs(this.outputs);
    }

    public void cancel() {
    }

    public class InputTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SubdialogPropertiesPanel.this.inputs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class InputTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SubdialogInformationProvider.SubdialogInput si = (SubdialogInformationProvider.SubdialogInput)element;
            if (columnIndex == 0) {
                return si.name;
            }
            if (si.type == 0) {
                return "\"" + si.value + "\"";
            }
            return si.value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class InputValueDialog
    extends FramedDialog {
        Text variableNameField;
        Button variableButton;
        TreeViewer variableViewer;
        Button staticValueButton;
        Text staticValueField;
        SubdialogInformationProvider.SubdialogInput value;
        Color darkBlue;
        Color lightBlue;
        String originalName;
        int originalType;
        String originalValue;
        List vars;

        public InputValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
            this.vars = SubdialogPropertiesPanel.this.getElement().getIncomingVariables();
        }

        public void setValue(SubdialogInformationProvider.SubdialogInput value) {
            this.value = value;
            this.originalName = value.name;
            this.originalType = value.type;
            this.originalValue = value.value;
        }

        public void updateValue() {
            this.value.name = this.variableNameField.getText();
            if (this.staticValueButton.getSelection()) {
                this.value.type = 0;
                this.value.value = this.staticValueField.getText();
            } else {
                this.value.type = 1;
                this.value.value = !this.variableViewer.getSelection().isEmpty() ? ((ObjectDefinition)((IStructuredSelection)this.variableViewer.getSelection()).getFirstElement()).getPath() : "";
            }
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 0x800000);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InputValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 0x800000);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    InputValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void okPressed() {
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.value.name = this.originalName;
            this.value.type = this.originalType;
            this.value.value = this.originalValue;
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    InputValueDialog.this.darkBlue.dispose();
                    InputValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Input Name");
            nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData();
            nameLabel.setLayoutData((Object)gd);
            this.variableNameField = new Text(parent, 2052);
            this.variableNameField.setText(this.value.name);
            this.variableNameField.setLayoutData((Object)new GridData(768));
            this.variableNameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    InputValueDialog.this.updateValue();
                }
            });
            this.variableButton = new Button(parent, 16);
            this.variableButton.setText("This variable's current value");
            this.variableButton.setBackground(parent.getBackground());
            this.variableButton.setSelection(this.value.type == 1);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.variableButton.setLayoutData((Object)gd);
            Tree variableTree = new Tree(parent, 67588);
            gd = new GridData(1808);
            gd.horizontalIndent = 10;
            gd.horizontalSpan = 2;
            variableTree.setLayoutData((Object)gd);
            this.variableViewer = new TreeViewer(variableTree);
            this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
            this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
            this.variableViewer.setInput((Object)this);
            this.staticValueButton = new Button(parent, 16);
            this.staticValueButton.setText("The value I've entered");
            this.staticValueButton.setBackground(parent.getBackground());
            this.staticValueButton.setSelection(this.value.type <= 0);
            gd = new GridData();
            this.staticValueButton.setLayoutData((Object)gd);
            this.staticValueField = new Text(parent, 2052);
            gd = new GridData(768);
            if (this.value.type == 1) {
                int i = 0;
                while (i < this.vars.size()) {
                    Variable v = (Variable)this.vars.get(i);
                    if (v.getName().equals(this.value.value)) {
                        this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                    } else if (this.value.value != null && this.value.value.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.value.value)) {
                                this.variableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            }
            this.staticValueField.setLayoutData((Object)gd);
            if (this.value.type == 0) {
                this.staticValueField.setText(this.value.value == null ? "" : this.value.value);
            }
            this.staticValueField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    InputValueDialog.this.updateValue();
                }
            });
            this.staticValueButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (InputValueDialog.this.staticValueButton.getSelection()) {
                        InputValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.variableButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (InputValueDialog.this.variableButton.getSelection()) {
                        InputValueDialog.this.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    InputValueDialog.this.updateValue();
                }
            });
        }

        public class VariableContentProvider
        implements ITreeContentProvider {
            public Object[] getElements(Object inputElement) {
                return InputValueDialog.this.vars.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((ObjectDefinition)parentElement).getFields().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof Variable) {
                    return null;
                }
                return ((ObjectField)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return true;
            }
        }

        public class VariableLabelProvider
        extends LabelProvider {
            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }

            public String getText(Object element) {
                return ((ObjectDefinition)element).getName();
            }
        }
    }

    public class OutputTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return SubdialogPropertiesPanel.this.outputs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class OutputTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SubdialogInformationProvider.SubdialogOutput so = (SubdialogInformationProvider.SubdialogOutput)element;
            if (columnIndex == 0) {
                return so.varName;
            }
            return so.valueName;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class OutputValueDialog
    extends FramedDialog {
        Text variableNameField;
        Text staticValueField;
        SubdialogInformationProvider.SubdialogOutput value;
        Color darkBlue;
        Color lightBlue;
        String originalName;
        String originalValue;

        public OutputValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
        }

        public void setValue(SubdialogInformationProvider.SubdialogOutput value) {
            this.value = value;
            this.originalName = value.varName;
            this.originalValue = value.valueName;
        }

        public void updateValue() {
            this.value.varName = this.variableNameField.getText();
            this.value.valueName = this.staticValueField.getText();
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 0x800000);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputValueDialog.this.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 0x800000);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OutputValueDialog.this.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void okPressed() {
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.value.varName = this.originalName;
            this.value.valueName = this.originalValue;
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    OutputValueDialog.this.darkBlue.dispose();
                    OutputValueDialog.this.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Target Variable Name");
            nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData();
            nameLabel.setLayoutData((Object)gd);
            this.variableNameField = new Text(parent, 2052);
            this.variableNameField.setText(this.value.varName);
            this.variableNameField.setLayoutData((Object)new GridData(768));
            this.variableNameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    OutputValueDialog.this.updateValue();
                }
            });
            Label valueLabel = new Label(parent, 0);
            valueLabel.setText("Subdialog Return Value");
            valueLabel.setBackground(parent.getBackground());
            gd = new GridData();
            valueLabel.setLayoutData((Object)gd);
            this.staticValueField = new Text(parent, 2052);
            this.staticValueField.setLayoutData((Object)new GridData(768));
            this.staticValueField.setText(this.value.valueName == null ? "" : this.value.valueName);
            this.staticValueField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    OutputValueDialog.this.updateValue();
                }
            });
        }
    }
}

