/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.properties.WebServiceCallSettingsListener;
import org.eclipse.vtp.desktop.editors.core.elements.properties.WebServiceCallSettingsStructure;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectField;
import org.eclipse.vtp.desktop.projects.core.IWebService;
import org.eclipse.vtp.desktop.projects.core.IWebServiceOperation;
import org.eclipse.vtp.desktop.projects.core.IWebServicePort;
import org.eclipse.vtp.desktop.projects.core.IWebServiceSet;

public class WebServiceCallInputPropertiesPanel
extends PrimitivePropertiesPanel
implements IStructuredContentProvider,
IDoubleClickListener,
WebServiceCallSettingsListener {
    private static final String TYPE_VALUE = "value";
    private static final String TYPE_VARIABLE = "variable";
    private final WebServiceCallSettingsStructure settings;
    private Composite stackComposite = null;
    private StackLayout stack = null;
    private Label noOperationLabel = null;
    private TableViewer viewer = null;
    private IWebServiceSet webServiceSet = null;
    private IWebServiceOperation webServiceOpertion = null;

    public WebServiceCallInputPropertiesPanel(PrimitiveElement wsce, WebServiceCallSettingsStructure settings) {
        super("Input", wsce);
        this.settings = settings;
        settings.addSettingsListener(this);
    }

    public void createControls(Composite parent) {
        this.webServiceSet = ((IApplicationProject)this.getElement().getModel().getDataService("IApplicationProject")).getWebServiceSet();
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setBackground(parent.getBackground());
        this.stack = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stack);
        this.noOperationLabel = new Label(this.stackComposite, 0);
        this.noOperationLabel.setBackground(this.stackComposite.getBackground());
        this.noOperationLabel.setText("Web service not configured");
        Table table = new Table(this.stackComposite, 67588);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Input Parameter");
        tableColumn.pack();
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Value");
        tableColumn.pack();
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(new String[]{"Field", "Value"});
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return element.toString();
                    }
                    case 1: {
                        return ((WebServiceInputItem)element).value;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }
        });
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        this.sourceWebServiceChanged();
        this.viewer.refresh();
    }

    public void save() {
    }

    public void cancel() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (!(inputElement instanceof IWebServiceOperation)) {
            return new Object[0];
        }
        IWebServiceOperation operation = (IWebServiceOperation)inputElement;
        LinkedList results = new LinkedList();
        String[] names = operation.getInputNames();
        int i = 0;
        while (i < names.length) {
            this.populateTable(operation, names[i], operation.getInput(names[i]), results);
            ++i;
        }
        return results.toArray();
    }

    private void populateTable(IWebServiceOperation operation, String path, FieldType type, List results) {
        if (FieldType.BOOLEAN.getTypeName().equals(type.getTypeName()) || FieldType.DATETIME.getTypeName().equals(type.getTypeName()) || FieldType.DECIMAL.getTypeName().equals(type.getTypeName()) || FieldType.NUMBER.getTypeName().equals(type.getTypeName()) || FieldType.STRING.getTypeName().equals(type.getTypeName()) || FieldType.BOOLEAN.getTypeName().equals(type.getTypeName())) {
            results.add(new WebServiceInputItem(path, type));
        } else {
            IBusinessObject obj = operation.getWebServicePort().getWebService().getWebServiceTypeSet().getBusinessObject("org.eclipse.vtp.framework.synthetic_ws." + operation.getWebServicePort().getWebService().getName().replace(' ', '_') + "." + type.getTypeName());
            if (obj == null) {
                return;
            }
            for (IBusinessObjectField field : obj.getFields()) {
                this.populateTable(operation, String.valueOf(path) + "." + field.getName(), field.getDataType(), results);
            }
        }
    }

    public void dispose() {
    }

    public void doubleClick(DoubleClickEvent event) {
        new InputValueDialog(this.viewer.getControl().getShell(), (WebServiceInputItem)((IStructuredSelection)event.getSelection()).getFirstElement()).open();
    }

    public void sourceWebServiceChanged() {
        IWebServiceOperation operation;
        IWebServicePort port;
        IWebService service;
        if (this.settings.sourceWebService != null && (service = this.webServiceSet.getWebService(this.settings.sourceWebService)) != null && this.settings.sourceWebServicePort != null && (port = service.getWebServicePort(this.settings.sourceWebServicePort)) != null && this.settings.sourceWebServiceOperation != null && (operation = port.getWebServiceOperation(this.settings.sourceWebServiceOperation)) != null) {
            if (this.webServiceOpertion != null && this.webServiceOpertion != operation) {
                this.settings.input.clear();
                this.settings.inputTypes.clear();
                this.settings.inputValues.clear();
            }
            if (this.settings.input.isEmpty()) {
                String[] names = operation.getInputNames();
                int i = 0;
                while (i < names.length) {
                    this.settings.input.add(names[i]);
                    ++i;
                }
            }
            this.webServiceOpertion = operation;
            this.viewer.setInput((Object)operation);
            this.stack.topControl = this.viewer.getTable();
            this.stackComposite.layout();
            return;
        }
        this.webServiceOpertion = null;
        this.viewer.setInput((Object)this);
        this.stack.topControl = this.noOperationLabel;
        this.stackComposite.layout();
    }

    public void targetChanged() {
    }

    private final class InputValueDialog
    extends Dialog {
        WebServiceInputItem item;
        private Button valueButton;
        private Text valueText;
        private Button variableButton;
        private Combo variableCombo;

        InputValueDialog(Shell parentShell, WebServiceInputItem item) {
            super(parentShell);
            this.item = item;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.getShell().setText("Edit the Value Information");
            this.getShell().pack();
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite comp = new Composite(composite, 0);
            comp.setLayoutData((Object)new GridData(1808));
            comp.setLayout((Layout)new GridLayout(2, false));
            this.valueButton = new Button(comp, 16);
            this.valueButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.valueButton.setText("Use a value:");
            this.valueText = new Text(comp, 2048);
            this.valueText.setLayoutData((Object)new GridData(4, 4, true, false));
            if (WebServiceCallInputPropertiesPanel.TYPE_VALUE.equals(this.item.valueType)) {
                this.valueButton.setSelection(true);
                this.valueText.setText(this.item.value);
            }
            this.variableButton = new Button(comp, 16);
            this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.variableButton.setText("Use a variable:");
            this.variableCombo = new Combo(comp, 4);
            this.variableCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            for (ObjectDefinition def : WebServiceCallInputPropertiesPanel.this.getElement().getIncomingVariables()) {
                if (def.getType().getTypeName().equals(this.item.type.getTypeName())) {
                    this.variableCombo.add(def.getName());
                    continue;
                }
                for (ObjectField field : def.getFields()) {
                    if (!field.getType().getTypeName().equals(this.item.type.getTypeName())) continue;
                    this.variableCombo.add(field.getPath());
                }
            }
            if (WebServiceCallInputPropertiesPanel.TYPE_VARIABLE.equals(this.item.valueType)) {
                this.variableButton.setSelection(true);
                this.variableCombo.select(this.variableCombo.indexOf(this.item.value));
            }
            return comp;
        }

        protected void okPressed() {
            if (this.valueButton.getSelection()) {
                this.item.valueType = WebServiceCallInputPropertiesPanel.TYPE_VALUE;
                this.item.value = this.valueText.getText();
            } else {
                this.item.valueType = WebServiceCallInputPropertiesPanel.TYPE_VARIABLE;
                this.item.value = this.variableCombo.getItem(this.variableCombo.getSelectionIndex());
            }
            this.item.save();
            super.okPressed();
        }
    }

    private final class WebServiceInputItem {
        private final String name;
        private final FieldType type;
        String valueType = "value";
        String value = "";

        WebServiceInputItem(String name, FieldType type) {
            this.name = name;
            this.type = type;
            if (((WebServiceCallInputPropertiesPanel)WebServiceCallInputPropertiesPanel.this).settings.inputTypes.containsKey(name)) {
                this.valueType = (String)((WebServiceCallInputPropertiesPanel)WebServiceCallInputPropertiesPanel.this).settings.inputTypes.get(name);
                this.value = (String)((WebServiceCallInputPropertiesPanel)WebServiceCallInputPropertiesPanel.this).settings.inputValues.get(name);
                if (this.value == null) {
                    this.value = "";
                }
            }
        }

        void save() {
            ((WebServiceCallInputPropertiesPanel)WebServiceCallInputPropertiesPanel.this).settings.inputTypes.put(this.name, this.valueType);
            ((WebServiceCallInputPropertiesPanel)WebServiceCallInputPropertiesPanel.this).settings.inputValues.put(this.name, this.value);
            WebServiceCallInputPropertiesPanel.this.viewer.refresh((Object)this);
        }

        public String toString() {
            return this.name;
        }
    }
}

