/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.editors.core.elements.properties.WebServiceCallSettingsListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServiceCallSettingsStructure
implements Cloneable {
    List listeners = new ArrayList();
    boolean targetVariableExists = true;
    String targetVariableName = null;
    int targetMultiplicity = 0;
    String targetVariableType = null;
    String sourceWebServiceLocator = null;
    String sourceWebService = null;
    String sourceWebServicePort = null;
    String sourceWebServiceOperation = null;
    List input = new ArrayList();
    Map inputTypes = new HashMap();
    Map inputValues = new HashMap();
    List dataMapping = new ArrayList();
    int resultLimit = -1;

    public boolean isComplete() {
        if (this.targetVariableName == null || this.targetVariableName.equals("")) {
            return false;
        }
        if (this.targetVariableType == null || this.targetVariableType.equals("")) {
            return false;
        }
        if (this.sourceWebService == null || this.sourceWebService.equals("")) {
            return false;
        }
        if (this.sourceWebServicePort == null || this.sourceWebServicePort.equals("")) {
            return false;
        }
        return this.sourceWebServiceOperation != null && !this.sourceWebServiceOperation.equals("");
    }

    public Object clone() {
        WebServiceCallSettingsStructure copy = new WebServiceCallSettingsStructure();
        copy.targetVariableExists = this.targetVariableExists;
        copy.targetVariableName = this.targetVariableName;
        copy.targetVariableType = this.targetVariableType;
        copy.targetMultiplicity = this.targetMultiplicity;
        copy.sourceWebServiceLocator = this.sourceWebServiceLocator;
        copy.sourceWebService = this.sourceWebService;
        copy.sourceWebServicePort = this.sourceWebServicePort;
        copy.sourceWebServiceOperation = this.sourceWebServiceOperation;
        copy.input.addAll(this.input);
        copy.inputTypes.putAll(this.inputTypes);
        copy.inputValues.putAll(this.inputValues);
        Iterator iterator = this.dataMapping.iterator();
        while (iterator.hasNext()) {
            copy.dataMapping.add(((DataMapping)iterator.next()).clone());
        }
        copy.resultLimit = this.resultLimit;
        return copy;
    }

    public void read(Element element) {
        Element dmElement;
        this.targetVariableExists = Boolean.valueOf(element.getAttribute("var-exists"));
        this.targetVariableName = element.getAttribute("var-name");
        this.targetVariableType = element.getAttribute("var-type");
        this.targetMultiplicity = Integer.parseInt(element.getAttribute("var-multi"));
        this.sourceWebServiceLocator = element.getAttribute("ws-locator");
        this.sourceWebService = element.getAttribute("ws-name");
        this.sourceWebServicePort = element.getAttribute("ws-port");
        this.sourceWebServiceOperation = element.getAttribute("ws-operation");
        NodeList nl = element.getElementsByTagName("input");
        int i = 0;
        while (i < nl.getLength()) {
            dmElement = (Element)nl.item(i);
            String name = dmElement.getAttribute("name");
            this.input.add(name);
            String type = dmElement.getAttribute("type");
            if (type != null && type.length() > 0) {
                this.inputTypes.put(name, type);
                this.inputValues.put(name, dmElement.getAttribute("value"));
            } else {
                NodeList nl2 = dmElement.getElementsByTagName("input");
                int j = 0;
                while (j < nl2.getLength()) {
                    Element nestedElement = (Element)nl2.item(j);
                    name = nestedElement.getAttribute("name");
                    this.inputTypes.put(name, nestedElement.getAttribute("type"));
                    this.inputValues.put(name, nestedElement.getAttribute("value"));
                    ++j;
                }
            }
            ++i;
        }
        nl = element.getElementsByTagName("mapping");
        i = 0;
        while (i < nl.getLength()) {
            dmElement = (Element)nl.item(i);
            DataMapping dm = new DataMapping(dmElement.getAttribute("name"), Integer.parseInt(dmElement.getAttribute("type")), dmElement.getAttribute("value"));
            this.dataMapping.add(dm);
            ++i;
        }
    }

    public void write(Element element) {
        element.setAttribute("var-exists", Boolean.toString(this.targetVariableExists));
        element.setAttribute("var-name", this.targetVariableName == null ? "" : this.targetVariableName);
        element.setAttribute("var-type", this.targetVariableType == null ? "" : this.targetVariableType);
        element.setAttribute("var-multi", Integer.toString(this.targetMultiplicity));
        element.setAttribute("ws-locator", this.sourceWebServiceLocator == null ? "" : this.sourceWebServiceLocator);
        element.setAttribute("ws-name", this.sourceWebService == null ? "" : this.sourceWebService);
        element.setAttribute("ws-port", this.sourceWebServicePort == null ? "" : this.sourceWebServicePort);
        element.setAttribute("ws-operation", this.sourceWebServiceOperation == null ? "" : this.sourceWebServiceOperation);
        Element inputElement = element.getOwnerDocument().createElement("inputs");
        element.appendChild(inputElement);
        for (String key : this.input) {
            Element inputItem = element.getOwnerDocument().createElement("input");
            inputElement.appendChild(inputItem);
            inputItem.setAttribute("name", key);
            if (this.inputTypes.containsKey(key)) {
                inputItem.setAttribute("type", (String)this.inputTypes.get(key));
                inputItem.setAttribute("value", (String)this.inputValues.get(key));
                continue;
            }
            for (String keyPath : this.inputTypes.keySet()) {
                if (!keyPath.startsWith(key)) continue;
                Element nestedInputItem = element.getOwnerDocument().createElement("input");
                inputItem.appendChild(nestedInputItem);
                nestedInputItem.setAttribute("name", keyPath);
                nestedInputItem.setAttribute("type", (String)this.inputTypes.get(keyPath));
                nestedInputItem.setAttribute("value", (String)this.inputValues.get(keyPath));
            }
        }
        Element mappingsElement = element.getOwnerDocument().createElement("mappings");
        element.appendChild(mappingsElement);
        int i = 0;
        while (i < this.dataMapping.size()) {
            DataMapping dm = (DataMapping)this.dataMapping.get(i);
            Element dmElement = mappingsElement.getOwnerDocument().createElement("mapping");
            mappingsElement.appendChild(dmElement);
            dmElement.setAttribute("name", dm.fieldName == null ? "" : dm.fieldName);
            dmElement.setAttribute("type", Integer.toString(dm.mappingType));
            dmElement.setAttribute("value", dm.mappingValue == null ? "" : dm.mappingValue);
            ++i;
        }
    }

    public void addSettingsListener(WebServiceCallSettingsListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void fireSourceChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((WebServiceCallSettingsListener)iterator.next()).sourceWebServiceChanged();
        }
    }

    public void fireTargetChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((WebServiceCallSettingsListener)iterator.next()).targetChanged();
        }
    }

    public boolean isTargetVariableExists() {
        return this.targetVariableExists;
    }

    public void setTargetVariableExists(boolean targetVariableExists) {
        this.targetVariableExists = targetVariableExists;
    }

    public String getTargetVariableName() {
        return this.targetVariableName;
    }

    public void setTargetVariableName(String targetVariableName) {
        this.targetVariableName = targetVariableName;
    }

    public int getTargetMultiplicity() {
        return this.targetMultiplicity;
    }

    public void setTargetMultiplicity(int targetMultiplicity) {
        this.targetMultiplicity = targetMultiplicity;
    }

    public String getTargetVariableType() {
        return this.targetVariableType;
    }

    public void setTargetVariableType(String targetVariableType) {
        this.targetVariableType = targetVariableType;
    }

    public class DataMapping
    implements Cloneable {
        String fieldName;
        int mappingType = 0;
        String mappingValue;

        public DataMapping(String fieldName, int mappingType, String mappingValue) {
            this.fieldName = fieldName;
            this.mappingType = mappingType;
            this.mappingValue = mappingValue;
        }

        public Object clone() {
            DataMapping copy = new DataMapping(this.fieldName, this.mappingType, this.mappingValue);
            return copy;
        }
    }
}

