/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.elements.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitivePropertiesPanel;
import org.eclipse.vtp.desktop.editors.core.elements.WebserviceCallInformationProvider;
import org.eclipse.vtp.desktop.editors.core.elements.properties.WebServiceCallSettingsStructure;
import org.eclipse.vtp.desktop.model.core.ObjectDefinition;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.model.core.Variable;
import org.eclipse.vtp.desktop.projects.core.FieldType;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;

public class WebServiceCallTargetVariablePropertiesPanel
extends PrimitivePropertiesPanel {
    WebServiceCallSettingsStructure settings;
    Button existingVariableButton;
    Button newVariableButton;
    TreeViewer existingVariableViewer;
    Text newVariableNameField;
    Combo multiplicityCombo;
    Combo typeCombo;
    List typeList;
    List incomingVariables;

    public WebServiceCallTargetVariablePropertiesPanel(PrimitiveElement wsce, WebServiceCallSettingsStructure settings) {
        super("Target Variable", wsce);
        this.settings = settings;
    }

    public void createControls(Composite parent) {
        this.incomingVariables = this.getElement().getIncomingVariables();
        final Font bold = new Font((Device)parent.getDisplay(), "Arial", 8, 1);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bold.dispose();
            }
        });
        this.existingVariableButton = new Button(parent, 16);
        this.existingVariableButton.setText("Existing Variable");
        this.existingVariableButton.setSelection(this.settings.targetVariableExists);
        this.existingVariableButton.setFont(bold);
        this.existingVariableButton.setBackground(parent.getBackground());
        Tree existingVariableTree = new Tree(parent, 67588);
        existingVariableTree.setHeaderVisible(true);
        existingVariableTree.setEnabled(this.settings.targetVariableExists);
        TreeColumn nameColumn = new TreeColumn(existingVariableTree, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(100);
        TreeColumn typeColumn = new TreeColumn(existingVariableTree, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(100);
        this.existingVariableViewer = new TreeViewer(existingVariableTree);
        this.existingVariableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.existingVariableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.existingVariableViewer.setInput((Object)this);
        if (this.settings.targetVariableExists) {
            int i = 0;
            while (i < this.incomingVariables.size()) {
                Variable v = (Variable)this.incomingVariables.get(i);
                if (v.getName().equals(this.settings.targetVariableName)) {
                    this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)v));
                } else if (this.settings.targetVariableName != null && this.settings.targetVariableName.startsWith(v.getName())) {
                    List objectFields = v.getFields();
                    int f = 0;
                    while (f < objectFields.size()) {
                        ObjectField of = (ObjectField)objectFields.get(f);
                        if (of.getPath().equals(this.settings.targetVariableName)) {
                            this.existingVariableViewer.setSelection((ISelection)new StructuredSelection((Object)of));
                        }
                        ++f;
                    }
                }
                ++i;
            }
        }
        this.newVariableButton = new Button(parent, 16);
        this.newVariableButton.setText("New Variable");
        this.newVariableButton.setSelection(!this.settings.targetVariableExists);
        this.newVariableButton.setFont(bold);
        this.newVariableButton.setBackground(parent.getBackground());
        Label newVariableNameLabel = new Label(parent, 0);
        newVariableNameLabel.setText("Name:");
        newVariableNameLabel.setBackground(parent.getBackground());
        this.newVariableNameField = new Text(parent, 2052);
        this.newVariableNameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = e.text;
                char[] chars = text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        if (!this.settings.targetVariableExists) {
            this.newVariableNameField.setText(this.settings.targetVariableName);
        }
        this.newVariableNameField.setEnabled(!this.settings.targetVariableExists);
        this.newVariableNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.getText().indexOf(46) != -1) {
                    WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.setForeground(WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.getDisplay().getSystemColor(3));
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = null;
                } else {
                    WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.setForeground(WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.getDisplay().getSystemColor(2));
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.getText();
                }
                WebServiceCallTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }
        });
        Label newVariableTypeLabel = new Label(parent, 0);
        newVariableTypeLabel.setText("Type:");
        newVariableTypeLabel.setBackground(parent.getBackground());
        this.multiplicityCombo = new Combo(parent, 12);
        this.multiplicityCombo.add("One of");
        this.multiplicityCombo.add("Array of");
        this.multiplicityCombo.setEnabled(!this.settings.targetVariableExists);
        if (!this.settings.targetVariableExists) {
            this.multiplicityCombo.select(this.settings.targetMultiplicity);
        } else {
            this.multiplicityCombo.select(0);
        }
        this.multiplicityCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = WebServiceCallTargetVariablePropertiesPanel.this.multiplicityCombo.getSelectionIndex();
                WebServiceCallTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeCombo = new Combo(parent, 12);
        this.typeList = new ArrayList();
        this.typeList.add("String");
        this.typeList.add("Number");
        this.typeList.add("Decimal");
        this.typeList.add("Boolean");
        this.typeList.add("DateTime");
        List bol = ((IApplicationProject)this.getElement().getModel().getDataService("IApplicationProject")).getBusinessObjectSet().getBusinessObjects();
        int i = 0;
        while (i < bol.size()) {
            this.typeList.add(((IBusinessObject)bol.get(i)).getName());
            ++i;
        }
        int sel = 0;
        int i2 = 0;
        while (i2 < this.typeList.size()) {
            this.typeCombo.add((String)this.typeList.get(i2));
            if (!this.settings.targetVariableExists && this.typeList.get(i2).equals(this.settings.targetVariableType)) {
                sel = i2;
            }
            ++i2;
        }
        this.typeCombo.setEnabled(!this.settings.targetVariableExists);
        this.typeCombo.select(sel);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = (String)WebServiceCallTargetVariablePropertiesPanel.this.typeList.get(WebServiceCallTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex());
                WebServiceCallTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData existingVariableButtonData = new FormData();
        existingVariableButtonData.left = new FormAttachment(0, 20);
        existingVariableButtonData.top = new FormAttachment(0, 10);
        existingVariableButtonData.right = new FormAttachment(100, -10);
        this.existingVariableButton.setLayoutData((Object)existingVariableButtonData);
        FormData existingVariableViewerData = new FormData();
        existingVariableViewerData.left = new FormAttachment(0, 20);
        existingVariableViewerData.top = new FormAttachment((Control)this.existingVariableButton, 10);
        existingVariableViewerData.right = new FormAttachment(100, -10);
        existingVariableViewerData.height = 80;
        this.existingVariableViewer.getControl().setLayoutData((Object)existingVariableViewerData);
        FormData newVariableButtonData = new FormData();
        newVariableButtonData.left = new FormAttachment(0, 20);
        newVariableButtonData.top = new FormAttachment(this.existingVariableViewer.getControl(), 20);
        newVariableButtonData.right = new FormAttachment(100, -10);
        this.newVariableButton.setLayoutData((Object)newVariableButtonData);
        FormData newVariableNameLabelData = new FormData();
        newVariableNameLabelData.left = new FormAttachment(0, 20);
        newVariableNameLabelData.top = new FormAttachment((Control)this.newVariableButton, 12);
        newVariableNameLabel.setLayoutData((Object)newVariableNameLabelData);
        FormData newVariableNameFieldData = new FormData();
        newVariableNameFieldData.left = new FormAttachment((Control)newVariableNameLabel, 10);
        newVariableNameFieldData.top = new FormAttachment((Control)this.newVariableButton, 10);
        newVariableNameFieldData.right = new FormAttachment(100, -10);
        this.newVariableNameField.setLayoutData((Object)newVariableNameFieldData);
        FormData newVariableTypeLabelData = new FormData();
        newVariableTypeLabelData.left = new FormAttachment(0, 20);
        newVariableTypeLabelData.top = new FormAttachment((Control)this.newVariableNameField, 10);
        newVariableTypeLabelData.right = new FormAttachment(100, -10);
        newVariableTypeLabel.setLayoutData((Object)newVariableTypeLabelData);
        FormData multiplicityComboData = new FormData();
        multiplicityComboData.left = new FormAttachment(0, 20);
        multiplicityComboData.top = new FormAttachment((Control)newVariableTypeLabel, 10);
        this.multiplicityCombo.setLayoutData((Object)multiplicityComboData);
        FormData typeComboData = new FormData();
        typeComboData.left = new FormAttachment((Control)this.multiplicityCombo, 20);
        typeComboData.top = new FormAttachment((Control)newVariableTypeLabel, 10);
        typeComboData.right = new FormAttachment(100, -10);
        this.typeCombo.setLayoutData((Object)typeComboData);
        this.existingVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = null;
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = 0;
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = null;
                } else if (selection.getFirstElement() instanceof Variable) {
                    Variable v = (Variable)selection.getFirstElement();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = v.getName();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = v.getType().isArray() ? 1 : 0;
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = v.getType().getTypeName();
                } else {
                    ObjectField field = (ObjectField)selection.getFirstElement();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = field.getPath();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = field.getType().isArray() ? 1 : 0;
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = field.getType().getTypeName();
                }
                WebServiceCallTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }
        });
        this.existingVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceCallTargetVariablePropertiesPanel.this.existingVariableViewer.getControl().setEnabled(WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.setEnabled(!WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                WebServiceCallTargetVariablePropertiesPanel.this.multiplicityCombo.setEnabled(!WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                WebServiceCallTargetVariablePropertiesPanel.this.typeCombo.setEnabled(!WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection());
                WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableExists = WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection();
                if (WebServiceCallTargetVariablePropertiesPanel.this.existingVariableButton.getSelection()) {
                    IStructuredSelection selection = (IStructuredSelection)WebServiceCallTargetVariablePropertiesPanel.this.existingVariableViewer.getSelection();
                    if (selection.isEmpty()) {
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = null;
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = 0;
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = null;
                    } else if (selection.getFirstElement() instanceof Variable) {
                        Variable v = (Variable)selection.getFirstElement();
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = v.getName();
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = v.getType().isArray() ? 1 : 0;
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = v.getType().getTypeName();
                    } else {
                        ObjectField field = (ObjectField)selection.getFirstElement();
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = field.getPath();
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = field.getType().isArray() ? 1 : 0;
                        WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = field.getType().getTypeName();
                    }
                } else {
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableName = WebServiceCallTargetVariablePropertiesPanel.this.newVariableNameField.getText();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetMultiplicity = WebServiceCallTargetVariablePropertiesPanel.this.multiplicityCombo.getSelectionIndex();
                    WebServiceCallTargetVariablePropertiesPanel.this.settings.targetVariableType = (String)WebServiceCallTargetVariablePropertiesPanel.this.typeList.get(WebServiceCallTargetVariablePropertiesPanel.this.typeCombo.getSelectionIndex());
                }
                WebServiceCallTargetVariablePropertiesPanel.this.settings.fireTargetChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
        Iterator i = this.settings.dataMapping.iterator();
        while (i.hasNext()) {
            WebServiceCallSettingsStructure.DataMapping cfr_ignored_0 = (WebServiceCallSettingsStructure.DataMapping)i.next();
        }
        ((WebserviceCallInformationProvider)this.getElement().getInformationProvider()).setSettings(this.settings);
    }

    public void cancel() {
    }

    public class VariableContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return WebServiceCallTargetVariablePropertiesPanel.this.incomingVariables.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Variable) {
                return null;
            }
            return ((ObjectField)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            return ((ObjectDefinition)parentElement).getFields().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ObjectDefinition)element).getName();
            }
            FieldType ft = ((ObjectDefinition)element).getType();
            String ret = "";
            if (ft.isArray()) {
                ret = "Array Of ";
            }
            ret = String.valueOf(ret) + ft.getTypeName();
            return ret;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

