/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.DefaultBrandManager;
import org.eclipse.vtp.desktop.editors.core.controller.BasicController;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.elements.DialogElement;
import org.eclipse.vtp.desktop.editors.core.elements.PrimitiveElement;
import org.eclipse.vtp.desktop.editors.core.impl.StubMediaProvider;
import org.eclipse.vtp.desktop.editors.core.model.DialogContainer;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.model.UIModel;
import org.eclipse.vtp.desktop.editors.core.theme.CanvasFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ElementFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ThemeManager;
import org.eclipse.vtp.desktop.model.core.ElementResolutionVisitor;
import org.eclipse.vtp.desktop.model.core.Model;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragmentProject;
import org.eclipse.vtp.desktop.views.canvas.CanvasBrowserContentProvider;
import org.eclipse.vtp.desktop.views.canvas.CanvasBrowserContentProviderListener;
import org.eclipse.vtp.desktop.views.canvas.IconicCanvas;
import org.eclipse.vtp.desktop.views.canvas.IconicCanvasListener;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApplicationFragmentEditor
extends EditorPart
implements ControllerListener,
RenderedModelListener,
DialogContainer,
CanvasBrowserContentProvider {
    RenderedModel renderedModel = null;
    boolean dirty = false;
    DefaultBrandManager brandManager = new DefaultBrandManager();
    List dialogModels = new ArrayList();
    Map resourceMap = new HashMap();
    List canvasRecords = new ArrayList();
    Map canvasRecordsByRenderedCanvas = new HashMap();
    CanvasRecord currentCanvas = null;
    CTabFolder canvasTabs = null;
    private List canvasBrowserContentProviderListeners = new ArrayList();

    public ApplicationFragmentEditor() {
        this.brandManager.addInteractionSupport("org.eclipse.vtp.framework.interactions.voice.interaction");
        this.brandManager.addSupportedLanguage("org.eclipse.vtp.framework.interactions.voice.interaction", "Default");
        Brand defaultBrand = new Brand("Default");
        defaultBrand.registerMediaProvider("org.eclipse.vtp.framework.interactions.voice.interaction", "Default", (IMediaProvider)new StubMediaProvider());
        this.brandManager.setDefaultBrand(defaultBrand);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        FileEditorInput fileInput = (FileEditorInput)input;
        try {
            NodeList designList;
            NodeList appList;
            if (DesktopCorePlugin.isApplicationFragmentProject((IProject)fileInput.getFile().getProject())) {
                IApplicationFragmentProject iap = DesktopCorePlugin.convertToApplicationFragment((IProject)fileInput.getFile().getProject());
                this.brandManager = (DefaultBrandManager)iap.getBrandManager();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileInput.getFile().getContents());
            Element rootElement = document.getDocumentElement();
            System.out.println(rootElement);
            if (!rootElement.getTagName().equals("fragment-definition")) {
                throw new IllegalArgumentException("The file provided is not a valid application definition file");
            }
            NodeList dialogsList = rootElement.getElementsByTagName("dialogs");
            if (dialogsList.getLength() > 0) {
                NodeList dialogList = ((Element)dialogsList.item(0)).getElementsByTagName("dialog");
                int i = 0;
                while (i < dialogList.getLength()) {
                    Element dialogElement = (Element)dialogList.item(i);
                    RenderedModel dialogRenderedModel = null;
                    try {
                        NodeList designList2;
                        Element rootElement2 = dialogElement;
                        NodeList dialogList2 = rootElement2.getElementsByTagName("model");
                        if (dialogList2.getLength() != 1) {
                            throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
                        }
                        Element modelElement = (Element)dialogList2.item(0);
                        Model dialogModel = new Model((BrandManager)this.brandManager, modelElement, null);
                        if (DesktopCorePlugin.isApplicationFragmentProject((IProject)fileInput.getFile().getProject())) {
                            IApplicationFragmentProject project = DesktopCorePlugin.convertToApplicationFragment((IProject)fileInput.getFile().getProject());
                            dialogModel.putDataService("IApplicationProject", (Object)project);
                        }
                        if ((designList2 = rootElement2.getElementsByTagName("design")).getLength() != 1) {
                            throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
                        }
                        Element designElement = (Element)designList2.item(0);
                        UIModel uiModel = new UIModel(dialogModel, designElement);
                        dialogRenderedModel = new RenderedModel(uiModel);
                        dialogRenderedModel.addListener(this);
                        this.dialogModels.add(new DialogModelRecord(dialogElement.getAttribute("id"), dialogRenderedModel));
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to read file", ex);
                    }
                    ++i;
                }
            }
            if ((appList = rootElement.getElementsByTagName("fragment")).getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element appElement = (Element)appList.item(0);
            NodeList dialogList = appElement.getElementsByTagName("model");
            if (dialogList.getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element modelElement = (Element)dialogList.item(0);
            DefaultElementResolver resolver = new DefaultElementResolver(this.dialogModels);
            Model dialogModel = new Model((BrandManager)this.brandManager, modelElement, (ElementResolutionVisitor)resolver);
            if (DesktopCorePlugin.isApplicationFragmentProject((IProject)fileInput.getFile().getProject())) {
                IApplicationFragmentProject project = DesktopCorePlugin.convertToApplicationFragment((IProject)fileInput.getFile().getProject());
                dialogModel.putDataService("IApplicationProject", (Object)project);
            }
            if ((designList = appElement.getElementsByTagName("design")).getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element designElement = (Element)designList.item(0);
            UIModel uiModel = new UIModel(dialogModel, designElement);
            this.renderedModel = new RenderedModel(uiModel);
            this.renderedModel.addListener(this);
            site.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new Action("Print"){

                public void run() {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    PrintDialog pd = new PrintDialog(workbenchShell);
                    pd.setStartPage(1);
                    pd.setEndPage(ApplicationFragmentEditor.this.renderedModel.getUIModel().listUICanvases().size());
                    PrinterData printerData = pd.open();
                    if (printerData != null) {
                        Printer printer = new Printer(printerData);
                        printer.startJob("Print Callflow");
                        List canvases = ApplicationFragmentEditor.this.listCanvases();
                        int i = printerData.startPage - 1;
                        while (i < Math.min(printerData.endPage, canvases.size())) {
                            IconicRenderedCanvas irc = (IconicRenderedCanvas)canvases.get(i);
                            printer.startPage();
                            Point dpi = printer.getDPI();
                            System.out.println("printer dpi: " + dpi.x + ", " + dpi.y);
                            float scaleX = (float)dpi.x / 96.0f;
                            float scaleY = (float)dpi.y / 96.0f;
                            Rectangle clientArea = printer.getClientArea();
                            System.out.println("Client Area: " + clientArea);
                            int printerOrientation = clientArea.width > clientArea.height ? 2 : 1;
                            GC gc = new GC((Drawable)printer);
                            Transform transform = new Transform((Device)printer);
                            if (scaleX != 1.0f || scaleY != 1.0f) {
                                transform.scale(scaleX, scaleY);
                            }
                            if (irc.canvas.getUICanvas().getOrientation() != printerOrientation) {
                                transform.translate((float)(irc.canvas.getUICanvas().getHeight() / 2), (float)(irc.canvas.getUICanvas().getHeight() / 2));
                                transform.rotate(90.0f);
                                transform.translate(-1.0f * (float)irc.canvas.getUICanvas().getHeight() / 2.0f, -1.0f * (float)irc.canvas.getUICanvas().getHeight() / 2.0f);
                            }
                            gc.setTransform(transform);
                            gc.setLineWidth(1);
                            irc.render(gc, 16);
                            transform.dispose();
                            gc.dispose();
                            printer.endPage();
                            ++i;
                        }
                        printer.endJob();
                        printer.dispose();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new PartInitException("Unable to read file", (Throwable)ex);
        }
    }

    public void createPartControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArrayList values = new ArrayList();
                values.addAll(ApplicationFragmentEditor.this.resourceMap.values());
                int i = 0;
                while (i < values.size()) {
                    if (values.get(i) instanceof Resource) {
                        ((Resource)values.get(i)).dispose();
                    }
                    ++i;
                }
                ApplicationFragmentEditor.this.resourceMap.clear();
            }
        });
        GC gc = new GC((Drawable)parent);
        this.renderedModel.initializeGraphics(gc, this.resourceMap);
        gc.dispose();
        this.canvasTabs = new CTabFolder(parent, 1024);
        List renderedCanvases = this.renderedModel.listRenderedCanvases();
        int i = 0;
        while (i < renderedCanvases.size()) {
            RenderedCanvas renderedCanvas = (RenderedCanvas)renderedCanvases.get(i);
            CanvasRecord cr = new CanvasRecord(renderedCanvas);
            CTabItem canvasTab = new CTabItem(this.canvasTabs, 0);
            canvasTab.setText(renderedCanvas.getUICanvas().getName());
            canvasTab.setControl(cr.createControls((Composite)this.canvasTabs));
            canvasTab.setData((Object)cr);
            if (i == 0) {
                this.canvasTabs.setSelection(0);
                this.currentCanvas = cr;
            }
            this.canvasRecords.add(cr);
            this.canvasRecordsByRenderedCanvas.put(renderedCanvas, cr);
            ++i;
        }
        this.canvasTabs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = ApplicationFragmentEditor.this.canvasTabs.getSelection();
                CanvasRecord oldCanvas = ApplicationFragmentEditor.this.currentCanvas;
                ApplicationFragmentEditor.this.currentCanvas = (CanvasRecord)item.getData();
                oldCanvas.iconicCanvas.fireUpdate();
                ApplicationFragmentEditor.this.currentCanvas.iconicCanvas.fireUpdate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        parent.setLayout((Layout)new FillLayout());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "fragment-definition", null);
            Element rootElement = document.getDocumentElement();
            Element appElement = rootElement.getOwnerDocument().createElement("fragment");
            rootElement.appendChild(appElement);
            this.renderedModel.getUIModel().getModel().storeModel(appElement);
            this.renderedModel.getUIModel().storeUIModel(appElement);
            Element dialogsElement = rootElement.getOwnerDocument().createElement("dialogs");
            rootElement.appendChild(dialogsElement);
            int i = 0;
            while (i < this.dialogModels.size()) {
                DialogModelRecord dmr = (DialogModelRecord)this.dialogModels.get(i);
                Element dialogElement = dialogsElement.getOwnerDocument().createElement("dialog");
                dialogsElement.appendChild(dialogElement);
                dialogElement.setAttribute("id", dmr.id);
                dmr.renderedModel.getUIModel().getModel().storeModel(dialogElement);
                dmr.renderedModel.getUIModel().storeUIModel(dialogElement);
                ++i;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transfactory = TransformerFactory.newInstance();
            Transformer t = transfactory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            PrintWriter pw = new PrintWriter(baos);
            t.transform(new DOMSource(document), new XMLWriter(pw).toXMLResult());
            pw.flush();
            fileInput.getFile().setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void setFocus() {
    }

    public void graphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        this.currentCanvas.canvas.redraw(x, y, width, height, false);
        if (!inProgress) {
            this.currentCanvas.iconicCanvas.fireUpdate();
        }
    }

    public void renderedModelChanged(RenderedModel renderedModel) {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void selectionChanged(SelectionStructure selection) {
    }

    public RenderedModel addDialog(String id, URL template) {
        System.out.println("adding model: " + id + " " + template);
        RenderedModel dialogRenderedModel = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            System.out.println(builder.getDOMImplementation().toString());
            System.out.println("supports namespaces: " + builder.isNamespaceAware());
            Document document = builder.parse(template.openStream());
            Element rootElement = document.getDocumentElement();
            if (!rootElement.getTagName().equals("dialog-definition")) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            NodeList dialogList = rootElement.getElementsByTagName("model");
            if (dialogList.getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element modelElement = (Element)dialogList.item(0);
            Model dialogModel = new Model((BrandManager)this.brandManager, modelElement, null);
            NodeList designList = rootElement.getElementsByTagName("design");
            if (designList.getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element designElement = (Element)designList.item(0);
            UIModel uiModel = new UIModel(dialogModel, designElement);
            dialogRenderedModel = new RenderedModel(uiModel);
            dialogRenderedModel.addListener(this);
            this.dialogModels.add(new DialogModelRecord(id, dialogRenderedModel));
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read file", ex);
        }
        return dialogRenderedModel;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(CanvasBrowserContentProvider.class)) {
            return this;
        }
        if (adapter.equals(DialogContainer.class)) {
            return this;
        }
        if (adapter.equals(IResource.class)) {
            return ((FileEditorInput)this.getEditorInput()).getFile();
        }
        return super.getAdapter(adapter);
    }

    public void addListener(CanvasBrowserContentProviderListener listener) {
        this.canvasBrowserContentProviderListeners.remove(listener);
        this.canvasBrowserContentProviderListeners.add(listener);
    }

    public List listCanvases() {
        ArrayList<IconicRenderedCanvas> ret = new ArrayList<IconicRenderedCanvas>();
        int i = 0;
        while (i < this.canvasRecords.size()) {
            ret.add(((CanvasRecord)this.canvasRecords.get((int)i)).iconicCanvas);
            ++i;
        }
        return ret;
    }

    public void removeListener(CanvasBrowserContentProviderListener listener) {
        this.canvasBrowserContentProviderListeners.remove(listener);
    }

    public void selectCanvas(IconicCanvas canvas) {
        System.out.println("canvas selection changed");
        int i = 0;
        while (i < this.canvasRecords.size()) {
            CanvasRecord cr = (CanvasRecord)this.canvasRecords.get(i);
            if (cr.iconicCanvas == canvas) {
                CanvasRecord oldCanvas = this.currentCanvas;
                this.currentCanvas = cr;
                oldCanvas.iconicCanvas.fireUpdate();
                ((IconicRenderedCanvas)canvas).fireUpdate();
                this.canvasTabs.setSelection(i);
            }
            ++i;
        }
    }

    public IconicCanvas addCanvas(String name) {
        UICanvas newCanvas = new UICanvas(this.renderedModel.getUIModel(), name);
        this.renderedModel.getUIModel().addCanvas(newCanvas);
        RenderedCanvas renderedCanvas = this.renderedModel.addRenderedCanvas(newCanvas);
        CanvasRecord cr = new CanvasRecord(renderedCanvas);
        CTabItem canvasTab = new CTabItem(this.canvasTabs, 0);
        canvasTab.setText(renderedCanvas.getUICanvas().getName());
        canvasTab.setControl(cr.createControls((Composite)this.canvasTabs));
        this.canvasRecords.add(cr);
        this.canvasRecordsByRenderedCanvas.put(renderedCanvas, cr);
        this.dirty = true;
        this.firePropertyChange(257);
        return cr.iconicCanvas;
    }

    public void deleteCanvas(IconicCanvas canvas) {
        int i = 0;
        while (i < this.canvasRecords.size()) {
            CanvasRecord cr = (CanvasRecord)this.canvasRecords.get(i);
            if (cr.iconicCanvas == canvas) {
                this.canvasRecords.remove(cr);
                this.canvasRecordsByRenderedCanvas.remove(cr.renderedCanvas);
                this.canvasTabs.getItem(i).dispose();
                cr.dispose();
                this.canvasTabs.layout();
                cr.renderedCanvas.getUICanvas().delete();
                this.dirty = true;
                this.firePropertyChange(257);
            }
            ++i;
        }
    }

    public boolean supportsMultipleCanvases() {
        return true;
    }

    private class CanvasRecord
    implements RenderedCanvasListener {
        RenderedCanvas renderedCanvas;
        IconicRenderedCanvas iconicCanvas;
        CanvasFrame canvasFrame;
        Composite canvasFrameComp;
        Canvas canvas;
        BasicController controller;
        ScrolledComposite sc;

        public CanvasRecord(RenderedCanvas renderedCanvas) {
            System.out.println(renderedCanvas);
            this.renderedCanvas = renderedCanvas;
            renderedCanvas.addListener(this);
            this.iconicCanvas = new IconicRenderedCanvas(renderedCanvas);
            List elementFrames = renderedCanvas.getElementFrames();
            for (ElementFrame ef : elementFrames) {
                org.eclipse.vtp.desktop.model.core.Element el = ef.getUIElement().getElement();
                if (!(el instanceof PrimitiveElement) || !((PrimitiveElement)el).getTypeId().equals("org.eclipse.vtp.desktop.editors.core.beginFragment")) continue;
                this.iconicCanvas.primary = true;
                break;
            }
            this.controller = new BasicController((BrandManager)ApplicationFragmentEditor.this.brandManager, renderedCanvas);
            this.controller.setResourceMap(ApplicationFragmentEditor.this.resourceMap);
            this.controller.setContainer((IAdaptable)ApplicationFragmentEditor.this);
            this.canvasFrame = ThemeManager.getDefault().getDefaultTheme().createCanvasFrame(renderedCanvas.getUICanvas());
        }

        public Control createControls(Composite parent) {
            this.sc = new ScrolledComposite(parent, 768);
            this.sc.getVerticalBar().setIncrement(8);
            this.sc.getVerticalBar().setPageIncrement(15);
            this.canvasFrameComp = new Composite((Composite)this.sc, 0x20040000);
            this.sc.setContent((Control)this.canvasFrameComp);
            this.canvasFrameComp.setLayout((Layout)new FormLayout());
            this.canvasFrameComp.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    System.out.println("canvas frame composite resized: " + CanvasRecord.this.canvasFrameComp.getBounds());
                    CanvasRecord.this.canvasFrame.setBounds(CanvasRecord.this.canvasFrameComp.getBounds());
                }
            });
            this.canvasFrameComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    HashMap resourceMap = new HashMap();
                    CanvasRecord.this.canvasFrame.renderFrame(e.gc, 0, 0, resourceMap);
                }
            });
            this.sc.setMinSize(this.renderedCanvas.getUICanvas().getWidth() + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, this.renderedCanvas.getUICanvas().getHeight() + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
            this.sc.setExpandVertical(true);
            this.sc.setExpandHorizontal(true);
            this.canvas = new Canvas(this.canvasFrameComp, 0x20000000);
            this.canvas.setBackground(parent.getDisplay().getSystemColor(1));
            FormData fd = new FormData();
            fd.left = new FormAttachment(50, -1 * this.renderedCanvas.getUICanvas().getWidth() / 2);
            fd.top = new FormAttachment(50, -1 * this.renderedCanvas.getUICanvas().getHeight() / 2);
            fd.right = new FormAttachment(50, this.renderedCanvas.getUICanvas().getWidth() / 2);
            fd.bottom = new FormAttachment(50, this.renderedCanvas.getUICanvas().getHeight() / 2);
            this.canvas.setLayoutData((Object)fd);
            this.controller.setControl((Control)this.canvas);
            this.canvas.addPaintListener((PaintListener)this.controller);
            this.canvas.addMouseListener((MouseListener)this.controller);
            this.canvas.addMouseMoveListener((MouseMoveListener)this.controller);
            this.canvas.addMouseTrackListener((MouseTrackListener)this.controller);
            this.canvas.addKeyListener((KeyListener)this.controller);
            this.controller.addListener(ApplicationFragmentEditor.this);
            this.hookContextMenu();
            return this.sc;
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    CanvasRecord.this.fillContextMenu(manager);
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)this.canvas);
            this.canvas.setMenu(menu);
        }

        private void fillContextMenu(IMenuManager manager) {
            this.controller.fillContextMenu(manager);
        }

        public void dispose() {
            this.sc.dispose();
        }

        public void renderedCanvasChanged(RenderedCanvas renderedCanvas) {
        }

        public void renderedCanvasDeleted(RenderedCanvas renderedCanvas) {
        }

        public void renderedCanvasFormatChanged(RenderedCanvas renderedCanvas) {
            this.sc.setMinSize(renderedCanvas.getUICanvas().getWidth() + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, renderedCanvas.getUICanvas().getHeight() + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
            FormData fd = new FormData();
            fd.left = new FormAttachment(50, -1 * renderedCanvas.getUICanvas().getWidth() / 2);
            fd.top = new FormAttachment(50, -1 * renderedCanvas.getUICanvas().getHeight() / 2);
            fd.right = new FormAttachment(50, renderedCanvas.getUICanvas().getWidth() / 2);
            fd.bottom = new FormAttachment(50, renderedCanvas.getUICanvas().getHeight() / 2);
            this.canvas.setLayoutData((Object)fd);
            this.sc.layout(true, true);
            this.canvasFrameComp.layout();
            ApplicationFragmentEditor.this.dirty = true;
            ApplicationFragmentEditor.this.firePropertyChange(257);
        }
    }

    public class DefaultElementResolver
    implements ElementResolutionVisitor {
        private List dialogModels;

        public DefaultElementResolver(List dialogModels) {
            this.dialogModels = dialogModels;
        }

        public void resolveElement(org.eclipse.vtp.desktop.model.core.Element element) {
            if (element instanceof DialogElement) {
                int d = 0;
                while (d < this.dialogModels.size()) {
                    DialogModelRecord dmr = (DialogModelRecord)this.dialogModels.get(d);
                    if (dmr.id.equals(element.getId())) {
                        ((DialogElement)element).setDialogModel(dmr.renderedModel);
                    }
                    ++d;
                }
            }
        }
    }

    private class DialogModelRecord {
        String id;
        RenderedModel renderedModel;

        public DialogModelRecord(String id, RenderedModel renderedModel) {
            this.id = id;
            this.renderedModel = renderedModel;
        }
    }

    private class IconicRenderedCanvas
    implements IconicCanvas {
        RenderedCanvas canvas;
        List iconListeners = new ArrayList();
        boolean primary = false;

        public IconicRenderedCanvas(RenderedCanvas canvas) {
            this.canvas = canvas;
        }

        public String getCanvasName() {
            return this.canvas.getUICanvas().getName();
        }

        public void setCanvasName(String newName) {
            this.canvas.getUICanvas().setName(newName);
        }

        public int getCanvasWidth() {
            return this.canvas.getUICanvas().getWidth();
        }

        public int getCanvasHeight() {
            return this.canvas.getUICanvas().getHeight();
        }

        public int getOrientation() {
            return this.canvas.getUICanvas().getOrientation();
        }

        public void addListener(IconicCanvasListener listener) {
            this.iconListeners.remove(listener);
            this.iconListeners.add(listener);
        }

        public void removeListener(IconicCanvasListener listener) {
            this.iconListeners.remove(listener);
        }

        public void render(GC gc, int options) {
            this.canvas.paintCanvas(gc, ApplicationFragmentEditor.this.resourceMap, options);
        }

        public void fireUpdate() {
            for (IconicCanvasListener listener : this.iconListeners) {
                listener.canvasUpdated((IconicCanvas)this);
            }
        }

        public boolean isPrimaryCanvas() {
            return this.primary;
        }

        public boolean isSelectedCanvas() {
            return ApplicationFragmentEditor.this.currentCanvas.iconicCanvas == this;
        }
    }
}

