/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.editors.core.impl.ConnectorPropertiesListener;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;

public class ConnectorPropertiesPanel
extends ComponentPropertiesPanel {
    private Connector connector;
    Label instructionLabel;
    Combo hookSelection;
    TableViewer pathViewer = null;
    List hookItems = new ArrayList();
    List exits = new ArrayList();
    List epListeners = new ArrayList();

    public ConnectorPropertiesPanel(Connector connector) {
        super("General");
        this.connector = connector;
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setBackground(parent.getBackground());
        List freeExits = this.connector.getOrigin().getConnectorRecords(ConnectorRecord.EXIT_POINT | ConnectorRecord.ERROR_POINT);
        List currentPoints = this.connector.getExitCodes();
        LinkedList<Wrapper> curWraps = new LinkedList<Wrapper>();
        int i = 0;
        while (i < currentPoints.size()) {
            Wrapper wrapper = new Wrapper((ConnectorRecord)currentPoints.get(i));
            this.exits.add(wrapper);
            curWraps.add(wrapper);
            ++i;
        }
        for (ConnectorRecord cr : freeExits) {
            if (cr.getConnector() != null) continue;
            this.exits.add(new Wrapper(cr));
        }
        if (this.exits.size() > 0) {
            comp.setLayout((Layout)new FormLayout());
            this.instructionLabel = new Label(comp, 0);
            this.instructionLabel.setBackground(comp.getBackground());
            this.instructionLabel.setText("Please select the event(s) that will initiate this call flow.");
            FormData instructionLabelData = new FormData();
            instructionLabelData.left = new FormAttachment(0, 10);
            instructionLabelData.right = new FormAttachment(100, -10);
            instructionLabelData.top = new FormAttachment(0, 10);
            this.instructionLabel.setLayoutData((Object)instructionLabelData);
            Table pathTable = new Table(comp, 68098);
            final TableColumn pathNameColumn = new TableColumn(pathTable, 0);
            pathNameColumn.setText("Path Name");
            pathNameColumn.setWidth(300);
            pathTable.setHeaderVisible(false);
            pathTable.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent arg0) {
                }

                public void controlResized(ControlEvent arg0) {
                    pathNameColumn.setWidth(ConnectorPropertiesPanel.this.pathViewer.getTable().getClientArea().width);
                }
            });
            this.pathViewer = new TableViewer(pathTable);
            this.pathViewer.setContentProvider((IContentProvider)new PathContentProvider());
            this.pathViewer.setLabelProvider((IBaseLabelProvider)new PathLabelProvider());
            this.pathViewer.setInput((Object)this);
            this.pathViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ConnectorPropertiesPanel.this.fireEndPointUpdate();
                }
            });
            FormData resultSelectionData = new FormData();
            resultSelectionData.left = new FormAttachment(0, 10);
            resultSelectionData.top = new FormAttachment((Control)this.instructionLabel, 10);
            resultSelectionData.right = new FormAttachment(100, -10);
            resultSelectionData.bottom = new FormAttachment((Control)this.instructionLabel, 120);
            pathTable.setLayoutData((Object)resultSelectionData);
            this.pathViewer.setSelection((ISelection)new StructuredSelection(curWraps));
            this.fireEndPointUpdate();
        } else {
            comp.setLayout((Layout)new GridLayout(1, false));
            Label noneAvailableLabel = new Label(comp, 0);
            noneAvailableLabel.setText("There are no available exits from the source element");
            noneAvailableLabel.setBackground(comp.getBackground());
            noneAvailableLabel.setForeground(comp.getDisplay().getSystemColor(3));
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 0x1000000;
            noneAvailableLabel.setLayoutData((Object)gd);
        }
    }

    public void save() {
        this.connector.clearExitCodes();
        if (this.exits.size() > 0) {
            IStructuredSelection selection = (IStructuredSelection)this.pathViewer.getSelection();
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                ConnectorRecord record = ((Wrapper)i.next()).getRecord();
                this.connector.addExitPoint(record);
            }
        }
    }

    public void cancel() {
    }

    public void addEndPointListener(ConnectorPropertiesListener cepc) {
        System.out.println("adding end point listener: " + cepc);
        this.epListeners.remove(cepc);
        this.epListeners.add(cepc);
    }

    public void removeEndPointListener(ConnectorPropertiesListener cepc) {
        this.epListeners.remove(cepc);
    }

    private void fireEndPointUpdate() {
        System.out.println("firing selection change");
        int i = 0;
        while (i < this.epListeners.size()) {
            ((ConnectorPropertiesListener)this.epListeners.get(i)).exitPointSelectionChanged(this.getEndPoints());
            ++i;
        }
    }

    public List getEndPoints() {
        ArrayList<ConnectorRecord> ret = new ArrayList<ConnectorRecord>();
        IStructuredSelection selection = (IStructuredSelection)this.pathViewer.getSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            ConnectorRecord record = ((Wrapper)i.next()).getRecord();
            ret.add(record);
        }
        return ret;
    }

    public void setConfigurationContext(Brand brand, String interactionType, String language) {
    }

    public class PathContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ConnectorPropertiesPanel.this.exits.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class PathLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class Wrapper {
        private ConnectorRecord record;

        public Wrapper(ConnectorRecord record) {
            this.record = record;
        }

        public ConnectorRecord getRecord() {
            return this.record;
        }

        public String toString() {
            String ret = this.record.getName();
            if (this.record.getConnector() != null && this.record.getConnector() == ConnectorPropertiesPanel.this.connector) {
                ret = String.valueOf(ret) + " (Current)";
            }
            return ret;
        }
    }
}

